/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.fixStack;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.optimization.fixStack.FixStackValue;
import org.jetbrains.kotlin.codegen.optimization.fixStack.SavedStackDescriptor;
import shadow.org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.InsnList;
import shadow.org.jetbrains.org.objectweb.asm.tree.InsnNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.MethodNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import shadow.org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import shadow.org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import shadow.org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000V\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a!\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u001a)\u0010\u0005\u001a\u0004\u0018\u0001H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u001a<\u0010\t\u001a\u00020\u0007\"\b\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u0007H\u0002\u001a*\u0010\u000e\u001a\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u000f\"\b\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u0006\u0010\f\u001a\u00020\u0007\u001a2\u0010\u000e\u001a\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u000f\"\b\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007\u001a\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u001e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a.\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0007\u001a\u001e\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u001e\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0000\u001a\u00020$\u001a\u0016\u0010%\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0017\u001a\u0016\u0010'\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u0017\u001a,\u0010(\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u00072\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000f\u00a8\u0006+"}, d2={"top", "V", "Lshadow/org/jetbrains/org/objectweb/asm/tree/analysis/Value;", "Lshadow/org/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "(Lshadow/org/jetbrains/org/objectweb/asm/tree/analysis/Frame;)Lshadow/org/jetbrains/org/objectweb/asm/tree/analysis/Value;", "peek", "offset", "", "(Lshadow/org/jetbrains/org/objectweb/asm/tree/analysis/Frame;I)Lshadow/org/jetbrains/org/objectweb/asm/tree/analysis/Value;", "peekWordsTo", "dest", "", "size", "offset0", "peekWords", "", "size1", "size2", "saveStack", "", "methodNode", "Lshadow/org/jetbrains/org/objectweb/asm/tree/MethodNode;", "nodeToReplace", "Lshadow/org/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "savedStackDescriptor", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/SavedStackDescriptor;", "restoreStack", "location", "restoreStackWithReturnValue", "returnValue", "Lorg/jetbrains/kotlin/codegen/optimization/fixStack/FixStackValue;", "returnValueLocalVarIndex", "generateLoadInstructions", "generateStoreInstructions", "getPopInstruction", "Lshadow/org/jetbrains/org/objectweb/asm/tree/InsnNode;", "Lshadow/org/jetbrains/org/objectweb/asm/tree/analysis/BasicValue;", "removeAlwaysFalseIfeq", "node", "replaceAlwaysTrueIfeqWithGoto", "replaceMarkerWithPops", "expectedStackSize", "stackContent", "backend"})
public final class StackTransformationUtilsKt {
    @Nullable
    public static final <V extends Value> V top(@NotNull Frame<V> $this$top) {
        Intrinsics.checkNotNullParameter($this$top, "<this>");
        return StackTransformationUtilsKt.peek($this$top, 0);
    }

    @Nullable
    public static final <V extends Value> V peek(@NotNull Frame<V> $this$peek, int offset) {
        Intrinsics.checkNotNullParameter($this$peek, "<this>");
        return $this$peek.getStackSize() > offset ? (V)$this$peek.getStack($this$peek.getStackSize() - offset - 1) : null;
    }

    private static final <V extends Value> int peekWordsTo(Frame<V> $this$peekWordsTo, List<V> dest, int size, int offset0) {
        int totalSize;
        V value2;
        int offset = offset0;
        for (totalSize = 0; totalSize < size; totalSize += value2.getSize()) {
            if (StackTransformationUtilsKt.peek($this$peekWordsTo, offset++) == null) {
                return -1;
            }
            dest.add(value2);
        }
        if (totalSize > size) {
            return -1;
        }
        return offset;
    }

    static /* synthetic */ int peekWordsTo$default(Frame frame, List list, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        return StackTransformationUtilsKt.peekWordsTo(frame, list, n2, n3);
    }

    @Nullable
    public static final <V extends Value> List<V> peekWords(@NotNull Frame<V> $this$peekWords, int size) {
        Intrinsics.checkNotNullParameter($this$peekWords, "<this>");
        ArrayList result2 = new ArrayList(size);
        return StackTransformationUtilsKt.peekWordsTo$default($this$peekWords, result2, size, 0, 4, null) < 0 ? null : (List)result2;
    }

    @Nullable
    public static final <V extends Value> List<V> peekWords(@NotNull Frame<V> $this$peekWords, int size1, int size2) {
        Intrinsics.checkNotNullParameter($this$peekWords, "<this>");
        ArrayList result2 = new ArrayList(size1 + size2);
        int offset = StackTransformationUtilsKt.peekWordsTo$default($this$peekWords, result2, size1, 0, 4, null);
        if (offset < 0) {
            return null;
        }
        if (StackTransformationUtilsKt.peekWordsTo($this$peekWords, result2, size2, offset) < 0) {
            return null;
        }
        return result2;
    }

    public static final void saveStack(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode nodeToReplace, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        Intrinsics.checkNotNullParameter(nodeToReplace, "nodeToReplace");
        Intrinsics.checkNotNullParameter(savedStackDescriptor, "savedStackDescriptor");
        InsnList $this$saveStack_u24lambda_u240 = methodNode.instructions;
        boolean bl = false;
        StackTransformationUtilsKt.generateStoreInstructions(methodNode, nodeToReplace, savedStackDescriptor);
        $this$saveStack_u24lambda_u240.remove(nodeToReplace);
    }

    public static final void restoreStack(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(savedStackDescriptor, "savedStackDescriptor");
        InsnList $this$restoreStack_u24lambda_u240 = methodNode.instructions;
        boolean bl = false;
        StackTransformationUtilsKt.generateLoadInstructions(methodNode, location, savedStackDescriptor);
        $this$restoreStack_u24lambda_u240.remove(location);
    }

    public static final void restoreStackWithReturnValue(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode nodeToReplace, @NotNull SavedStackDescriptor savedStackDescriptor, @NotNull FixStackValue returnValue, int returnValueLocalVarIndex) {
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        Intrinsics.checkNotNullParameter(nodeToReplace, "nodeToReplace");
        Intrinsics.checkNotNullParameter(savedStackDescriptor, "savedStackDescriptor");
        Intrinsics.checkNotNullParameter(returnValue, "returnValue");
        InsnList $this$restoreStackWithReturnValue_u24lambda_u240 = methodNode.instructions;
        boolean bl = false;
        $this$restoreStackWithReturnValue_u24lambda_u240.insertBefore(nodeToReplace, new VarInsnNode(returnValue.getStoreOpcode(), returnValueLocalVarIndex));
        StackTransformationUtilsKt.generateLoadInstructions(methodNode, nodeToReplace, savedStackDescriptor);
        $this$restoreStackWithReturnValue_u24lambda_u240.insertBefore(nodeToReplace, new VarInsnNode(returnValue.getLoadOpcode(), returnValueLocalVarIndex));
        $this$restoreStackWithReturnValue_u24lambda_u240.remove(nodeToReplace);
    }

    public static final void generateLoadInstructions(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(savedStackDescriptor, "savedStackDescriptor");
        int localVarIndex = savedStackDescriptor.getFirstLocalVarIndex();
        for (FixStackValue value2 : savedStackDescriptor.getSavedValues()) {
            methodNode.instructions.insertBefore(location, new VarInsnNode(value2.getLoadOpcode(), localVarIndex));
            localVarIndex += value2.getSize();
        }
    }

    public static final void generateStoreInstructions(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode location, @NotNull SavedStackDescriptor savedStackDescriptor) {
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(savedStackDescriptor, "savedStackDescriptor");
        int localVarIndex = savedStackDescriptor.getFirstUnusedLocalVarIndex();
        for (FixStackValue value2 : CollectionsKt.asReversed(savedStackDescriptor.getSavedValues())) {
            methodNode.instructions.insertBefore(location, new VarInsnNode(value2.getStoreOpcode(), localVarIndex -= value2.getSize()));
        }
    }

    @NotNull
    public static final InsnNode getPopInstruction(@NotNull BasicValue top) {
        int n2;
        Intrinsics.checkNotNullParameter(top, "top");
        switch (top.getSize()) {
            case 1: {
                n2 = 87;
                break;
            }
            case 2: {
                n2 = 88;
                break;
            }
            default: {
                throw new AssertionError((Object)"Unexpected value type size");
            }
        }
        return new InsnNode(n2);
    }

    public static final void removeAlwaysFalseIfeq(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node) {
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        Intrinsics.checkNotNullParameter(node, "node");
        InsnList $this$removeAlwaysFalseIfeq_u24lambda_u240 = methodNode.instructions;
        boolean bl = false;
        $this$removeAlwaysFalseIfeq_u24lambda_u240.remove(node.getNext());
        $this$removeAlwaysFalseIfeq_u24lambda_u240.remove(node);
    }

    public static final void replaceAlwaysTrueIfeqWithGoto(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node) {
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        Intrinsics.checkNotNullParameter(node, "node");
        InsnList $this$replaceAlwaysTrueIfeqWithGoto_u24lambda_u240 = methodNode.instructions;
        boolean bl = false;
        AbstractInsnNode abstractInsnNode = node.getNext();
        Intrinsics.checkNotNull(abstractInsnNode, "null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
        JumpInsnNode next = (JumpInsnNode)abstractInsnNode;
        $this$replaceAlwaysTrueIfeqWithGoto_u24lambda_u240.insertBefore(node, new JumpInsnNode(167, next.label));
        $this$replaceAlwaysTrueIfeqWithGoto_u24lambda_u240.remove(node);
        $this$replaceAlwaysTrueIfeqWithGoto_u24lambda_u240.remove(next);
    }

    public static final void replaceMarkerWithPops(@NotNull MethodNode methodNode, @NotNull AbstractInsnNode node, int expectedStackSize, @NotNull List<? extends FixStackValue> stackContent) {
        Intrinsics.checkNotNullParameter(methodNode, "methodNode");
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(stackContent, "stackContent");
        InsnList $this$replaceMarkerWithPops_u24lambda_u240 = methodNode.instructions;
        boolean bl = false;
        for (FixStackValue fixStackValue : stackContent.subList(expectedStackSize, stackContent.size())) {
            $this$replaceMarkerWithPops_u24lambda_u240.insert(node, new InsnNode(fixStackValue.getPopOpcode()));
        }
        $this$replaceMarkerWithPops_u24lambda_u240.remove(node);
    }
}

