/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationTargetUtil;
import org.jetbrains.kotlin.com.intellij.codeInsight.AnnotationUtil;
import org.jetbrains.kotlin.com.intellij.codeInsight.Nullability;
import org.jetbrains.kotlin.com.intellij.codeInsight.NullabilityAnnotationInfo;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Ref;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public abstract class NullableNotNullManager {
    protected static final Logger LOG = Logger.getInstance(NullableNotNullManager.class);
    protected final Project myProject;

    protected NullableNotNullManager(Project project) {
        this.myProject = project;
    }

    @NotNull
    public abstract Optional<Nullability> getAnnotationNullability(String var1);

    public abstract boolean isTypeUseAnnotationLocationRestricted(String var1);

    public abstract boolean canAnnotateLocals(String var1);

    public static NullableNotNullManager getInstance(Project project) {
        return project.getService(NullableNotNullManager.class);
    }

    public abstract void setNotNulls(String ... var1);

    public abstract void setNullables(String ... var1);

    @NotNull
    public abstract String getDefaultNullable();

    public abstract void setDefaultNullable(@NotNull String var1);

    @NotNull
    public abstract String getDefaultNotNull();

    public void copyNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(0);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(1);
        }
        if ((info = this.findOwnNullabilityInfo(original)) == null || info.getNullability() != Nullability.NOT_NULL) {
            return;
        }
        NullableNotNullManager.copyAnnotation(info.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo info;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(2);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(3);
        }
        if ((info = this.findOwnNullabilityInfo(original)) == null || info.getNullability() != Nullability.NULLABLE) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(info.getAnnotation(), generated);
    }

    @Nullable
    public PsiAnnotation copyNullableOrNotNullAnnotation(@NotNull PsiModifierListOwner original, @NotNull PsiModifierListOwner generated) {
        NullabilityAnnotationInfo src;
        if (original == null) {
            NullableNotNullManager.$$$reportNull$$$0(4);
        }
        if (generated == null) {
            NullableNotNullManager.$$$reportNull$$$0(5);
        }
        if ((src = this.findOwnNullabilityInfo(original)) == null) {
            return null;
        }
        NullabilityAnnotationInfo effective = this.findEffectiveNullabilityInfo(generated);
        if (effective != null && effective.getNullability() == src.getNullability()) {
            return null;
        }
        return NullableNotNullManager.copyAnnotation(src.getAnnotation(), generated);
    }

    @Nullable
    private static PsiAnnotation copyAnnotation(@NotNull PsiAnnotation annotation, @NotNull PsiModifierListOwner target) {
        String qualifiedName2;
        if (annotation == null) {
            NullableNotNullManager.$$$reportNull$$$0(6);
        }
        if (target == null) {
            NullableNotNullManager.$$$reportNull$$$0(7);
        }
        if ((qualifiedName2 = annotation.getQualifiedName()) != null) {
            if (JavaPsiFacade.getInstance(annotation.getProject()).findClass(qualifiedName2, target.getResolveScope()) == null) {
                return null;
            }
            PsiModifierList modifierList2 = target.getModifierList();
            if (modifierList2 != null && !AnnotationTargetUtil.isStrictlyTypeUseAnnotation(modifierList2, annotation) && !modifierList2.hasAnnotation(qualifiedName2)) {
                return modifierList2.addAnnotation(qualifiedName2);
            }
        }
        return null;
    }

    public abstract void setDefaultNotNull(@NotNull String var1);

    @Nullable
    public NullabilityAnnotationInfo findOwnNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(8);
        }
        if ((info = this.findEffectiveNullabilityInfo(owner)) == null || info.isContainer() || info.getInheritedFrom() != null) {
            return null;
        }
        return info;
    }

    @Nullable
    public NullabilityAnnotationInfo findExplicitNullability(PsiModifierListOwner owner) {
        NullabilityAnnotationInfo result2 = this.findPlainAnnotation(owner, false, true, this.getAllNullabilityAnnotationsWithNickNames());
        if (result2 != null) {
            return result2;
        }
        return this.findContainerAnnotation(owner);
    }

    @Nullable
    public NullabilityAnnotationInfo findEffectiveNullabilityInfo(@NotNull PsiModifierListOwner owner) {
        PsiType type2;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(9);
        }
        if ((type2 = PsiUtil.getTypeByPsiElement(owner)) == null || TypeConversionUtil.isPrimitiveAndNotNull(type2)) {
            return null;
        }
        return (NullabilityAnnotationInfo)CachedValuesManager.getCachedValue(owner, () -> CachedValueProvider.Result.create(this.doFindEffectiveNullabilityAnnotation(owner), PsiModificationTracker.MODIFICATION_COUNT));
    }

    @Nullable
    private NullabilityAnnotationInfo doFindEffectiveNullabilityAnnotation(@NotNull PsiModifierListOwner owner) {
        List<PsiParameter> superParameters;
        NullabilityAnnotationInfo defaultInfo;
        boolean lambdaParameter;
        NullabilityAnnotationInfo result2;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(10);
        }
        if ((result2 = this.findPlainAnnotation(owner, true, false, this.getAllNullabilityAnnotationsWithNickNames())) != null) {
            return result2;
        }
        boolean bl = lambdaParameter = owner instanceof PsiParameter && owner.getParent() instanceof PsiParameterList && owner.getParent().getParent() instanceof PsiLambdaExpression;
        if (!lambdaParameter && (defaultInfo = this.findNullityDefaultFiltered(owner)) != null) {
            return defaultInfo;
        }
        if (owner instanceof PsiParameter && !(superParameters = AnnotationUtil.getSuperAnnotationOwners((PsiParameter)owner)).isEmpty()) {
            for (PsiParameter parameter : superParameters) {
                NullabilityAnnotationInfo plain = this.findPlainAnnotation(parameter, false, false, this.getAllNullabilityAnnotationsWithNickNames());
                if (plain != null) {
                    return null;
                }
                NullabilityAnnotationInfo defaultInfo2 = this.findContainerAnnotation(parameter);
                if (defaultInfo2 == null) continue;
                return defaultInfo2.getNullability() == Nullability.NOT_NULL ? defaultInfo2.withInheritedFrom(parameter) : null;
            }
            return null;
        }
        if (lambdaParameter) {
            return this.findNullityDefaultFiltered(owner);
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo findNullityDefaultFiltered(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo defaultInfo;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(11);
        }
        if (!((defaultInfo = this.findContainerAnnotation(owner)) == null || defaultInfo.getNullability() != Nullability.NULLABLE && this.hasHardcodedContracts(owner))) {
            return defaultInfo;
        }
        return null;
    }

    @Nullable
    public PsiAnnotation findExplicitNullabilityAnnotation(@NotNull PsiModifierListOwner owner, @NotNull Collection<Nullability> nullabilities) {
        NullabilityAnnotationDataHolder holder;
        Set filteredSet;
        NullabilityAnnotationDataHolder filtered;
        NullabilityAnnotationInfo result2;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(12);
        }
        if (nullabilities == null) {
            NullableNotNullManager.$$$reportNull$$$0(13);
        }
        return (result2 = this.findPlainAnnotation(owner, false, false, filtered = new NullabilityAnnotationDataHolder(){
            final /* synthetic */ Set val$filteredSet;
            final /* synthetic */ NullabilityAnnotationDataHolder val$holder;
            final /* synthetic */ Collection val$nullabilities;
            {
                this.val$filteredSet = set;
                this.val$holder = nullabilityAnnotationDataHolder;
                this.val$nullabilities = collection;
            }

            @Override
            public Set<String> qualifiedNames() {
                return this.val$filteredSet;
            }

            @Override
            @Nullable
            public Nullability getNullability(String annotation) {
                Nullability origNullability = this.val$holder.getNullability(annotation);
                return this.val$nullabilities.contains((Object)origNullability) ? origNullability : null;
            }
        })) == null || !nullabilities.contains((Object)result2.getNullability()) ? null : result2.getAnnotation();
    }

    @Nullable
    private NullabilityAnnotationInfo findPlainAnnotation(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean skipExternal, NullabilityAnnotationDataHolder annotations2) {
        PsiAnnotation annotation;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(14);
        }
        AnnotationUtil.AnnotationAndOwner memberAnno = checkBases && owner instanceof PsiMethod ? AnnotationUtil.findAnnotationAndOwnerInHierarchy(owner, annotations2.qualifiedNames(), skipExternal) : ((annotation = AnnotationUtil.findAnnotation(owner, annotations2.qualifiedNames(), skipExternal)) == null ? null : new AnnotationUtil.AnnotationAndOwner(owner, annotation));
        PsiType type2 = PsiUtil.getTypeByPsiElement(owner);
        if (memberAnno != null && type2 instanceof PsiArrayType && !AnnotationUtil.isInferredAnnotation(memberAnno.annotation) && !AnnotationUtil.isExternalAnnotation(memberAnno.annotation) && AnnotationTargetUtil.isTypeAnnotation(memberAnno.annotation)) {
            memberAnno = null;
        }
        if (memberAnno != null) {
            Nullability nullability = annotations2.getNullability(memberAnno.annotation.getQualifiedName());
            if (nullability == null) {
                return null;
            }
            nullability = this.correctNullability(nullability, memberAnno.annotation);
            if (type2 != null) {
                for (PsiAnnotation typeAnno : type2.getApplicableAnnotations()) {
                    Nullability typeNullability;
                    if (typeAnno == memberAnno.annotation || (typeNullability = annotations2.getNullability(typeAnno.getQualifiedName())) == null) continue;
                    if (typeNullability != nullability) {
                        return null;
                    }
                    memberAnno = new AnnotationUtil.AnnotationAndOwner(owner, typeAnno);
                    break;
                }
            }
            return new NullabilityAnnotationInfo(memberAnno.annotation, nullability, memberAnno.owner == owner ? null : memberAnno.owner, false);
        }
        if (type2 instanceof PsiPrimitiveType) {
            return null;
        }
        return this.findAnnotationInTypeHierarchy(type2, annotations2);
    }

    @NotNull
    protected Nullability correctNullability(@NotNull Nullability nullability, @NotNull PsiAnnotation annotation) {
        if (nullability == null) {
            NullableNotNullManager.$$$reportNull$$$0(15);
        }
        if (annotation == null) {
            NullableNotNullManager.$$$reportNull$$$0(16);
        }
        Nullability nullability2 = nullability;
        if (nullability2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(17);
        }
        return nullability2;
    }

    @NotNull
    protected List<String> getNullablesWithNickNames() {
        List<String> list = this.getNullables();
        if (list == null) {
            NullableNotNullManager.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    protected List<String> getNotNullsWithNickNames() {
        List<String> list = this.getNotNulls();
        if (list == null) {
            NullableNotNullManager.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    protected abstract NullabilityAnnotationDataHolder getAllNullabilityAnnotationsWithNickNames();

    protected boolean hasHardcodedContracts(@NotNull PsiElement element) {
        if (element == null) {
            NullableNotNullManager.$$$reportNull$$$0(20);
        }
        return false;
    }

    public boolean isNullable(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(21);
        }
        return (info = this.findEffectiveNullabilityInfo(owner)) != null && info.getNullability() == Nullability.NULLABLE && (checkBases || info.getInheritedFrom() == null);
    }

    public boolean isNotNull(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(22);
        }
        return (info = this.findEffectiveNullabilityInfo(owner)) != null && info.getNullability() == Nullability.NOT_NULL && (checkBases || info.getInheritedFrom() == null);
    }

    @Nullable
    public NullabilityAnnotationInfo findDefaultTypeUseNullability(@Nullable PsiElement context2) {
        if (context2 == null) {
            return null;
        }
        if (context2.getParent() instanceof PsiTypeElement && context2.getParent().getParent() instanceof PsiLocalVariable) {
            return null;
        }
        return this.findNullabilityDefault(context2, PsiAnnotation.TargetType.TYPE_USE);
    }

    @Nullable
    public NullabilityAnnotationInfo findContainerAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(23);
        }
        return this.findNullabilityDefault(owner, AnnotationTargetUtil.getTargetsForLocation(owner.getModifierList()));
    }

    @Nullable
    private NullabilityAnnotationInfo findNullabilityDefault(@NotNull PsiElement place, PsiAnnotation.TargetType ... placeTargetTypes) {
        if (place == null) {
            NullableNotNullManager.$$$reportNull$$$0(24);
        }
        if (placeTargetTypes == null) {
            NullableNotNullManager.$$$reportNull$$$0(25);
        }
        for (PsiElement element = place.getContext(); element != null; element = element.getContext()) {
            NullabilityAnnotationInfo result2;
            if (element instanceof PsiModifierListOwner && (result2 = this.getNullityDefault((PsiModifierListOwner)element, placeTargetTypes, place, false)) != null) {
                return result2;
            }
            if (!(element instanceof PsiClassOwner)) continue;
            String packageName2 = ((PsiClassOwner)element).getPackageName();
            PsiPackage psiPackage = JavaPsiFacade.getInstance(element.getProject()).findPackage(packageName2);
            NullabilityAnnotationInfo fromPackage = this.findNullityDefaultOnPackage(placeTargetTypes, psiPackage, place);
            if (fromPackage != null) {
                return fromPackage;
            }
            return this.findNullityDefaultOnModule(placeTargetTypes, element);
        }
        return null;
    }

    @Nullable
    protected NullabilityAnnotationInfo findNullityDefaultOnModule(@NotNull PsiAnnotation.TargetType @NotNull [] types2, @NotNull PsiElement element) {
        if (element == null) {
            NullableNotNullManager.$$$reportNull$$$0(26);
        }
        if (types2 == null) {
            NullableNotNullManager.$$$reportNull$$$0(27);
        }
        return null;
    }

    @Nullable
    private NullabilityAnnotationInfo findNullityDefaultOnPackage(PsiAnnotation.TargetType @NotNull [] placeTargetTypes, @Nullable PsiPackage psiPackage, PsiElement context2) {
        if (placeTargetTypes == null) {
            NullableNotNullManager.$$$reportNull$$$0(28);
        }
        boolean superPackage = false;
        while (psiPackage != null) {
            NullabilityAnnotationInfo onPkg = this.getNullityDefault(psiPackage, placeTargetTypes, context2, superPackage);
            if (onPkg != null) {
                return onPkg;
            }
            superPackage = true;
            psiPackage = psiPackage.getParentPackage();
        }
        return null;
    }

    @Nullable
    abstract NullabilityAnnotationInfo getNullityDefault(@NotNull PsiModifierListOwner var1, PsiAnnotation.TargetType @NotNull [] var2, @NotNull PsiElement var3, boolean var4);

    @NotNull
    public abstract List<String> getNullables();

    @NotNull
    public abstract List<String> getNotNulls();

    public static boolean isNullable(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(29);
        }
        return NullableNotNullManager.getNullability(owner) == Nullability.NULLABLE;
    }

    public static boolean isNotNull(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(30);
        }
        return NullableNotNullManager.getNullability(owner) == Nullability.NOT_NULL;
    }

    @NotNull
    public static Nullability getNullability(@NotNull PsiModifierListOwner owner) {
        NullabilityAnnotationInfo info;
        if (owner == null) {
            NullableNotNullManager.$$$reportNull$$$0(31);
        }
        Nullability nullability = (info = NullableNotNullManager.getInstance(owner.getProject()).findEffectiveNullabilityInfo(owner)) == null ? Nullability.UNKNOWN : info.getNullability();
        if (nullability == null) {
            NullableNotNullManager.$$$reportNull$$$0(32);
        }
        return nullability;
    }

    public abstract @Unmodifiable @NotNull List<String> getInstrumentedNotNulls();

    public abstract void setInstrumentedNotNulls(@NotNull List<String> var1);

    public static boolean isNullabilityAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            NullableNotNullManager.$$$reportNull$$$0(33);
        }
        return NullableNotNullManager.getInstance(annotation.getProject()).getAllNullabilityAnnotationsWithNickNames().getNullability(annotation.getQualifiedName()) != null;
    }

    @Contract(value="null, _ -> null")
    @Nullable
    private NullabilityAnnotationInfo findAnnotationInTypeHierarchy(@Nullable PsiType type2, @NotNull NullabilityAnnotationDataHolder qualifiedNames) {
        if (qualifiedNames == null) {
            NullableNotNullManager.$$$reportNull$$$0(34);
        }
        if (type2 == null) {
            return null;
        }
        Ref<Object> result2 = Ref.create(null);
        InheritanceUtil.processSuperTypes(type2, true, eachType -> {
            NullabilityAnnotationInfo info;
            for (PsiAnnotation annotation : eachType.getAnnotations()) {
                String qualifiedName2 = annotation.getQualifiedName();
                if (!qualifiedNames.qualifiedNames().contains(qualifiedName2)) continue;
                Nullability nullability = qualifiedNames.getNullability(qualifiedName2);
                if (nullability != null) {
                    nullability = this.correctNullability(nullability, annotation);
                    result2.set(new NullabilityAnnotationInfo(annotation, nullability, false));
                }
                return false;
            }
            if (!(eachType instanceof PsiClassType)) {
                return true;
            }
            PsiClass targetClass = PsiUtil.resolveClassInClassTypeOnly(eachType);
            if (!(targetClass instanceof PsiTypeParameter)) {
                return false;
            }
            if (targetClass.getExtendsListTypes().length == 0 && (info = this.findNullabilityDefault(targetClass, PsiAnnotation.TargetType.TYPE_PARAMETER)) != null) {
                result2.set(info);
                return false;
            }
            return true;
        });
        return result2.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 32: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generated";
                break;
            }
            case 6: 
            case 16: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullabilities";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/codeInsight/NullableNotNullManager";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeTargetTypes";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedNames";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/NullableNotNullManager";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "correctNullability";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullablesWithNickNames";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullsWithNickNames";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullability";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyNotNullAnnotation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyNullableAnnotation";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "copyNullableOrNotNullAnnotation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findOwnNullabilityInfo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findEffectiveNullabilityInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doFindEffectiveNullabilityAnnotation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findNullityDefaultFiltered";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findExplicitNullabilityAnnotation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findPlainAnnotation";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "correctNullability";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 32: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasHardcodedContracts";
                break;
            }
            case 21: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isNullable";
                break;
            }
            case 22: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isNotNull";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findContainerAnnotation";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findNullabilityDefault";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findNullityDefaultOnModule";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findNullityDefaultOnPackage";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getNullability";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isNullabilityAnnotation";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationInTypeHierarchy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface NullabilityAnnotationDataHolder {
        public Set<String> qualifiedNames();

        @Nullable
        public Nullability getNullability(String var1);
    }
}

