/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.extensions.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.com.intellij.openapi.components.ComponentManager;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.DefaultPluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionPointName;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionsArea;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginId;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionsAreaImplKt;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.InterfaceExtensionPoint;
import org.jetbrains.kotlin.com.intellij.util.containers.UtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0012J@\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000b\"\b\b\u0000\u0010\u0018*\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0003J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001f\"\b\b\u0000\u0010\u0018*\u00020\r2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u00180!H\u0016J \u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000b\"\b\b\u0000\u0010\u0018*\u00020\r2\u0006\u0010 \u001a\u00020\u0007H\u0016J\"\u0010\"\u001a\n\u0012\u0004\u0012\u0002H\u0018\u0018\u00010\u000b\"\b\b\u0000\u0010\u0018*\u00020\r2\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0014\u0010#\u001a\u00020\u001c2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0016J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0012\u0010$\u001a\u00020\u00122\b\u0010%\u001a\u0004\u0018\u00010\u0000H\u0007J \u0010&\u001a\u00020\u00122\u0016\u0010'\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\u00120(H\u0017J,\u0010)\u001a\u00020\u00122\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0007J(\u0010)\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020.2\u0006\u00101\u001a\u00020\u001cH\u0017J\u001e\u00102\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\f\u00103\u001a\b\u0012\u0004\u0012\u00020504H\u0007J\u001c\u00102\u001a\u00020\u00122\f\u00106\u001a\b\u0012\u0004\u0012\u000207042\u0006\u0010\u0014\u001a\u00020\u0015J(\u00108\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000b\"\b\b\u0000\u0010\u0018*\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J>\u00109\u001a\b\u0012\u0004\u0012\u0002H\u00180\u000b\"\b\b\u0000\u0010\u0018*\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00072\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180:2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00101\u001a\u00020\u001cH\u0007J\u001e\u0010;\u001a\u00020\u00122\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nJ\u001c\u0010<\u001a\u00020\u00122\f\u0010=\u001a\b\u0012\u0004\u0012\u000207042\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010>\u001a\u00020\u0007H\u0016J\u0010\u0010?\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0007H\u0017J\u001c\u0010@\u001a\u00020\u00122\f\u0010=\u001a\b\u0012\u0004\u0012\u000207042\u0006\u0010\u0014\u001a\u00020\u0015J6\u0010A\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010B\u001a\n\u0012\u0006\b\u0000\u0012\u00020D0C2\u000e\u0010E\u001a\n\u0012\u0006\b\u0000\u0012\u00020D0CR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006F"}, d2={"Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionsAreaImpl;", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/ExtensionsArea;", "componentManager", "Lorg/jetbrains/kotlin/com/intellij/openapi/components/ComponentManager;", "(Lcom/intellij/openapi/components/ComponentManager;)V", "epTraces", "Ljava/util/HashMap;", "", "", "extensionPoints", "", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/impl/ExtensionPointImpl;", "lock", "", "nameToPointMap", "getNameToPointMap", "()Ljava/util/Map;", "checkThatPointNotDuplicated", "", "pointName", "pluginDescriptor", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/PluginDescriptor;", "clearUserCache", "doRegisterExtensionPoint", "T", "name", "extensionClass", "isInterface", "", "dynamic", "getExtensionPoint", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/ExtensionPoint;", "extensionPointName", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/ExtensionPointName;", "getExtensionPointIfRegistered", "hasExtensionPoint", "notifyAreaReplaced", "newArea", "processExtensionPoints", "consumer", "Lkotlin/Function1;", "registerExtensionPoint", "extensionPoint", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/BaseExtensionPointName;", "extensionPointBeanClass", "kind", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/ExtensionPoint$Kind;", "parentDisposable", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "isDynamic", "registerExtensionPoints", "extensionPointElements", "", "Lorg/jetbrains/kotlin/org/jdom/Element;", "points", "Lorg/jetbrains/kotlin/com/intellij/openapi/extensions/ExtensionPointDescriptor;", "registerFakeBeanPoint", "registerPoint", "Ljava/lang/Class;", "reset", "resetExtensionPoints", "descriptors", "toString", "unregisterExtensionPoint", "unregisterExtensionPoints", "unregisterExtensions", "priorityListenerCallbacks", "", "Ljava/lang/Runnable;", "listenerCallbacks", "intellij.platform.extensions"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nExtensionsAreaImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtensionsAreaImpl.kt\ncom/intellij/openapi/extensions/impl/ExtensionsAreaImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,306:1\n1855#2,2:307\n*S KotlinDebug\n*F\n+ 1 ExtensionsAreaImpl.kt\ncom/intellij/openapi/extensions/impl/ExtensionsAreaImpl\n*L\n287#1:307,2\n*E\n"})
public final class ExtensionsAreaImpl
implements ExtensionsArea {
    @NotNull
    private final ComponentManager componentManager;
    @NotNull
    private volatile Map<String, ? extends ExtensionPointImpl<?>> extensionPoints;
    @Nullable
    private final HashMap<String, Throwable> epTraces;
    @NotNull
    private final Object lock;

    public ExtensionsAreaImpl(@NotNull ComponentManager componentManager) {
        Intrinsics.checkNotNullParameter(componentManager, "componentManager");
        this.componentManager = componentManager;
        Map map2 = Collections.emptyMap();
        Intrinsics.checkNotNullExpressionValue(map2, "emptyMap(...)");
        this.extensionPoints = map2;
        this.epTraces = null;
        this.lock = new Object();
    }

    @NotNull
    public Map<String, ExtensionPointImpl<?>> getNameToPointMap() {
        return this.extensionPoints;
    }

    @TestOnly
    public final void notifyAreaReplaced(@Nullable ExtensionsAreaImpl newArea) {
        HashSet<String> processedEPs = new HashSet<String>(this.extensionPoints.size());
        for (ExtensionPointImpl<?> point : this.extensionPoints.values()) {
            point.notifyAreaReplaced(this);
            processedEPs.add(point.name);
        }
        if (newArea == null) {
            return;
        }
        for (ExtensionPointImpl<?> point : newArea.extensionPoints.values()) {
            if (processedEPs.contains(point.name)) continue;
            point.notifyAreaReplaced(this);
        }
    }

    @Override
    @TestOnly
    public void registerExtensionPoint(@NotNull String extensionPointName, @NotNull String extensionPointBeanClass, @NotNull ExtensionPoint.Kind kind, boolean isDynamic) {
        Intrinsics.checkNotNullParameter(extensionPointName, "extensionPointName");
        Intrinsics.checkNotNullParameter(extensionPointBeanClass, "extensionPointBeanClass");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        DefaultPluginDescriptor pluginDescriptor = new DefaultPluginDescriptor(PluginId.getId("fakeIdForTests"));
        this.doRegisterExtensionPoint(extensionPointName, extensionPointBeanClass, pluginDescriptor, kind == ExtensionPoint.Kind.INTERFACE, isDynamic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    private final <T> ExtensionPointImpl<T> doRegisterExtensionPoint(String name2, String extensionClass, PluginDescriptor pluginDescriptor, boolean isInterface, boolean dynamic) {
        ExtensionPointImpl extensionPointImpl;
        if (isInterface) {
            ComponentManager componentManager = this.componentManager;
            extensionPointImpl = new InterfaceExtensionPoint(name2, extensionClass, pluginDescriptor, componentManager, null, dynamic, false);
        } else {
            extensionPointImpl = new BeanExtensionPoint(name2, extensionClass, pluginDescriptor, this.componentManager, dynamic);
        }
        ExtensionPointImpl point = extensionPointImpl;
        this.checkThatPointNotDuplicated(name2, point.getPluginDescriptor());
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.extensionPoints = UtilKt.with(this.extensionPoints, name2, point);
            Unit unit = Unit.INSTANCE;
        }
        return point;
    }

    private final void checkThatPointNotDuplicated(String pointName, PluginDescriptor pluginDescriptor) {
        ExtensionPointImpl<?> extensionPointImpl = this.extensionPoints.get(pointName);
        if (extensionPointImpl == null) {
            return;
        }
        PluginId pluginId = extensionPointImpl.getPluginDescriptor().getPluginId();
        Intrinsics.checkNotNullExpressionValue(pluginId, "getPluginId(...)");
        PluginId id1 = pluginId;
        PluginId pluginId2 = pluginDescriptor.getPluginId();
        Intrinsics.checkNotNullExpressionValue(pluginId2, "getPluginId(...)");
        PluginId id2 = pluginId2;
        String message2 = "Duplicate registration for EP '" + pointName + "': first in " + id1 + ", second in " + id2;
        RuntimeException runtimeException = this.componentManager.createError(message2, pluginDescriptor.getPluginId());
        Intrinsics.checkNotNullExpressionValue(runtimeException, "createError(...)");
        throw (Throwable)runtimeException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerExtensionPoints(@NotNull List<ExtensionPointDescriptor> points, @NotNull PluginDescriptor pluginDescriptor) {
        Intrinsics.checkNotNullParameter(points, "points");
        Intrinsics.checkNotNullParameter(pluginDescriptor, "pluginDescriptor");
        HashMap map2 = new HashMap();
        ExtensionsAreaImplKt.createExtensionPoints(points, this.componentManager, map2, pluginDescriptor);
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.extensionPoints = UtilKt.withAll(this.extensionPoints, map2);
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public <T> ExtensionPointImpl<T> getExtensionPoint(@NotNull String extensionPointName) {
        Intrinsics.checkNotNullParameter(extensionPointName, "extensionPointName");
        ExtensionPoint extensionPoint = this.getExtensionPointIfRegistered(extensionPointName);
        if (extensionPoint == null) {
            throw new IllegalArgumentException("Missing extension point: " + extensionPointName + " in container " + this.componentManager);
        }
        return extensionPoint;
    }

    @Nullable
    public <T> ExtensionPointImpl<T> getExtensionPointIfRegistered(@NotNull String extensionPointName) {
        Intrinsics.checkNotNullParameter(extensionPointName, "extensionPointName");
        return this.extensionPoints.get(extensionPointName);
    }

    @Override
    @NotNull
    public <T> ExtensionPoint<T> getExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName) {
        Intrinsics.checkNotNullParameter(extensionPointName, "extensionPointName");
        return this.getExtensionPoint(extensionPointName.getName());
    }

    @Override
    public boolean hasExtensionPoint(@NotNull String extensionPointName) {
        Intrinsics.checkNotNullParameter(extensionPointName, "extensionPointName");
        return this.extensionPoints.containsKey(extensionPointName);
    }

    @Override
    public boolean hasExtensionPoint(@NotNull ExtensionPointName<?> extensionPointName) {
        Intrinsics.checkNotNullParameter(extensionPointName, "extensionPointName");
        return this.hasExtensionPoint(extensionPointName.getName());
    }

    @NotNull
    public String toString() {
        return this.componentManager.toString();
    }
}

