/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.projectRoots.JavaSdkVersion;
import org.jetbrains.kotlin.com.intellij.openapi.projectRoots.JavaVersionService;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiCall;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.ThreadLocalTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.DebugUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.JavaResolveCache;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTypesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class PsiMethodCallExpressionImpl
extends ExpressionPsiElement
implements PsiMethodCallExpression {
    private static final Logger LOG = Logger.getInstance(PsiMethodCallExpressionImpl.class);
    private static final TypeEvaluator ourTypeEvaluator = new TypeEvaluator();

    public PsiMethodCallExpressionImpl() {
        super(JavaElementType.METHOD_CALL_EXPRESSION);
    }

    @Override
    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, ourTypeEvaluator);
    }

    @Override
    public PsiMethod resolveMethod() {
        return (PsiMethod)this.getMethodExpression().resolve();
    }

    @Override
    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        JavaResolveResult javaResolveResult = this.getMethodExpression().advancedResolve(false);
        if (javaResolveResult == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(0);
        }
        return javaResolveResult;
    }

    @Override
    public void removeChild(@NotNull ASTNode child) {
        if (child == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(1);
        }
        if (child == this.getArgumentList()) {
            LOG.error("Cannot delete argument list since it will break contract on argument list notnullity");
        }
        super.removeChild(child);
    }

    @Override
    @NotNull
    public PsiReferenceParameterList getTypeArgumentList() {
        PsiReferenceExpression expression2 = this.getMethodExpression();
        PsiReferenceParameterList result2 = expression2.getParameterList();
        if (result2 != null) {
            PsiReferenceParameterList psiReferenceParameterList = result2;
            if (psiReferenceParameterList == null) {
                PsiMethodCallExpressionImpl.$$$reportNull$$$0(2);
            }
            return psiReferenceParameterList;
        }
        LOG.error("Invalid method call expression. Children:\n" + DebugUtil.psiTreeToString(expression2, true));
        PsiReferenceParameterList psiReferenceParameterList = result2;
        if (psiReferenceParameterList == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(3);
        }
        return psiReferenceParameterList;
    }

    @Override
    public PsiType @NotNull [] getTypeArguments() {
        PsiType[] psiTypeArray = this.getMethodExpression().getTypeParameters();
        if (psiTypeArray == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(4);
        }
        return psiTypeArray;
    }

    @Override
    @NotNull
    public PsiReferenceExpression getMethodExpression() {
        PsiReferenceExpression psiReferenceExpression = (PsiReferenceExpression)this.findChildByRoleAsPsiElement(91);
        if (psiReferenceExpression == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(5);
        }
        return psiReferenceExpression;
    }

    @Override
    @NotNull
    public PsiExpressionList getArgumentList() {
        PsiExpressionList list = (PsiExpressionList)this.findChildByRoleAsPsiElement(73);
        if (list == null) {
            LOG.error("Invalid PSI for'" + this.getText() + ". Parent:" + DebugUtil.psiToString(this.getParent(), true));
        }
        PsiExpressionList psiExpressionList = list;
        if (psiExpressionList == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(6);
        }
        return psiExpressionList;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 91: {
                return this.getFirstChildNode();
            }
            case 73: 
        }
        return this.findChildByType(JavaElementType.EXPRESSION_LIST);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == JavaElementType.EXPRESSION_LIST) {
            return 73;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 91;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(8);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitMethodCallExpression(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiMethodCallExpression:" + this.getText();
    }

    public static boolean doWePerformGenericMethodOverloadResolutionNow(PsiCall call2, LanguageLevel languageLevel) {
        PsiElement callParent = PsiUtil.skipParenthesizedExprUp(call2.getParent());
        PsiExpressionList parentArgList = languageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? (callParent instanceof PsiConditionalExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)callParent) ? null : PsiTreeUtil.getParentOfType((PsiElement)call2, PsiExpressionList.class, true, PsiReferenceExpression.class)) : null;
        return parentArgList != null && MethodCandidateInfo.isOverloadCheck(parentArgList) && !ContainerUtil.exists(parentArgList.getExpressions(), expression2 -> (expression2 = PsiUtil.skipParenthesizedExprDown(expression2)) != null && ThreadLocalTypes.hasBindingFor(expression2));
    }

    private static PsiType captureReturnType(PsiMethodCallExpression call2, PsiMethod method, PsiType ret, JavaResolveResult result2, LanguageLevel languageLevel, PsiFile file) {
        PsiType erased;
        PsiSubstitutor substitutor2 = result2.getSubstitutor();
        substitutor2.ensureValid();
        PsiType substitutedReturnType = substitutor2.substitute(ret);
        if (substitutedReturnType == null) {
            return TypeConversionUtil.erasure(ret);
        }
        if (result2 instanceof MethodCandidateInfo && ((MethodCandidateInfo)result2).isErased()) {
            return TypeConversionUtil.erasure(substitutedReturnType);
        }
        if (((!languageLevel.isAtLeast(LanguageLevel.JDK_1_8) || call2.getTypeArguments().length > 0) && method.hasTypeParameters() || !method.hasTypeParameters() && JavaVersionService.getInstance().isAtLeast(file, JavaSdkVersion.JDK_1_8)) && !substitutedReturnType.equals(erased = TypeConversionUtil.erasure(substitutedReturnType)) && result2 instanceof MethodCandidateInfo && ((MethodCandidateInfo)result2).isApplicable()) {
            PsiType[] args = call2.getArgumentList().getExpressionTypes();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            boolean varargs = ((MethodCandidateInfo)result2).getApplicabilityLevel() == 2;
            for (int i2 = 0; i2 < args.length; ++i2) {
                PsiType parameterType = substitutor2.substitute(PsiTypesUtil.getParameterType(parameters2, i2, varargs));
                PsiType expressionType = args[i2];
                if (expressionType == null || parameterType == null || !JavaGenericsUtil.isRawToGeneric(parameterType, expressionType)) continue;
                return erased;
            }
        }
        if (PsiUtil.isRawSubstitutor(method, substitutor2)) {
            PsiType returnTypeErasure = TypeConversionUtil.erasure(ret);
            if (Comparing.equal(TypeConversionUtil.erasure(substitutedReturnType), returnTypeErasure)) {
                return returnTypeErasure;
            }
        }
        return PsiUtil.captureToplevelWildcards(substitutedReturnType, call2);
    }

    @Override
    public void replaceChildInternal(@NotNull ASTNode child, @NotNull TreeElement newElement) {
        if (child == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(9);
        }
        if (newElement == null) {
            PsiMethodCallExpressionImpl.$$$reportNull$$$0(10);
        }
        if (this.getChildRole(child) == 91 && newElement.getElementType() != JavaElementType.REFERENCE_EXPRESSION) {
            throw new IncorrectOperationException("ReferenceExpression expected; got: " + newElement.getElementType());
        }
        super.replaceChildInternal(child, newElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl";
                break;
            }
            case 1: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMethodGenerics";
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentList";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentList";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeChild";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "replaceChildInternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TypeEvaluator
    implements Function<PsiMethodCallExpression, PsiType> {
        private TypeEvaluator() {
        }

        @Override
        @Nullable
        public PsiType fun(PsiMethodCallExpression call2) {
            PsiReferenceExpression methodExpression = call2.getMethodExpression();
            PsiFile file = call2.getContainingFile();
            JavaResolveResult[] results = PsiImplUtil.multiResolveImpl(methodExpression, file, false, PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE);
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel(file);
            boolean genericParentOverloadResolution = PsiMethodCallExpressionImpl.doWePerformGenericMethodOverloadResolutionNow(call2, languageLevel);
            PsiType theOnly = null;
            for (int i2 = 0; i2 < results.length; ++i2) {
                PsiType type2;
                JavaResolveResult candidateInfo = results[i2];
                PsiElement element = candidateInfo.getElement();
                if (genericParentOverloadResolution && element != null && PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)call2, (PsiMethod)element)) {
                    LOG.error("poly expression evaluation during overload resolution, processing " + results.length + " results");
                }
                if ((type2 = TypeEvaluator.getResultType(call2, methodExpression, candidateInfo, languageLevel, file)) == null) {
                    return null;
                }
                if (i2 == 0) {
                    theOnly = type2;
                    continue;
                }
                if (theOnly.equals(type2)) continue;
                return null;
            }
            return PsiClassImplUtil.correctType(theOnly, file.getResolveScope());
        }

        @Nullable
        private static PsiType getResultType(@NotNull PsiMethodCallExpression call2, @NotNull PsiReferenceExpression methodExpression, @NotNull JavaResolveResult result2, @NotNull LanguageLevel languageLevel, @NotNull PsiFile file) {
            PsiMethod method;
            if (call2 == null) {
                TypeEvaluator.$$$reportNull$$$0(0);
            }
            if (methodExpression == null) {
                TypeEvaluator.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                TypeEvaluator.$$$reportNull$$$0(2);
            }
            if (languageLevel == null) {
                TypeEvaluator.$$$reportNull$$$0(3);
            }
            if (file == null) {
                TypeEvaluator.$$$reportNull$$$0(4);
            }
            if ((method = (PsiMethod)result2.getElement()) == null) {
                return null;
            }
            PsiUtilCore.ensureValid(method);
            boolean is15OrHigher = languageLevel.compareTo(LanguageLevel.JDK_1_5) >= 0;
            PsiType getClassReturnType = PsiTypesUtil.patchMethodGetClassReturnType(call2, methodExpression, method, type2 -> type2 != JavaElementType.CLASS && type2 != JavaElementType.ANONYMOUS_CLASS, languageLevel);
            if (getClassReturnType != null) {
                return getClassReturnType;
            }
            PsiType ret = method.getReturnType();
            if (ret == null) {
                return null;
            }
            PsiUtil.ensureValidType(ret);
            if (ret instanceof PsiClassType) {
                ret = ((PsiClassType)ret).setLanguageLevel(languageLevel);
            }
            if (is15OrHigher) {
                return PsiMethodCallExpressionImpl.captureReturnType(call2, method, ret, result2, languageLevel, file);
            }
            return TypeConversionUtil.erasure(ret);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "call";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "methodExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "languageLevel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/PsiMethodCallExpressionImpl$TypeEvaluator";
            objectArray[2] = "getResultType";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

