/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.SystemInfoRt;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;

public final class EnvironmentUtil {
    private static final Logger LOG = Logger.getInstance(EnvironmentUtil.class);
    private static final AtomicReference<CompletableDeferred<Map<String, String>>> ourEnvGetter = new AtomicReference();
    private static final Pattern pattern = Pattern.compile("\\$(.*?)\\$");

    private EnvironmentUtil() {
    }

    @NotNull
    public static Map<String, String> getEnvironmentMap() {
        Map<String, String> map2;
        CompletableDeferred<Map<String, String>> getter2 = ourEnvGetter.get();
        if (getter2 == null && !ourEnvGetter.compareAndSet(null, getter2 = CompletableDeferredKt.CompletableDeferred(EnvironmentUtil.getSystemEnv()))) {
            getter2 = ourEnvGetter.get();
        }
        try {
            map2 = FutureKt.asCompletableFuture(getter2).join();
        }
        catch (Throwable t2) {
            throw new AssertionError((Object)t2);
        }
        if (map2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(0);
        }
        return map2;
    }

    @NotNull
    private static Map<String, String> getSystemEnv() {
        if (SystemInfoRt.isWindows) {
            Map<String, String> map2 = Collections.unmodifiableMap(CollectionFactory.createCaseInsensitiveStringMap(System.getenv()));
            if (map2 == null) {
                EnvironmentUtil.$$$reportNull$$$0(2);
            }
            return map2;
        }
        if (SystemInfoRt.isUnix && !SystemInfoRt.isMac) {
            Map<String, String> env = System.getenv();
            if (env.containsKey("DESKTOP_STARTUP_ID")) {
                env = new HashMap<String, String>(env);
                env.remove("DESKTOP_STARTUP_ID");
                env = Collections.unmodifiableMap(env);
            }
            Map<String, String> map3 = env;
            if (map3 == null) {
                EnvironmentUtil.$$$reportNull$$$0(3);
            }
            return map3;
        }
        Map<String, String> map4 = System.getenv();
        if (map4 == null) {
            EnvironmentUtil.$$$reportNull$$$0(4);
        }
        return map4;
    }

    @Nullable
    public static String getValue(@NotNull String name2) {
        if (name2 == null) {
            EnvironmentUtil.$$$reportNull$$$0(5);
        }
        return EnvironmentUtil.getEnvironmentMap().get(name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentJob";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shell";
                break;
            }
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEnv";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironmentMap";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/EnvironmentUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemEnv";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildShellProcessCommand";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseEnv";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setLocaleEnv";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildShellProcessCommand";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseEnv";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "waitAndTerminateAfter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "waitFor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setCharsetVar";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setLocaleEnv";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isCharsetVarDefined";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "inlineParentOccurrences";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "testParser";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

