/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.messages.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.EventDispatcher;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusImpl;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageBusImplKt;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageQueue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J2\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u000eH\u0086\u0002\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J3\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0010\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0005\u001a\u00020\u00068\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/MessagePublisher;", "L", "Ljava/lang/reflect/InvocationHandler;", "topic", "Lorg/jetbrains/kotlin/com/intellij/util/messages/Topic;", "bus", "Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/MessageBusImpl;", "(Lcom/intellij/util/messages/Topic;Lcom/intellij/util/messages/impl/MessageBusImpl;)V", "invoke", "", "proxy", "method", "Ljava/lang/reflect/Method;", "args", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "preload", "", "publish", "", "queue", "Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/MessageQueue;", "publish$intellij_platform_core", "(Ljava/lang/reflect/Method;[Ljava/lang/Object;Lcom/intellij/util/messages/impl/MessageQueue;)Z", "intellij.platform.core"})
@SourceDebugExtension(value={"SMAP\nMessageBusImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageBusImpl.kt\ncom/intellij/util/messages/impl/MessagePublisher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,719:1\n1#2:720\n*E\n"})
public class MessagePublisher<L>
implements InvocationHandler {
    @JvmField
    @NotNull
    protected final Topic<L> topic;
    @JvmField
    @NotNull
    protected final MessageBusImpl bus;

    public MessagePublisher(@NotNull Topic<L> topic, @NotNull MessageBusImpl bus) {
        Intrinsics.checkNotNullParameter(topic, "topic");
        Intrinsics.checkNotNullParameter(bus, "bus");
        this.topic = topic;
        this.bus = bus;
    }

    @Override
    @Nullable
    public final Object invoke(@NotNull Object proxy, @NotNull Method method, @Nullable Object[] args) {
        Intrinsics.checkNotNullParameter(proxy, "proxy");
        Intrinsics.checkNotNullParameter(method, "method");
        if (Intrinsics.areEqual(method.getDeclaringClass(), Object.class)) {
            return EventDispatcher.handleObjectMethod(proxy, args, method.getName());
        }
        if (this.topic.isImmediateDelivery()) {
            this.bus.checkNotDisposed$intellij_platform_core();
            this.publish$intellij_platform_core(method, args, null);
            return MessageBusImplKt.access$getNA$p();
        }
        MessageQueue queue = this.bus.rootBus.getQueue$intellij_platform_core();
        if (!queue.queue.isEmpty()) {
            MessageBusImplKt.access$pumpWaiting(queue);
        }
        if (this.publish$intellij_platform_core(method, args, queue)) {
            MessageBusImplKt.access$pumpWaiting(queue);
        }
        return MessageBusImplKt.access$getNA$p();
    }

    public boolean publish$intellij_platform_core(@NotNull Method method, @Nullable Object[] args, @Nullable MessageQueue queue) {
        block1: {
            Intrinsics.checkNotNullParameter(method, "method");
            Object[] handlers2 = this.bus.subscriberCache.computeIfAbsent(this.topic, arg_0 -> MessagePublisher.publish$lambda$0(new Function1<Topic<?>, Object[]>(this.bus){

                @NotNull
                public final Object[] invoke(@NotNull Topic<?> p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return ((MessageBusImpl)this.receiver).computeSubscribers$intellij_platform_core(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNull(handlers2);
            if (handlers2.length == 0) {
                return false;
            }
            Throwable throwable = MessageBusImplKt.executeOrAddToQueue(this.topic, method, args, handlers2, queue, null, this.bus);
            if (throwable == null) break block1;
            Throwable p0 = throwable;
            boolean bl = false;
            MessageBusImplKt.throwError(p0);
        }
        return true;
    }

    private static final Object[] publish$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Object[])$tmp0.invoke(p0);
    }
}

