/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.pipeline;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.collectors.CliDiagnosticsCollector;
import org.jetbrains.kotlin.fir.analysis.collectors.DiagnosticCollectorComponents;
import org.jetbrains.kotlin.fir.analysis.collectors.components.AbstractDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.collectors.components.DiagnosticComponentsFactory;
import org.jetbrains.kotlin.fir.analysis.collectors.components.LossDiagnosticCollectorComponent;
import org.jetbrains.kotlin.fir.analysis.collectors.components.ReportCommitterDiagnosticComponent;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTotalResolveProcessor;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a*\u0010\u0000\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001aB\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00030\b*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0003*\u00020\u00052\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0012"}, d2={"runResolution", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/FirSession;", "firFiles", "runCheckers", "", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnostic;", "scopeSession", "", "reporter", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "mppCheckerKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "collectLostDiagnosticsOnFile", "file", "entrypoint"})
@SourceDebugExtension(value={"SMAP\nanalyse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 analyse.kt\norg/jetbrains/kotlin/fir/pipeline/AnalyseKt\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n247#2,4:65\n247#2,4:75\n1285#3,2:69\n1299#3,4:71\n*S KotlinDebug\n*F\n+ 1 analyse.kt\norg/jetbrains/kotlin/fir/pipeline/AnalyseKt\n*L\n36#1:65,4\n58#1:75,4\n41#1:69,2\n41#1:71,4\n*E\n"})
public final class AnalyseKt {
    @NotNull
    public static final Pair<ScopeSession, List<FirFile>> runResolution(@NotNull FirSession $this$runResolution, @NotNull List<? extends FirFile> firFiles) {
        Intrinsics.checkNotNullParameter($this$runResolution, "<this>");
        Intrinsics.checkNotNullParameter(firFiles, "firFiles");
        FirTotalResolveProcessor resolveProcessor = new FirTotalResolveProcessor($this$runResolution);
        resolveProcessor.process(firFiles);
        return TuplesKt.to(resolveProcessor.getScopeSession(), firFiles);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<FirFile, List<KtDiagnostic>> runCheckers(@NotNull FirSession $this$runCheckers, @NotNull ScopeSession scopeSession, @NotNull Collection<? extends FirFile> firFiles, @NotNull BaseDiagnosticsCollector reporter, @NotNull MppCheckerKind mppCheckerKind) {
        void $this$associateWithTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$runCheckers, "<this>");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(firFiles, "firFiles");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter((Object)mppCheckerKind, "mppCheckerKind");
        CliDiagnosticsCollector collector2 = DiagnosticComponentsFactory.INSTANCE.create($this$runCheckers, scopeSession, mppCheckerKind);
        Iterator<? extends FirFile> iterator2 = firFiles.iterator();
        while (iterator2.hasNext()) {
            FirFile file;
            FirFile file$iv = file = iterator2.next();
            boolean $i$f$withFileAnalysisExceptionWrapping = false;
            try {
                boolean bl = false;
                collector2.collectDiagnostics(file, reporter);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable$iv) {
                UtilsKt.getExceptionHandler(file$iv.getModuleData().getSession()).handleExceptionOnFileAnalysis(file$iv, throwable$iv);
                throw new KotlinNothingValueException();
            }
        }
        collector2.collectDiagnosticsInSettings(reporter);
        Iterable $this$associateWith$iv = firFiles;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $i$f$withFileAnalysisExceptionWrapping = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            List<Object> list;
            void it;
            FirFile firFile = (FirFile)element$iv$iv;
            Object t2 = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object object = it.getSourceFile();
            if (object == null || (object = object.getPath()) == null) {
                list = CollectionsKt.emptyList();
            } else {
                Object path = object;
                list = reporter.getDiagnosticsByFilePath().get(path);
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
            }
            List list2 = list;
            map2.put(t2, list2);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final List<KtDiagnostic> collectLostDiagnosticsOnFile(@NotNull FirSession $this$collectLostDiagnosticsOnFile, @NotNull ScopeSession scopeSession, @NotNull FirFile file, @NotNull BaseDiagnosticsCollector reporter) {
        Intrinsics.checkNotNullParameter($this$collectLostDiagnosticsOnFile, "<this>");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        CliDiagnosticsCollector collector2 = new CliDiagnosticsCollector($this$collectLostDiagnosticsOnFile, scopeSession, arg_0 -> AnalyseKt.collectLostDiagnosticsOnFile$lambda$0($this$collectLostDiagnosticsOnFile, arg_0));
        FirFile file$iv = file;
        boolean $i$f$withFileAnalysisExceptionWrapping = false;
        try {
            boolean bl = false;
            collector2.collectDiagnostics(file, reporter);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(file$iv.getModuleData().getSession()).handleExceptionOnFileAnalysis(file$iv, throwable$iv);
            throw new KotlinNothingValueException();
        }
        Object object = file.getSourceFile();
        if (object == null || (object = object.getPath()) == null) {
            return CollectionsKt.emptyList();
        }
        Object path = object;
        List<KtDiagnostic> list = reporter.getDiagnosticsByFilePath().get(path);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final DiagnosticCollectorComponents collectLostDiagnosticsOnFile$lambda$0(FirSession $this_collectLostDiagnosticsOnFile, DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        AbstractDiagnosticCollectorComponent[] abstractDiagnosticCollectorComponentArray = new AbstractDiagnosticCollectorComponent[]{new LossDiagnosticCollectorComponent($this_collectLostDiagnosticsOnFile, reporter)};
        return new DiagnosticCollectorComponents(abstractDiagnosticCollectorComponentArray, new ReportCommitterDiagnosticComponent($this_collectLostDiagnosticsOnFile, reporter));
    }
}

