/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.preprocessor;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.preprocessor.IrInterpreterPreprocessor;
import org.jetbrains.kotlin.ir.interpreter.preprocessor.IrInterpreterPreprocessorData;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u000f*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u000fH\u0002J\n\u0010\u0016\u001a\u00020\u0015*\u00020\u0013\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterConstGetterPreprocessor;", "Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterPreprocessor;", "<init>", "()V", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "data", "Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterPreprocessorData;", "visitCall", "Lorg/jetbrains/kotlin/ir/IrElement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "lowerConstRead", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "shouldDropConstReceiver", "", "hasConstantValue", "ir.interpreter"})
public final class IrInterpreterConstGetterPreprocessor
extends IrInterpreterPreprocessor {
    @Override
    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull IrInterpreterPreprocessorData data2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(data2, "data");
        if (Intrinsics.areEqual(declaration.getOrigin(), IrDeclarationOrigin.Companion.getDEFAULT_PROPERTY_ACCESSOR())) {
            return declaration;
        }
        return super.visitFunction(declaration, data2);
    }

    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrInterpreterPreprocessorData data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        IrDeclarationBase irDeclarationBase = UtilsKt.getCorrespondingProperty(expression2);
        if (irDeclarationBase == null || (irDeclarationBase = irDeclarationBase.getBackingField()) == null) {
            return super.visitCall(expression2, data2);
        }
        IrDeclarationBase field = irDeclarationBase;
        IrExpression irExpression = this.lowerConstRead(expression2, (IrField)field, data2);
        return irExpression != null ? (IrElement)irExpression : super.visitCall(expression2, data2);
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull IrInterpreterPreprocessorData data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        Object object = this.lowerConstRead(expression2, (IrField)expression2.getSymbol().getOwner(), data2);
        if (object == null) {
            object = super.visitGetField(expression2, data2);
        }
        return object;
    }

    private final IrExpression lowerConstRead(IrExpression $this$lowerConstRead, IrField field, IrInterpreterPreprocessorData data2) {
        IrExpression irExpression;
        IrExpression irExpression2;
        IrExpression irExpression3 = $this$lowerConstRead;
        if (irExpression3 instanceof IrCall) {
            irExpression2 = ((IrCall)$this$lowerConstRead).getDispatchReceiver();
        } else if (irExpression3 instanceof IrGetField) {
            irExpression2 = ((IrGetField)$this$lowerConstRead).getReceiver();
        } else {
            return null;
        }
        IrExpression receiver = irExpression2;
        if (receiver == null || !this.hasConstantValue(field)) {
            return null;
        }
        $this$lowerConstRead.transformChildren(this, data2);
        IrClass fieldParent = IrUtilsKt.getParentAsClass(field);
        IrGetObjectValueImpl getObject = BuildersKt.IrGetObjectValueImpl(-1, -1, IrUtilsKt.getDefaultType(fieldParent), fieldParent.getSymbol());
        IrExpression[] irExpressionArray = (IrExpression[])$this$lowerConstRead;
        if (irExpressionArray instanceof IrCall) {
            ((IrCall)$this$lowerConstRead).setDispatchReceiver(getObject);
        } else if (irExpressionArray instanceof IrGetField) {
            ((IrGetField)$this$lowerConstRead).setReceiver(getObject);
        }
        if (this.shouldDropConstReceiver(receiver)) {
            irExpression = $this$lowerConstRead;
        } else {
            irExpressionArray = new IrExpression[]{receiver, $this$lowerConstRead};
            irExpression = new IrCompositeImpl($this$lowerConstRead.getStartOffset(), $this$lowerConstRead.getEndOffset(), $this$lowerConstRead.getType(), null, CollectionsKt.listOf(irExpressionArray));
        }
        return irExpression;
    }

    private final boolean shouldDropConstReceiver(IrExpression $this$shouldDropConstReceiver) {
        return $this$shouldDropConstReceiver instanceof IrGetValue || $this$shouldDropConstReceiver instanceof IrGetObjectValue;
    }

    public final boolean hasConstantValue(@NotNull IrField $this$hasConstantValue) {
        Intrinsics.checkNotNullParameter($this$hasConstantValue, "<this>");
        boolean implicitConst = $this$hasConstantValue.isFinal() && $this$hasConstantValue.isStatic() && Intrinsics.areEqual($this$hasConstantValue.getOrigin(), IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB()) && $this$hasConstantValue.getInitializer() != null;
        return implicitConst || UtilsKt.isConst(UtilsKt.getProperty($this$hasConstantValue));
    }
}

