/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.preprocessor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.linkage.partial.PartialLinkageSupportForLoweringsKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrRichCallableReference;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.preprocessor.IrInterpreterPreprocessor;
import org.jetbrains.kotlin.ir.interpreter.preprocessor.IrInterpreterPreprocessorData;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterKCallableNamePreprocessor;", "Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterPreprocessor;", "<init>", "()V", "visitCall", "Lorg/jetbrains/kotlin/ir/IrElement;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "data", "Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterPreprocessorData;", "handleCallableReference", "Companion", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIrInterpreterKCallableNamePreprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInterpreterKCallableNamePreprocessor.kt\norg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterKCallableNamePreprocessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,105:1\n1563#2:106\n1634#2,3:107\n1634#2,3:110\n1563#2:114\n1634#2,3:115\n827#2:132\n855#2,2:133\n1#3:113\n37#4,2:118\n350#5,12:120\n*S KotlinDebug\n*F\n+ 1 IrInterpreterKCallableNamePreprocessor.kt\norg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterKCallableNamePreprocessor\n*L\n39#1:106\n39#1:107,3\n45#1:110,3\n48#1:114\n48#1:115,3\n65#1:132\n65#1:133,2\n52#1:118,2\n56#1:120,12\n*E\n"})
public final class IrInterpreterKCallableNamePreprocessor
extends IrInterpreterPreprocessor {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public IrElement visitCall(@NotNull IrCall expression2, @NotNull IrInterpreterPreprocessorData data2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(data2, "data");
        if (!Companion.isInterpretableKCallableNameCall(expression2, data2.getIrBuiltIns())) {
            return super.visitCall(expression2, data2);
        }
        return this.handleCallableReference(expression2, data2);
    }

    /*
     * WARNING - void declaration
     */
    private final IrElement handleCallableReference(IrCall expression2, IrInterpreterPreprocessorData data2) {
        void $this$filterNotTo$iv$iv;
        IrExpression $this$single$iv;
        Object newTypeArgs;
        Object object;
        void $this$mapTo$iv$iv;
        List list;
        IrExpression callableReference = expression2.getDispatchReceiver();
        IrExpression irExpression = callableReference;
        if (irExpression instanceof IrCallableReference) {
            list = CollectionsKt.filterNotNull(((IrCallableReference)callableReference).getArguments());
        } else if (irExpression instanceof IrRichCallableReference) {
            list = CollectionsKt.toList((Iterable)((IrRichCallableReference)callableReference).getBoundValues());
        } else {
            return super.visitCall(expression2, data2);
        }
        List boundArgs = list;
        IrType irType = callableReference.getType();
        Intrinsics.checkNotNull(irType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        Iterable $this$map$iv = ((IrSimpleType)irType).getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            IrType irType2 = IrTypesKt.getTypeOrNull((IrTypeArgument)it);
            Intrinsics.checkNotNull(irType2);
            object.add(irType2);
        }
        List typeArguments = (List)destination$iv$iv;
        if (!((Collection)boundArgs).isEmpty() && IrTypeUtilsKt.isKFunction(callableReference.getType())) {
            IrType[] $this$map$iv2;
            List list2;
            IrType[] it;
            if (callableReference instanceof IrCallableReference) {
                void destination$iv;
                void $this$mapTo$iv;
                Iterator typeArgIterator = typeArguments.iterator();
                destination$iv$iv = ((IrCallableReference)callableReference).getArguments();
                Collection $i$f$mapTo2 = new ArrayList();
                boolean $i$f$mapTo3 = false;
                for (Iterator<Object> item$iv : $this$mapTo$iv) {
                    void it2;
                    IrExpression bl = (IrExpression)((Object)item$iv);
                    object = destination$iv;
                    boolean bl2 = false;
                    IrType irType3 = it2;
                    if (irType3 == null || (irType3 = ((IrExpression)((Object)irType3)).getType()) == null) {
                        irType3 = (IrType)typeArgIterator.next();
                    }
                    object.add(irType3);
                }
                $this$mapTo$iv = destination$iv;
                it = (List)$this$mapTo$iv;
                boolean bl = false;
                it.add(typeArgIterator.next());
                list2 = (List)$this$mapTo$iv;
            } else {
                void $this$mapTo$iv$iv2;
                $this$map$iv2 = (IrType[])boundArgs;
                boolean $i$f$map2 = false;
                it = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
                boolean $i$f$mapTo4 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it3;
                    IrExpression bl2 = (IrExpression)item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl = false;
                    object.add(it3.getType());
                }
                list2 = CollectionsKt.plus((Collection)((List)destination$iv$iv2), (Iterable)typeArguments);
            }
            newTypeArgs = list2;
            IrClass kFunction = data2.getIrBuiltIns().kFunctionN(typeArguments.size());
            Collection $this$toTypedArray$iv = (Collection)newTypeArgs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            $this$map$iv2 = thisCollection$iv.toArray(new IrType[0]);
            callableReference.setType(IrTypesKt.typeWith(kFunction, Arrays.copyOf($this$map$iv2, $this$map$iv2.length)));
        }
        newTypeArgs = IrUtilsKt.getProperties((IrDeclarationContainer)data2.getIrBuiltIns().getKCallableClass().getOwner());
        object = expression2;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv22 = false;
        Iterator $i$f$toTypedArray = $this$single$iv.iterator();
        while ($i$f$toTypedArray.hasNext()) {
            Object element$iv = $i$f$toTypedArray.next();
            IrProperty it = (IrProperty)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getName().asString(), "name")) continue;
            if (found$iv22) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv22 = true;
        }
        if (!found$iv22) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction irSimpleFunction = ((IrProperty)single$iv).getGetter();
        Intrinsics.checkNotNull(irSimpleFunction);
        ((IrCall)object).setSymbol(irSimpleFunction.getSymbol());
        $this$single$iv = callableReference;
        if ($this$single$iv instanceof IrCallableReference) {
            Collections.fill(((IrCallableReference)callableReference).getArguments(), null);
        } else if ($this$single$iv instanceof IrRichCallableReference) {
            ((IrRichCallableReference)callableReference).getBoundValues().clear();
        } else {
            return super.visitCall(expression2, data2);
        }
        Iterable $this$filterNot$iv = boundArgs;
        boolean $i$f$filterNot = false;
        Iterable found$iv22 = $this$filterNot$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            IrExpression it = (IrExpression)element$iv$iv;
            boolean bl = false;
            if (it instanceof IrGetValue && Intrinsics.areEqual(((IrGetValue)it).getSymbol().getOwner().getName(), SpecialNames.THIS)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List boundArgsWithoutThis = (List)destination$iv$iv3;
        if (boundArgsWithoutThis.isEmpty()) {
            return expression2;
        }
        return new IrCompositeImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), null, CollectionsKt.plus((Collection)boundArgsWithoutThis, (Iterable)CollectionsKt.listOf(expression2)));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\n\u0010\t\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterKCallableNamePreprocessor$Companion;", "", "<init>", "()V", "isInterpretableKCallableNameCall", "", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "isEnumName", "ir.interpreter"})
    @SourceDebugExtension(value={"SMAP\nIrInterpreterKCallableNamePreprocessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInterpreterKCallableNamePreprocessor.kt\norg/jetbrains/kotlin/ir/interpreter/preprocessor/IrInterpreterKCallableNamePreprocessor$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isInterpretableKCallableNameCall(@NotNull IrCall $this$isInterpretableKCallableNameCall, @NotNull IrBuiltIns irBuiltIns) {
            Name name2;
            Intrinsics.checkNotNullParameter($this$isInterpretableKCallableNameCall, "<this>");
            Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
            IrExpression receiver = $this$isInterpretableKCallableNameCall.getDispatchReceiver();
            if (!(receiver instanceof IrCallableReference) && !(receiver instanceof IrRichCallableReference)) {
                return false;
            }
            if (receiver instanceof IrRichCallableReference && PartialLinkageSupportForLoweringsKt.getReflectionTargetLinkageError((IrRichCallableReference)receiver) != null) {
                return false;
            }
            IrSimpleFunction it = (IrSimpleFunction)$this$isInterpretableKCallableNameCall.getSymbol().getOwner();
            boolean bl = false;
            IrProperty irProperty = UtilsKt.getProperty(it);
            IrOverridableMember directMember = (IrOverridableMember)(irProperty != null ? (IrElement)irProperty : (IrElement)it);
            IrElement irElement = directMember.getParent();
            IrClass irClass = irElement instanceof IrClass ? (IrClass)irElement : null;
            if (irClass == null) {
                return false;
            }
            IrClass irClass2 = irClass;
            if (!IrUtilsKt.isSubclassOf(irClass2, (IrClass)irBuiltIns.getKCallableClass().getOwner())) {
                return false;
            }
            irElement = directMember;
            if (irElement instanceof IrSimpleFunction) {
                name2 = directMember.getName();
            } else if (irElement instanceof IrProperty) {
                name2 = directMember.getName();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Name name3 = name2;
            return Intrinsics.areEqual(name3.asString(), "name");
        }

        public final boolean isEnumName(@NotNull IrCall $this$isEnumName) {
            Intrinsics.checkNotNullParameter($this$isEnumName, "<this>");
            IrSimpleFunction owner = (IrSimpleFunction)$this$isEnumName.getSymbol().getOwner();
            if (!IrUtilsKt.hasShape$default(owner, true, false, 0, 0, null, 22, null)) {
                return false;
            }
            IrProperty irProperty = UtilsKt.getProperty(owner);
            if (irProperty == null) {
                return false;
            }
            IrProperty property2 = irProperty;
            return $this$isEnumName.getDispatchReceiver() instanceof IrGetEnumValue && Intrinsics.areEqual(property2.getName().asString(), "name");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

