/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.types;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IdSignatureValues;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.SimpleTypeNullability;
import org.jetbrains.kotlin.ir.types.impl.IrCapturedType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u0010\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b \u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a%\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\r\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0010\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\b\u001a\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u001a\n\u0010%\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010&\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010'\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010(\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010)\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010*\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010+\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010,\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010-\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010.\u001a\u00020\u0001*\u00020\u0002\u001a\u0014\u0010/\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u0001\u001a\n\u00100\u001a\u00020\u0001*\u00020\u0002\u001a\f\u00101\u001a\u0004\u0018\u00010\u0019*\u00020\u0002\u001a\u0014\u00102\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u0001\u001a\f\u00103\u001a\u0004\u0018\u00010\u001d*\u00020\u0002\u001aI\u00104\u001a\u0004\u0018\u0001H5\"\u000e\b\u0000\u00105*\b\u0012\u0004\u0012\u0002H506*\u00020\u00022\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H50\u00182\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u0002H50\u0018\u00a2\u0006\u0002\u00109\u001a\n\u0010:\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010:\u001a\u00020\u0001*\u00020;\u001a\n\u0010<\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010=\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010>\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010?\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010@\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010A\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010B\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010C\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010D\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010E\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010F\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010G\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010H\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010I\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010J\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010K\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010L\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010M\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010N\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010O\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010P\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010Q\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010R\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010S\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010T\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010U\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010V\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010W\u001a\u00020\u0001*\u00020\u0002\u001a\u001a\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0001\u001a\n\u0010X\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010Y\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010Z\u001a\u00020\u0001*\u00020\u0002\"\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001d0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001d0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001d\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00040\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\"\u001d\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00040\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!\u00a8\u0006["}, d2={"isNotNullClassType", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "signature", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;", "isNullableClassType", "getPublicSignature", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "name", "", "isClassType", "nullable", "(Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;Ljava/lang/Boolean;)Z", "hasFqNameEqualToSignature", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "isClassWithFqName", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "fqName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "classFqNameEquals", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "idSignatureToPrimitiveType", "", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "shortNameToPrimitiveType", "Lorg/jetbrains/kotlin/name/Name;", "idSignatureToUnsignedType", "Lorg/jetbrains/kotlin/builtins/UnsignedType;", "shortNameToUnsignedType", "primitiveArrayTypesSignatures", "getPrimitiveArrayTypesSignatures", "()Ljava/util/Map;", "unsignedArrayTypesSignatures", "getUnsignedArrayTypesSignatures", "declaration", "isAny", "isNullableAny", "isString", "isNullableString", "isStringClassType", "isArray", "isNullableArray", "isCollection", "isNothing", "isNullableNothing", "isPrimitiveType", "isNullablePrimitiveType", "getPrimitiveType", "isUnsignedType", "getUnsignedType", "getPrimitiveOrUnsignedType", "T", "", "byIdSignature", "byShortName", "(Lorg/jetbrains/kotlin/ir/types/IrType;Ljava/util/Map;Ljava/util/Map;)Ljava/lang/Enum;", "isMarkedNullable", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "canBeNull", "isUnit", "isBoolean", "isChar", "isByte", "isShort", "isInt", "isLong", "isUByte", "isUShort", "isUInt", "isULong", "isFloat", "isDouble", "isNumber", "isDoubleOrFloatWithoutNullability", "isComparable", "isCharSequence", "isIterable", "isSequence", "isBooleanArray", "isCharArray", "isByteArray", "isShortArray", "isIntArray", "isLongArray", "isFloatArray", "isDoubleArray", "isKotlinResult", "isNullableContinuation", "isKClass", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nirTypePredicates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 irTypePredicates.kt\norg/jetbrains/kotlin/ir/types/IrTypePredicatesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n1#2:221\n1761#3,3:222\n1740#3,3:225\n1208#3,2:228\n1236#3,4:230\n1208#3,2:234\n1236#3,4:236\n1208#3,2:240\n1236#3,4:242\n1208#3,2:246\n1236#3,4:248\n1285#3,2:252\n1299#3,4:254\n1285#3,2:258\n1299#3,4:260\n*S KotlinDebug\n*F\n+ 1 irTypePredicates.kt\norg/jetbrains/kotlin/ir/types/IrTypePredicatesKt\n*L\n167#1:222,3\n168#1:225,3\n94#1:228,2\n94#1:230,4\n99#1:234,2\n99#1:236,4\n102#1:240,2\n102#1:242,4\n107#1:246,2\n107#1:248,4\n110#1:252,2\n110#1:254,4\n115#1:258,2\n115#1:260,4\n*E\n"})
public final class IrTypePredicatesKt {
    @NotNull
    private static final Map<IdSignature.CommonSignature, PrimitiveType> idSignatureToPrimitiveType;
    @NotNull
    private static final Map<Name, PrimitiveType> shortNameToPrimitiveType;
    @NotNull
    private static final Map<IdSignature.CommonSignature, UnsignedType> idSignatureToUnsignedType;
    @NotNull
    private static final Map<Name, UnsignedType> shortNameToUnsignedType;
    @NotNull
    private static final Map<PrimitiveType, IdSignature.CommonSignature> primitiveArrayTypesSignatures;
    @NotNull
    private static final Map<UnsignedType, IdSignature.CommonSignature> unsignedArrayTypesSignatures;

    private static final boolean isNotNullClassType(IrType $this$isNotNullClassType, IdSignature.CommonSignature signature2) {
        return IrTypePredicatesKt.isClassType($this$isNotNullClassType, signature2, (Boolean)false);
    }

    private static final boolean isNullableClassType(IrType $this$isNullableClassType, IdSignature.CommonSignature signature2) {
        return IrTypePredicatesKt.isClassType($this$isNullableClassType, signature2, (Boolean)true);
    }

    @NotNull
    public static final IdSignature.CommonSignature getPublicSignature(@NotNull FqName packageFqName, @NotNull String name2) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name2, "name");
        String string = packageFqName.asString();
        Name name3 = Name.identifier(name2);
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        return new IdSignature.CommonSignature(string, name2, null, 0L, packageFqName.child(name3).asString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isClassType(IrType $this$isClassType, IdSignature.CommonSignature signature2, Boolean nullable) {
        if (!($this$isClassType instanceof IrSimpleType)) return false;
        if ($this$isClassType instanceof IrCapturedType) {
            return false;
        }
        if (nullable != null && !Intrinsics.areEqual(IrTypePredicatesKt.isMarkedNullable((IrSimpleType)$this$isClassType), nullable)) {
            return false;
        }
        if (Intrinsics.areEqual(signature2, ((IrSimpleType)$this$isClassType).getClassifier().getSignature())) return true;
        if (!((IrSimpleType)$this$isClassType).getClassifier().isBound()) return false;
        IrSymbolOwner it = ((IrSimpleType)$this$isClassType).getClassifier().getOwner();
        boolean bl = false;
        if (!(it instanceof IrClass)) return false;
        if (!IrTypePredicatesKt.hasFqNameEqualToSignature((IrClass)it, signature2)) return false;
        return true;
    }

    static /* synthetic */ boolean isClassType$default(IrType irType, IdSignature.CommonSignature commonSignature, Boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = null;
        }
        return IrTypePredicatesKt.isClassType(irType, commonSignature, bl);
    }

    private static final boolean hasFqNameEqualToSignature(IrClass $this$hasFqNameEqualToSignature, IdSignature.CommonSignature signature2) {
        return Intrinsics.areEqual($this$hasFqNameEqualToSignature.getName().asString(), signature2.getShortName()) && AdditionalIrUtilsKt.hasTopLevelEqualFqName($this$hasFqNameEqualToSignature, signature2.getPackageFqName(), signature2.getDeclarationFqName());
    }

    public static final boolean isClassWithFqName(@NotNull IrClassifierSymbol $this$isClassWithFqName, @NotNull FqNameUnsafe fqName2) {
        Intrinsics.checkNotNullParameter($this$isClassWithFqName, "<this>");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return $this$isClassWithFqName instanceof IrClassSymbol && IrTypePredicatesKt.classFqNameEquals((IrClassSymbol)$this$isClassWithFqName, fqName2);
    }

    public static final boolean isClassWithFqName(@NotNull IrClass $this$isClassWithFqName, @NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter($this$isClassWithFqName, "<this>");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        return IrTypePredicatesKt.classFqNameEquals($this$isClassWithFqName, fqName2);
    }

    private static final boolean classFqNameEquals(IrClassSymbol symbol, FqNameUnsafe fqName2) {
        boolean bl = symbol.isBound();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return IrTypePredicatesKt.classFqNameEquals((IrClass)symbol.getOwner(), fqName2);
    }

    @NotNull
    public static final Map<PrimitiveType, IdSignature.CommonSignature> getPrimitiveArrayTypesSignatures() {
        return primitiveArrayTypesSignatures;
    }

    @NotNull
    public static final Map<UnsignedType, IdSignature.CommonSignature> getUnsignedArrayTypesSignatures() {
        return unsignedArrayTypesSignatures;
    }

    private static final boolean classFqNameEquals(IrClass declaration, FqNameUnsafe fqName2) {
        return IrTypePredicatesKt.classFqNameEquals(declaration, fqName2.toSafe());
    }

    private static final boolean classFqNameEquals(IrClass declaration, FqName fqName2) {
        return AdditionalIrUtilsKt.hasEqualFqName(declaration, fqName2);
    }

    public static final boolean isAny(@NotNull IrType $this$isAny) {
        Intrinsics.checkNotNullParameter($this$isAny, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isAny, IdSignatureValues.any);
    }

    public static final boolean isNullableAny(@NotNull IrType $this$isNullableAny) {
        Intrinsics.checkNotNullParameter($this$isNullableAny, "<this>");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableAny, IdSignatureValues.any);
    }

    public static final boolean isString(@NotNull IrType $this$isString) {
        Intrinsics.checkNotNullParameter($this$isString, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isString, IdSignatureValues.string);
    }

    public static final boolean isNullableString(@NotNull IrType $this$isNullableString) {
        Intrinsics.checkNotNullParameter($this$isNullableString, "<this>");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableString, IdSignatureValues.string);
    }

    public static final boolean isStringClassType(@NotNull IrType $this$isStringClassType) {
        Intrinsics.checkNotNullParameter($this$isStringClassType, "<this>");
        return IrTypePredicatesKt.isClassType$default($this$isStringClassType, IdSignatureValues.string, null, 2, null);
    }

    public static final boolean isArray(@NotNull IrType $this$isArray) {
        Intrinsics.checkNotNullParameter($this$isArray, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isArray, IdSignatureValues.array);
    }

    public static final boolean isNullableArray(@NotNull IrType $this$isNullableArray) {
        Intrinsics.checkNotNullParameter($this$isNullableArray, "<this>");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableArray, IdSignatureValues.array);
    }

    public static final boolean isCollection(@NotNull IrType $this$isCollection) {
        Intrinsics.checkNotNullParameter($this$isCollection, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isCollection, IdSignatureValues.collection);
    }

    public static final boolean isNothing(@NotNull IrType $this$isNothing) {
        Intrinsics.checkNotNullParameter($this$isNothing, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isNothing, IdSignatureValues.nothing);
    }

    public static final boolean isNullableNothing(@NotNull IrType $this$isNullableNothing) {
        Intrinsics.checkNotNullParameter($this$isNullableNothing, "<this>");
        return IrTypePredicatesKt.isNullableClassType($this$isNullableNothing, IdSignatureValues.nothing);
    }

    public static final boolean isPrimitiveType(@NotNull IrType $this$isPrimitiveType, boolean nullable) {
        Intrinsics.checkNotNullParameter($this$isPrimitiveType, "<this>");
        return nullable == IrTypePredicatesKt.isMarkedNullable($this$isPrimitiveType) && IrTypePredicatesKt.getPrimitiveType($this$isPrimitiveType) != null;
    }

    public static /* synthetic */ boolean isPrimitiveType$default(IrType irType, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        return IrTypePredicatesKt.isPrimitiveType(irType, bl);
    }

    public static final boolean isNullablePrimitiveType(@NotNull IrType $this$isNullablePrimitiveType) {
        Intrinsics.checkNotNullParameter($this$isNullablePrimitiveType, "<this>");
        return IrTypePredicatesKt.isPrimitiveType($this$isNullablePrimitiveType, true);
    }

    @Nullable
    public static final PrimitiveType getPrimitiveType(@NotNull IrType $this$getPrimitiveType) {
        Intrinsics.checkNotNullParameter($this$getPrimitiveType, "<this>");
        return IrTypePredicatesKt.getPrimitiveOrUnsignedType($this$getPrimitiveType, idSignatureToPrimitiveType, shortNameToPrimitiveType);
    }

    public static final boolean isUnsignedType(@NotNull IrType $this$isUnsignedType, boolean nullable) {
        Intrinsics.checkNotNullParameter($this$isUnsignedType, "<this>");
        return nullable == IrTypePredicatesKt.isMarkedNullable($this$isUnsignedType) && IrTypePredicatesKt.getUnsignedType($this$isUnsignedType) != null;
    }

    public static /* synthetic */ boolean isUnsignedType$default(IrType irType, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        return IrTypePredicatesKt.isUnsignedType(irType, bl);
    }

    @Nullable
    public static final UnsignedType getUnsignedType(@NotNull IrType $this$getUnsignedType) {
        Intrinsics.checkNotNullParameter($this$getUnsignedType, "<this>");
        return IrTypePredicatesKt.getPrimitiveOrUnsignedType($this$getUnsignedType, idSignatureToUnsignedType, shortNameToUnsignedType);
    }

    @Nullable
    public static final <T extends Enum<T>> T getPrimitiveOrUnsignedType(@NotNull IrType $this$getPrimitiveOrUnsignedType, @NotNull Map<IdSignature.CommonSignature, ? extends T> byIdSignature, @NotNull Map<Name, ? extends T> byShortName) {
        Intrinsics.checkNotNullParameter($this$getPrimitiveOrUnsignedType, "<this>");
        Intrinsics.checkNotNullParameter(byIdSignature, "byIdSignature");
        Intrinsics.checkNotNullParameter(byShortName, "byShortName");
        if (!($this$getPrimitiveOrUnsignedType instanceof IrSimpleType)) {
            return null;
        }
        IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$getPrimitiveOrUnsignedType).getClassifier();
        IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
        if (irClassSymbol == null) {
            return null;
        }
        IrClassSymbol symbol = irClassSymbol;
        if (symbol.getSignature() != null) {
            return (T)((Enum)byIdSignature.get(symbol.getSignature()));
        }
        IrClass klass = (IrClass)symbol.getOwner();
        IrDeclarationParent parent2 = klass.getParent();
        if (!(parent2 instanceof IrPackageFragment) || !Intrinsics.areEqual(((IrPackageFragment)parent2).getPackageFqName(), StandardNames.BUILT_INS_PACKAGE_FQ_NAME)) {
            return null;
        }
        return (T)((Enum)byShortName.get(klass.getName()));
    }

    public static final boolean isMarkedNullable(@NotNull IrType $this$isMarkedNullable) {
        Intrinsics.checkNotNullParameter($this$isMarkedNullable, "<this>");
        IrSimpleType irSimpleType = $this$isMarkedNullable instanceof IrSimpleType ? (IrSimpleType)$this$isMarkedNullable : null;
        return (irSimpleType != null ? irSimpleType.getNullability() : null) == SimpleTypeNullability.MARKED_NULLABLE;
    }

    public static final boolean isMarkedNullable(@NotNull IrSimpleType $this$isMarkedNullable) {
        Intrinsics.checkNotNullParameter($this$isMarkedNullable, "<this>");
        return $this$isMarkedNullable.getNullability() == SimpleTypeNullability.MARKED_NULLABLE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean canBeNull(@NotNull IrType $this$canBeNull) {
        Intrinsics.checkNotNullParameter($this$canBeNull, "<this>");
        IrType irType = $this$canBeNull;
        if (irType instanceof IrSimpleType) {
            IrType it;
            if (IrTypePredicatesKt.isMarkedNullable((IrSimpleType)$this$canBeNull)) return true;
            if ((IrSimpleType)$this$canBeNull instanceof IrCapturedType) {
                IrType it2;
                Iterable $this$any$iv = ((IrCapturedType)$this$canBeNull).getConstructor().getSuperTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator iterator2 = $this$any$iv.iterator();
                do {
                    if (!iterator2.hasNext()) return false;
                    Object element$iv = iterator2.next();
                    it2 = (IrType)element$iv;
                    boolean bl = false;
                } while (!IrTypePredicatesKt.canBeNull(it2));
                return true;
            }
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$canBeNull).getClassifier();
            if (!(irClassifierSymbol instanceof IrTypeParameterSymbol)) return false;
            IrTypeParameterSymbol irTypeParameterSymbol = (IrTypeParameterSymbol)irClassifierSymbol;
            List<IrType> list = irTypeParameterSymbol;
            if (irTypeParameterSymbol == null) return false;
            IrTypeParameter irTypeParameter = (IrTypeParameter)list.getOwner();
            list = irTypeParameter;
            if (irTypeParameter == null) return false;
            List<IrType> list2 = ((IrTypeParameter)((Object)list)).getSuperTypes();
            list = list2;
            if (list2 == null) return false;
            Iterable $this$all$iv = list;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator3 = $this$all$iv.iterator();
            do {
                if (!iterator3.hasNext()) return true;
                Object element$iv = iterator3.next();
                it = (IrType)element$iv;
                boolean bl = false;
            } while (IrTypePredicatesKt.canBeNull(it));
            return false;
        }
        if (irType instanceof IrDynamicType) {
            return true;
        }
        if (!(irType instanceof IrErrorType)) throw new NoWhenBranchMatchedException();
        boolean bl = ((IrErrorType)$this$canBeNull).isMarkedNullable();
        return bl;
    }

    public static final boolean isUnit(@NotNull IrType $this$isUnit) {
        Intrinsics.checkNotNullParameter($this$isUnit, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isUnit, IdSignatureValues.unit);
    }

    public static final boolean isBoolean(@NotNull IrType $this$isBoolean) {
        Intrinsics.checkNotNullParameter($this$isBoolean, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isBoolean, IdSignatureValues._boolean);
    }

    public static final boolean isChar(@NotNull IrType $this$isChar) {
        Intrinsics.checkNotNullParameter($this$isChar, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isChar, IdSignatureValues._char);
    }

    public static final boolean isByte(@NotNull IrType $this$isByte) {
        Intrinsics.checkNotNullParameter($this$isByte, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isByte, IdSignatureValues._byte);
    }

    public static final boolean isShort(@NotNull IrType $this$isShort) {
        Intrinsics.checkNotNullParameter($this$isShort, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isShort, IdSignatureValues._short);
    }

    public static final boolean isInt(@NotNull IrType $this$isInt) {
        Intrinsics.checkNotNullParameter($this$isInt, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isInt, IdSignatureValues._int);
    }

    public static final boolean isLong(@NotNull IrType $this$isLong) {
        Intrinsics.checkNotNullParameter($this$isLong, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isLong, IdSignatureValues._long);
    }

    public static final boolean isUByte(@NotNull IrType $this$isUByte) {
        Intrinsics.checkNotNullParameter($this$isUByte, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isUByte, IdSignatureValues.uByte);
    }

    public static final boolean isUShort(@NotNull IrType $this$isUShort) {
        Intrinsics.checkNotNullParameter($this$isUShort, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isUShort, IdSignatureValues.uShort);
    }

    public static final boolean isUInt(@NotNull IrType $this$isUInt) {
        Intrinsics.checkNotNullParameter($this$isUInt, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isUInt, IdSignatureValues.uInt);
    }

    public static final boolean isULong(@NotNull IrType $this$isULong) {
        Intrinsics.checkNotNullParameter($this$isULong, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isULong, IdSignatureValues.uLong);
    }

    public static final boolean isFloat(@NotNull IrType $this$isFloat) {
        Intrinsics.checkNotNullParameter($this$isFloat, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isFloat, IdSignatureValues._float);
    }

    public static final boolean isDouble(@NotNull IrType $this$isDouble) {
        Intrinsics.checkNotNullParameter($this$isDouble, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isDouble, IdSignatureValues._double);
    }

    public static final boolean isNumber(@NotNull IrType $this$isNumber) {
        Intrinsics.checkNotNullParameter($this$isNumber, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isNumber, IdSignatureValues.number);
    }

    public static final boolean isDoubleOrFloatWithoutNullability(@NotNull IrType $this$isDoubleOrFloatWithoutNullability) {
        Intrinsics.checkNotNullParameter($this$isDoubleOrFloatWithoutNullability, "<this>");
        return IrTypePredicatesKt.isClassType($this$isDoubleOrFloatWithoutNullability, IdSignatureValues._double, null) || IrTypePredicatesKt.isClassType($this$isDoubleOrFloatWithoutNullability, IdSignatureValues._float, null);
    }

    public static final boolean isComparable(@NotNull IrType $this$isComparable) {
        Intrinsics.checkNotNullParameter($this$isComparable, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isComparable, IdSignatureValues.comparable);
    }

    public static final boolean isCharSequence(@NotNull IrType $this$isCharSequence) {
        Intrinsics.checkNotNullParameter($this$isCharSequence, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isCharSequence, IdSignatureValues.charSequence);
    }

    public static final boolean isIterable(@NotNull IrType $this$isIterable) {
        Intrinsics.checkNotNullParameter($this$isIterable, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isIterable, IdSignatureValues.iterable);
    }

    public static final boolean isSequence(@NotNull IrType $this$isSequence) {
        Intrinsics.checkNotNullParameter($this$isSequence, "<this>");
        return IrTypePredicatesKt.isNotNullClassType($this$isSequence, IdSignatureValues.sequence);
    }

    public static final boolean isBooleanArray(@NotNull IrType $this$isBooleanArray) {
        Intrinsics.checkNotNullParameter($this$isBooleanArray, "<this>");
        IdSignature.CommonSignature commonSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.BOOLEAN);
        Intrinsics.checkNotNull(commonSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isBooleanArray, commonSignature);
    }

    public static final boolean isCharArray(@NotNull IrType $this$isCharArray) {
        Intrinsics.checkNotNullParameter($this$isCharArray, "<this>");
        IdSignature.CommonSignature commonSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.CHAR);
        Intrinsics.checkNotNull(commonSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isCharArray, commonSignature);
    }

    public static final boolean isByteArray(@NotNull IrType $this$isByteArray) {
        Intrinsics.checkNotNullParameter($this$isByteArray, "<this>");
        IdSignature.CommonSignature commonSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.BYTE);
        Intrinsics.checkNotNull(commonSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isByteArray, commonSignature);
    }

    public static final boolean isShortArray(@NotNull IrType $this$isShortArray) {
        Intrinsics.checkNotNullParameter($this$isShortArray, "<this>");
        IdSignature.CommonSignature commonSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.SHORT);
        Intrinsics.checkNotNull(commonSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isShortArray, commonSignature);
    }

    public static final boolean isIntArray(@NotNull IrType $this$isIntArray) {
        Intrinsics.checkNotNullParameter($this$isIntArray, "<this>");
        IdSignature.CommonSignature commonSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.INT);
        Intrinsics.checkNotNull(commonSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isIntArray, commonSignature);
    }

    public static final boolean isLongArray(@NotNull IrType $this$isLongArray) {
        Intrinsics.checkNotNullParameter($this$isLongArray, "<this>");
        IdSignature.CommonSignature commonSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.LONG);
        Intrinsics.checkNotNull(commonSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isLongArray, commonSignature);
    }

    public static final boolean isFloatArray(@NotNull IrType $this$isFloatArray) {
        Intrinsics.checkNotNullParameter($this$isFloatArray, "<this>");
        IdSignature.CommonSignature commonSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.FLOAT);
        Intrinsics.checkNotNull(commonSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isFloatArray, commonSignature);
    }

    public static final boolean isDoubleArray(@NotNull IrType $this$isDoubleArray) {
        Intrinsics.checkNotNullParameter($this$isDoubleArray, "<this>");
        IdSignature.CommonSignature commonSignature = primitiveArrayTypesSignatures.get((Object)PrimitiveType.DOUBLE);
        Intrinsics.checkNotNull(commonSignature);
        return IrTypePredicatesKt.isNotNullClassType($this$isDoubleArray, commonSignature);
    }

    public static final boolean isClassType(@NotNull IrType $this$isClassType, @NotNull FqNameUnsafe fqName2, boolean nullable) {
        Intrinsics.checkNotNullParameter($this$isClassType, "<this>");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        if (!($this$isClassType instanceof IrSimpleType)) {
            return false;
        }
        if (IrTypePredicatesKt.isMarkedNullable((IrSimpleType)$this$isClassType) != nullable) {
            return false;
        }
        return IrTypePredicatesKt.isClassWithFqName(((IrSimpleType)$this$isClassType).getClassifier(), fqName2);
    }

    public static final boolean isKotlinResult(@NotNull IrType $this$isKotlinResult) {
        Intrinsics.checkNotNullParameter($this$isKotlinResult, "<this>");
        return IrTypePredicatesKt.isClassType($this$isKotlinResult, StandardNames.RESULT_FQ_NAME.toUnsafe(), false);
    }

    public static final boolean isNullableContinuation(@NotNull IrType $this$isNullableContinuation) {
        Intrinsics.checkNotNullParameter($this$isNullableContinuation, "<this>");
        return IrTypePredicatesKt.isClassType($this$isNullableContinuation, StandardNames.CONTINUATION_INTERFACE_FQ_NAME.toUnsafe(), true);
    }

    public static final boolean isKClass(@NotNull IrType $this$isKClass) {
        Intrinsics.checkNotNullParameter($this$isKClass, "<this>");
        return IrTypePredicatesKt.isClassType($this$isKClass, StandardNames.FqNames.kClass, false);
    }

    static {
        IdSignature.CommonSignature commonSignature;
        Object t2;
        Iterable $this$associateWithTo$iv$iv;
        Enum p0;
        Enum it;
        Map map2;
        Iterable $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = PrimitiveType.getEntries();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            PrimitiveType primitiveType = (PrimitiveType)((Object)element$iv$iv);
            map2 = destination$iv$iv;
            boolean bl = false;
            String string = ((PrimitiveType)it).getTypeName().asString();
            Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
            map2.put(IrTypePredicatesKt.getPublicSignature(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, string), element$iv$iv);
        }
        idSignatureToPrimitiveType = destination$iv$iv;
        $this$associateBy$iv = PrimitiveType.getEntries();
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            it = (PrimitiveType)((Object)element$iv$iv);
            map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(((PrimitiveType)p0).getTypeName(), element$iv$iv);
        }
        shortNameToPrimitiveType = destination$iv$iv;
        $this$associateBy$iv = UnsignedType.getEntries();
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            p0 = (UnsignedType)((Object)element$iv$iv);
            map2 = destination$iv$iv;
            boolean bl = false;
            String string = ((UnsignedType)it).getTypeName().asString();
            Intrinsics.checkNotNullExpressionValue(string, "asString(...)");
            map2.put(IrTypePredicatesKt.getPublicSignature(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, string), element$iv$iv);
        }
        idSignatureToUnsignedType = destination$iv$iv;
        $this$associateBy$iv = UnsignedType.getEntries();
        $i$f$associateBy = false;
        capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            it = (UnsignedType)((Object)element$iv$iv);
            map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(((UnsignedType)p0).getTypeName(), element$iv$iv);
        }
        shortNameToUnsignedType = destination$iv$iv;
        Iterable $this$associateWith$iv = PrimitiveType.getEntries();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        $this$associateByTo$iv$iv = $this$associateWith$iv;
        destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            p0 = (PrimitiveType)((Object)element$iv$iv);
            t2 = element$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            commonSignature = IrTypePredicatesKt.getPublicSignature(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, ((PrimitiveType)it).getTypeName().asString() + "Array");
            map2.put(t2, commonSignature);
        }
        primitiveArrayTypesSignatures = destination$iv$iv;
        $this$associateWith$iv = UnsignedType.getEntries();
        $i$f$associateWith = false;
        result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        $this$associateWithTo$iv$iv = $this$associateWith$iv;
        destination$iv$iv = result$iv;
        $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            it = (UnsignedType)((Object)element$iv$iv);
            t2 = element$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            commonSignature = IrTypePredicatesKt.getPublicSignature(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, ((UnsignedType)it).getTypeName().asString() + "Array");
            map2.put(t2, commonSignature);
        }
        unsignedArrayTypesSignatures = destination$iv$iv;
    }
}

