/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collector;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectIterators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectListIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ax;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.s;

public class ObjectArrayList<K>
extends s<K>
implements Serializable,
Cloneable,
RandomAccess {
    private static final long serialVersionUID = -7046029254386353131L;
    protected final boolean wrapped;
    protected transient K[] a;
    protected int size;
    private static final Collector<Object, ?, ObjectArrayList<Object>> b = Collector.of(ObjectArrayList::new, ObjectArrayList::add, ObjectArrayList::a, new Collector.Characteristics[0]);

    private static final <K> K[] a(K[] KArray, int n2) {
        if (n2 == 0) {
            return ObjectArrays.EMPTY_ARRAY;
        }
        return java.util.Arrays.copyOf(KArray, n2, Object[].class);
    }

    /*
     * WARNING - void declaration
     */
    protected ObjectArrayList(K[] a2, boolean wrapped) {
        void var2_2;
        void var1_1;
        this.a = var1_1;
        this.wrapped = var2_2;
    }

    private void c(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Initial capacity (" + n2 + ") is negative");
        }
        if (n2 == 0) {
            this.a = ObjectArrays.EMPTY_ARRAY;
            return;
        }
        this.a = new Object[n2];
    }

    /*
     * WARNING - void declaration
     */
    public ObjectArrayList(int capacity) {
        void var1_1;
        this.c((int)var1_1);
        this.wrapped = false;
    }

    public ObjectArrayList() {
        this.a = ObjectArrays.DEFAULT_EMPTY_ARRAY;
        this.wrapped = false;
    }

    ObjectArrayList<K> a(ObjectArrayList<? extends K> objectArrayList) {
        this.b(objectArrayList);
        return this;
    }

    private void d(int n2) {
        if (n2 <= this.a.length) {
            return;
        }
        if (this.a != ObjectArrays.DEFAULT_EMPTY_ARRAY) {
            n2 = (int)Math.max(Math.min((long)this.a.length + (long)(this.a.length >> 1), 0x7FFFFFF7L), (long)n2);
        } else if (n2 < 10) {
            n2 = 10;
        }
        if (this.wrapped) {
            this.a = ObjectArrays.forceCapacity(this.a, n2, this.size);
        } else {
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.a, 0, objectArray, 0, this.size);
            this.a = objectArray;
        }
        assert (this.size <= this.a.length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(int index, K k2) {
        void var2_2;
        this.a(index);
        ObjectArrayList objectArrayList = this;
        objectArrayList.d(objectArrayList.size + 1);
        if (index != this.size) {
            System.arraycopy(this.a, index, this.a, index + 1, this.size - index);
        }
        this.a[var1_1] = var2_2;
        ++this.size;
        assert (this.size <= this.a.length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(K k2) {
        void var1_1;
        ObjectArrayList objectArrayList = this;
        objectArrayList.d(objectArrayList.size + 1);
        this.a[this.size++] = var1_1;
        assert (this.size <= this.a.length);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K get(int index) {
        void var1_1;
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        return this.a[var1_1];
    }

    @Override
    public int indexOf(Object k2) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (!Objects.equals(k2, this.a[i2])) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object k2) {
        int n2 = this.size;
        while (n2-- != 0) {
            if (!Objects.equals(k2, this.a[n2])) continue;
            return n2;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K remove(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        K k2 = this.a[index];
        --this.size;
        if (index != this.size) {
            void var1_1;
            System.arraycopy(this.a, index + 1, this.a, index, this.size - var1_1);
        }
        this.a[this.size] = null;
        assert (this.size <= this.a.length);
        return k2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Object k2) {
        void var1_1;
        int n2 = ((s)this).indexOf(var1_1);
        if (n2 == -1) {
            return false;
        }
        ((s)this).remove(n2);
        assert (this.size <= this.a.length);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K set(int index, K k2) {
        void var2_2;
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.size + ")");
        }
        K k3 = this.a[index];
        this.a[var1_1] = var2_2;
        return k3;
    }

    @Override
    public void clear() {
        java.util.Arrays.fill(this.a, 0, this.size, null);
        this.size = 0;
        assert (this.size <= this.a.length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ObjectList<K> subList(int from2, int to) {
        void var2_2;
        void var1_1;
        if (from2 == 0 && to == this.size()) {
            return this;
        }
        this.a(from2);
        this.a(to);
        if (from2 > to) {
            throw new IndexOutOfBoundsException("Start index (" + from2 + ") is greater than end index (" + to + ")");
        }
        return new b((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getElements(int from2, Object[] a2, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        ObjectArrays.ensureOffsetLength(a2, offset, length);
        System.arraycopy(this.a, (int)var1_1, var2_2, (int)var3_3, length);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeElements(int from2, int to) {
        void var1_1;
        void var2_2;
        Arrays.ensureFromTo(this.size, from2, to);
        System.arraycopy(this.a, to, this.a, from2, this.size - to);
        this.size -= to - from2;
        var1_1 = var2_2 - var1_1;
        while (var1_1-- != false) {
            this.a[this.size + var1_1] = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setElements(int index, K[] a2, int offset, int length) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.a(index);
        ObjectArrays.ensureOffsetLength(a2, offset, length);
        if (index + length > this.size) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size + ")");
        }
        System.arraycopy(var2_2, (int)var3_3, this.a, (int)var1_1, length);
    }

    @Override
    public void forEach(Consumer<? super K> action) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            action.accept(this.a[i2]);
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends K> c2) {
        Iterator iterator2;
        if (c2 instanceof ObjectList) {
            return this.addAll(index, (ObjectList)c2);
        }
        this.a(index);
        int n2 = c2.size();
        if (n2 == 0) {
            return false;
        }
        ObjectArrayList objectArrayList = this;
        objectArrayList.d(objectArrayList.size + n2);
        System.arraycopy(this.a, index, this.a, index + n2, this.size - index);
        iterator2 = iterator2.iterator();
        this.size += n2;
        while (n2-- != 0) {
            this.a[index++] = iterator2.next();
        }
        assert (this.size <= this.a.length);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(int index, ObjectList<? extends K> l2) {
        void var1_1;
        void var2_2;
        this.a(index);
        int n2 = l2.size();
        if (n2 == 0) {
            return false;
        }
        ObjectArrayList objectArrayList = this;
        objectArrayList.d(objectArrayList.size + n2);
        System.arraycopy(this.a, index, this.a, index + n2, this.size - index);
        var2_2.getElements(0, this.a, (int)var1_1, n2);
        this.size += n2;
        assert (this.size <= this.a.length);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        int n2;
        Object[] objectArray = this.a;
        int n3 = 0;
        for (n2 = 0; n2 < this.size; n2 += 1) {
            if (c2.contains(objectArray[n2])) continue;
            objectArray[n3++] = objectArray[n2];
        }
        java.util.Arrays.fill(objectArray, n3, this.size, null);
        n2 = this.size != n3 ? 1 : 0;
        this.size = n3;
        return n2 != 0;
    }

    @Override
    public boolean removeIf(Predicate<? super K> filter2) {
        int n2;
        Object[] objectArray = this.a;
        int n3 = 0;
        for (n2 = 0; n2 < this.size; n2 += 1) {
            if (filter2.test(objectArray[n2])) continue;
            objectArray[n3++] = objectArray[n2];
        }
        java.util.Arrays.fill(objectArray, n3, this.size, null);
        n2 = this.size != n3 ? 1 : 0;
        this.size = n3;
        return n2 != 0;
    }

    @Override
    public Object[] toArray() {
        int n2 = this.size();
        if (n2 == 0) {
            return ObjectArrays.EMPTY_ARRAY;
        }
        return java.util.Arrays.copyOf(this.a, n2, Object[].class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T[] toArray(T[] a2) {
        void var1_1;
        if (a2 == null) {
            a2 = new Object[this.size()];
        } else if (a2.length < this.size()) {
            a2 = (Object[])Array.newInstance(a2.getClass().getComponentType(), this.size());
        }
        System.arraycopy(this.a, 0, a2, 0, this.size());
        if (a2.length > this.size()) {
            a2[this.size()] = null;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ObjectListIterator<K> listIterator(int index) {
        void var1_1;
        this.a(index);
        return new ObjectListIterator<K>(){
            private int a;
            private int b;
            private /* synthetic */ int c;
            private /* synthetic */ ObjectArrayList d;
            {
                this.d = objectArrayList;
                this.c = n2;
                this.a = this.c;
                this.b = -1;
            }

            @Override
            public final boolean hasNext() {
                return this.a < this.d.size;
            }

            @Override
            public final boolean hasPrevious() {
                return this.a > 0;
            }

            @Override
            public final K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.b = this.a++;
                return this.d.a[this.b];
            }

            @Override
            public final K previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.b = --this.a;
                return this.d.a[this.a];
            }

            @Override
            public final int nextIndex() {
                return this.a;
            }

            @Override
            public final int previousIndex() {
                return this.a - 1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void add(K k2) {
                void var1_1;
                ((s)this.d).add(this.a++, var1_1);
                this.b = -1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void set(K k2) {
                void var1_1;
                if (this.b == -1) {
                    throw new IllegalStateException();
                }
                ((s)this.d).set(this.b, var1_1);
            }

            @Override
            public final void remove() {
                if (this.b == -1) {
                    throw new IllegalStateException();
                }
                ((s)this.d).remove(this.b);
                if (this.b < this.a) {
                    --this.a;
                }
                this.b = -1;
            }

            @Override
            public final void forEachRemaining(Consumer<? super K> action) {
                while (this.a < this.d.size) {
                    ++this.a;
                    this.b = this.b;
                    action.accept(this.d.a[this.b]);
                }
            }
        };
    }

    @Override
    public ObjectSpliterator<K> spliterator() {
        return new a(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sort(Comparator<? super K> comp) {
        void var1_1;
        if (comp == null) {
            ObjectArrays.stableSort(this.a, 0, this.size);
            return;
        }
        ObjectArrays.stableSort(this.a, 0, this.size, var1_1);
    }

    public ObjectArrayList<K> clone() {
        ObjectArrayList<K> objectArrayList;
        if (this.getClass() == ObjectArrayList.class) {
            objectArrayList = new ObjectArrayList<K>(ObjectArrayList.a(this.a, this.size), false);
            new ObjectArrayList<K>(ObjectArrayList.a(this.a, this.size), false).size = this.size;
        } else {
            try {
                objectArrayList = (ObjectArrayList<K>)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException);
            }
            objectArrayList.a = ObjectArrayList.a(this.a, this.size);
        }
        return objectArrayList;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(ObjectArrayList<K> l2) {
        void var1_1;
        if (l2 == this) {
            return true;
        }
        int n2 = this.size();
        if (n2 != l2.size()) {
            return false;
        }
        K[] KArray = this.a;
        K[] KArray2 = l2.a;
        if (KArray == KArray2 && n2 == var1_1.size()) {
            return true;
        }
        while (n2-- != 0) {
            if (Objects.equals(KArray[n2], KArray2[n2])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o2) {
        void var1_1;
        if (o2 == this) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (!(o2 instanceof List)) {
            return false;
        }
        if (o2 instanceof ObjectArrayList) {
            return this.equals((ObjectArrayList)o2);
        }
        if (o2 instanceof b) {
            return ((s)((b)o2)).equals(this);
        }
        return super.equals(var1_1);
    }

    @Override
    public int compareTo(ObjectArrayList<? extends K> l2) {
        int n2;
        K[] KArray;
        int n3 = this.size();
        int n4 = l2.size();
        K[] KArray2 = this.a;
        KArray = KArray.a;
        for (n2 = 0; n2 < n3 && n2 < n4; ++n2) {
            K k2 = KArray2[n2];
            K k3 = KArray[n2];
            int n5 = ((Comparable)k2).compareTo(k3);
            if (n5 == 0) continue;
            return n5;
        }
        if (n2 < n4) {
            return -1;
        }
        if (n2 < n3) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(List<? extends K> l2) {
        void var1_1;
        if (l2 instanceof ObjectArrayList) {
            return this.compareTo((ObjectArrayList)l2);
        }
        if (l2 instanceof b) {
            return -((s)((b)l2)).compareTo(this);
        }
        return super.compareTo(var1_1);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        for (int i2 = 0; i2 < this.size; ++i2) {
            s2.writeObject(this.a[i2]);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.a = new Object[this.size];
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.a[i2] = s2.readObject();
        }
    }

    private final class org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrayList$b
    extends s.b<K> {
        private static final long serialVersionUID = -3185226345314976296L;

        protected org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrayList$b(int n2, int n3) {
            super(ObjectArrayList.this, n2, n3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K get(int i2) {
            void var1_1;
            this.b(i2);
            return ObjectArrayList.this.a[var1_1 + this.b];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ObjectListIterator<K> listIterator(int index) {
            void var1_1;
            return new a(this, (int)var1_1);
        }

        @Override
        public final ObjectSpliterator<K> spliterator() {
            return new b(this);
        }

        private boolean a(K[] KArray, int n2, int n3) {
            if (ObjectArrayList.this.a == KArray && this.b == n2 && this.c == n3) {
                return true;
            }
            if (n3 - n2 != this.size()) {
                return false;
            }
            n3 = this.b;
            while (n3 < this.c) {
                if (Objects.equals(ObjectArrayList.this.a[n3++], KArray[n2++])) continue;
                return false;
            }
            return true;
        }

        @Override
        public final boolean equals(Object o2) {
            s s2;
            if (o2 == this) {
                return true;
            }
            if (o2 == null) {
                return false;
            }
            if (!(o2 instanceof List)) {
                return false;
            }
            if (o2 instanceof ObjectArrayList) {
                s2 = (ObjectArrayList)s2;
                return this.a(((ObjectArrayList)s2).a, 0, ((ObjectArrayList)s2).size());
            }
            if (s2 instanceof org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrayList$b) {
                s2 = (org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrayList$b)s2;
                return this.a(((org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrayList$b)s2).ObjectArrayList.this.a, ((s.c)s2).b, ((s.c)s2).c);
            }
            return super.equals(s2);
        }

        private int b(K[] KArray, int n2, int n3) {
            int n4 = this.b;
            int n5 = n2;
            while (n4 < this.c && n4 < n3) {
                Object k2 = ObjectArrayList.this.a[n4];
                Object k3 = KArray[n5];
                n2 = ((Comparable)k2).compareTo(k3);
                if (n2 != 0) {
                    return n2;
                }
                ++n4;
                ++n5;
            }
            if (n4 < n3) {
                return -1;
            }
            if (n4 < this.c) {
                return 1;
            }
            return 0;
        }

        @Override
        public final int compareTo(List<? extends K> l2) {
            s s2;
            if (l2 instanceof ObjectArrayList) {
                s2 = (ObjectArrayList)s2;
                return this.b(((ObjectArrayList)s2).a, 0, ((ObjectArrayList)s2).size());
            }
            if (s2 instanceof org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrayList$b) {
                s2 = (org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrayList$b)s2;
                return this.b(((org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrayList$b)s2).ObjectArrayList.this.a, ((s.c)s2).b, ((s.c)s2).c);
            }
            return super.compareTo(s2);
        }

        private final class a
        extends ObjectIterators.b<K> {
            private /* synthetic */ org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrayList$b d;

            a(org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrayList$b b2, int n2) {
                this.d = b2;
                super(n2);
            }

            @Override
            protected final K a(int n2) {
                return this.d.ObjectArrayList.this.a[this.d.b + n2];
            }

            @Override
            protected final void a(int n2, K k2) {
                ((s)this.d).add(n2, k2);
            }

            @Override
            protected final void b(int n2, K k2) {
                ((s)this.d).set(n2, k2);
            }

            @Override
            protected final void b(int n2) {
                ((s)this.d).remove(n2);
            }

            @Override
            protected final int a() {
                return this.d.c - this.d.b;
            }

            @Override
            public final K next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.c = this.b++;
                return this.d.ObjectArrayList.this.a[this.d.b + this.c];
            }

            @Override
            public final K previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.c = --this.b;
                return this.d.ObjectArrayList.this.a[this.d.b + this.b];
            }

            @Override
            public final void forEachRemaining(Consumer<? super K> action) {
                int n2 = this.d.c - this.d.b;
                while (this.b < n2) {
                    ++this.b;
                    this.c = this.c;
                    action.accept(this.d.ObjectArrayList.this.a[this.d.b + this.c]);
                }
            }
        }

        private final class b
        extends ax.f<K> {
            private /* synthetic */ org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrayList$b b;

            b(org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrayList$b b2) {
                this.b = b2;
                super(b2.b);
            }

            private b(org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.ObjectArrayList$b b2, int n2, int n3) {
                this.b = b2;
                super(n2, n3);
            }

            @Override
            protected final int b() {
                return this.b.c;
            }

            @Override
            protected final K a(int n2) {
                return this.b.ObjectArrayList.this.a[n2];
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean tryAdvance(Consumer<? super K> action) {
                void var1_1;
                if (this.a >= this.c()) {
                    return false;
                }
                var1_1.accept(this.b.ObjectArrayList.this.a[this.a++]);
                return true;
            }

            @Override
            public final void forEachRemaining(Consumer<? super K> action) {
                int n2 = this.c();
                while (this.a < n2) {
                    action.accept(this.b.ObjectArrayList.this.a[this.a++]);
                }
            }

            protected final /* synthetic */ ax.a a(int n2, int n3) {
                int n4 = n3;
                n3 = n2;
                b b2 = this;
                return new b(b2.b, n3, n4);
            }
        }
    }

    private final class a
    implements ObjectSpliterator<K> {
        private boolean a = false;
        private int b;
        private int c;
        private /* synthetic */ ObjectArrayList e;

        public a(ObjectArrayList objectArrayList) {
            this(objectArrayList, 0, objectArrayList.size, false);
        }

        private a(ObjectArrayList objectArrayList, int n2, int n3, boolean bl) {
            this.e = objectArrayList;
            assert (n2 <= n3) : "pos " + n2 + " must be <= max " + n3;
            this.b = n2;
            this.c = n3;
            this.a = bl;
        }

        private int b() {
            if (this.a) {
                return this.c;
            }
            return this.e.size;
        }

        @Override
        public final int characteristics() {
            return 16464;
        }

        @Override
        public final long estimateSize() {
            return this.b() - this.b;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean tryAdvance(Consumer<? super K> action) {
            void var1_1;
            if (this.b >= this.b()) {
                return false;
            }
            var1_1.accept(this.e.a[this.b++]);
            return true;
        }

        @Override
        public final void forEachRemaining(Consumer<? super K> action) {
            int n2 = this.b();
            while (this.b < n2) {
                action.accept(this.e.a[this.b]);
                ++this.b;
            }
        }

        @Override
        public final ObjectSpliterator<K> a() {
            int n2 = this.b();
            int n3 = n2 - this.b >> 1;
            if (n3 <= 1) {
                return null;
            }
            this.c = n2;
            n3 = n2 = this.b + n3;
            int n4 = this.b;
            this.b = n2;
            this.a = true;
            return new a(this.e, n4, n3, true);
        }

        @Override
        public final /* synthetic */ Spliterator trySplit() {
            return this.a();
        }
    }
}

