/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.target;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.konan.target.Distribution;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.Platform;
import org.jetbrains.kotlin.konan.target.PlatformManager;
import org.jetbrains.kotlin.konan.target.TargetManager;
import org.jetbrains.kotlin.konan.util.SubstitutionKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020#H&J\u0006\u0010%\u001a\u00020#R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000fR\u0011\u0010\u001d\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/konan/target/AbstractToolConfig;", "", "konanHome", "", "userProvidedTargetName", "propertyOverrides", "", "konanDataDir", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "distribution", "Lorg/jetbrains/kotlin/konan/target/Distribution;", "host", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "libclang", "getLibclang", "()Ljava/lang/String;", "llvmHome", "getLlvmHome", "platform", "Lorg/jetbrains/kotlin/konan/target/Platform;", "getPlatform", "()Lorg/jetbrains/kotlin/konan/target/Platform;", "platformManager", "Lorg/jetbrains/kotlin/konan/target/PlatformManager;", "substitutions", "getSubstitutions", "()Ljava/util/Map;", "sysRoot", "getSysRoot", "target", "getTarget", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "targetManager", "Lorg/jetbrains/kotlin/konan/target/TargetManager;", "downloadDependencies", "", "loadLibclang", "prepare", "kotlin-native-utils"})
public abstract class AbstractToolConfig {
    @NotNull
    private final Distribution distribution;
    @NotNull
    private final PlatformManager platformManager;
    @NotNull
    private final TargetManager targetManager;
    @NotNull
    private final KonanTarget host;
    @NotNull
    private final KonanTarget target;
    @NotNull
    private final Platform platform;
    @NotNull
    private final Map<String, String> substitutions;
    @NotNull
    private final String llvmHome;
    @NotNull
    private final String sysRoot;
    @NotNull
    private final String libclang;

    public AbstractToolConfig(@NotNull String konanHome, @Nullable String userProvidedTargetName, @NotNull Map<String, String> propertyOverrides, @Nullable String konanDataDir) {
        Intrinsics.checkNotNullParameter(konanHome, "konanHome");
        Intrinsics.checkNotNullParameter(propertyOverrides, "propertyOverrides");
        this.distribution = new Distribution(konanHome, false, null, propertyOverrides, konanDataDir, 6, null);
        this.platformManager = new PlatformManager(this.distribution);
        this.targetManager = this.platformManager.targetManager(userProvidedTargetName);
        this.host = HostManager.Companion.getHost();
        this.target = this.targetManager.getTarget();
        this.platform = this.platformManager.platform(this.target);
        this.substitutions = SubstitutionKt.defaultTargetSubstitutions(this.target);
        this.llvmHome = this.platform.getAbsoluteLlvmHome();
        this.sysRoot = this.platform.getAbsoluteTargetSysRoot();
        this.libclang = Intrinsics.areEqual(this.host, KonanTarget.MINGW_X64.INSTANCE) ? this.llvmHome + "/bin/libclang.dll" : this.llvmHome + "/lib/" + System.mapLibraryName("clang");
    }

    public /* synthetic */ AbstractToolConfig(String string, String string2, Map map2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            string3 = null;
        }
        this(string, string2, map2, string3);
    }

    @NotNull
    public final KonanTarget getTarget() {
        return this.target;
    }

    @NotNull
    protected final Platform getPlatform() {
        return this.platform;
    }

    @NotNull
    public final Map<String, String> getSubstitutions() {
        return this.substitutions;
    }

    public final void downloadDependencies() {
        this.platform.downloadDependencies();
    }

    @NotNull
    public final String getLlvmHome() {
        return this.llvmHome;
    }

    @NotNull
    public final String getSysRoot() {
        return this.sysRoot;
    }

    @NotNull
    public final String getLibclang() {
        return this.libclang;
    }

    public abstract void loadLibclang();

    public final void prepare() {
        this.downloadDependencies();
        this.loadLibclang();
    }
}

