/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl.classFiles;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.com.intellij.util.containers.Interner;
import org.jetbrains.kotlin.load.java.structure.JavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.BinaryJavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.ClassifierResolutionContext;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaArrayType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaClassifierType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaPrimitiveType;
import org.jetbrains.kotlin.load.java.structure.impl.classFiles.PlainJavaWildcardType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.PlatformUtilsKt;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;
import shadow.org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002!\"B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010\u0019\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u001e\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser;", "", "<init>", "()V", "canonicalNameInterner", "Lorg/jetbrains/kotlin/com/intellij/util/containers/Interner;", "", "parseTypeParametersDeclaration", "", "Lorg/jetbrains/kotlin/load/java/structure/JavaTypeParameter;", "signature", "Ljava/text/CharacterIterator;", "context", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/ClassifierResolutionContext;", "parseTypeParameter", "parseClassifierRefSignature", "Lorg/jetbrains/kotlin/load/java/structure/JavaClassifierType;", "parseTypeVariableRefSignature", "parseParameterizedClassRefSignature", "parseClassOrTypeVariableElement", "Lorg/jetbrains/kotlin/load/java/structure/JavaType;", "parseVariance", "Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$JavaSignatureVariance;", "parseDimensions", "", "parseTypeString", "mapAsmType", "type", "Lshadow/org/jetbrains/org/objectweb/asm/Type;", "parseTypeWithoutVarianceAndArray", "parsePrimitiveType", "primitiveType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "JavaSignatureVariance", "ClsFormatException", "frontend.common.jvm"})
@SourceDebugExtension(value={"SMAP\nBinaryClassSignatureParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BinaryClassSignatureParser.kt\norg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,229:1\n1803#2,3:230\n*S KotlinDebug\n*F\n+ 1 BinaryClassSignatureParser.kt\norg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser\n*L\n200#1:230,3\n*E\n"})
public final class BinaryClassSignatureParser {
    @NotNull
    private final Interner<String> canonicalNameInterner = PlatformUtilsKt.createStringInterner();

    @NotNull
    public final List<JavaTypeParameter> parseTypeParametersDeclaration(@NotNull CharacterIterator signature2, @NotNull ClassifierResolutionContext context2) {
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (signature2.current() != '<') {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        ArrayList<JavaTypeParameter> typeParameters2 = new ArrayList<JavaTypeParameter>();
        signature2.next();
        while (signature2.current() != '>') {
            typeParameters2.add(this.parseTypeParameter(signature2, context2));
        }
        signature2.next();
        return CollectionsKt.compact(typeParameters2);
    }

    private final JavaTypeParameter parseTypeParameter(CharacterIterator signature2, ClassifierResolutionContext context2) {
        StringBuilder name2 = new StringBuilder();
        while (signature2.current() != ':' && signature2.current() != '\uffff') {
            name2.append(signature2.current());
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException(null, null, 3, null);
        }
        String string = name2.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String parameterName = string;
        List bounds = new SmartList();
        boolean hasImplicitObjectBound = false;
        while (signature2.current() == ':') {
            signature2.next();
            if (signature2.current() == ':') {
                hasImplicitObjectBound = true;
                continue;
            }
            JavaClassifierType javaClassifierType = this.parseClassifierRefSignature(signature2, context2);
            if (javaClassifierType == null) continue;
            bounds.add(javaClassifierType);
        }
        Name name3 = Name.identifier(parameterName);
        Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        return new BinaryJavaTypeParameter(name3, bounds, hasImplicitObjectBound);
    }

    @Nullable
    public final JavaClassifierType parseClassifierRefSignature(@NotNull CharacterIterator signature2, @NotNull ClassifierResolutionContext context2) {
        JavaClassifierType javaClassifierType;
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(context2, "context");
        switch (signature2.current()) {
            case 'L': {
                javaClassifierType = this.parseParameterizedClassRefSignature(signature2, context2);
                break;
            }
            case 'T': {
                javaClassifierType = this.parseTypeVariableRefSignature(signature2, context2);
                break;
            }
            default: {
                javaClassifierType = null;
            }
        }
        return javaClassifierType;
    }

    private final JavaClassifierType parseTypeVariableRefSignature(CharacterIterator signature2, ClassifierResolutionContext context2) {
        StringBuilder id = new StringBuilder();
        signature2.next();
        while (signature2.current() != ';' && signature2.current() != '>' && signature2.current() != '\uffff') {
            id.append(signature2.current());
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException(null, null, 3, null);
        }
        if (signature2.current() == ';') {
            signature2.next();
        }
        String string = this.canonicalNameInterner.intern(id.toString());
        Intrinsics.checkNotNullExpressionValue(string, "intern(...)");
        String parameterName = string;
        return new PlainJavaClassifierType(() -> BinaryClassSignatureParser.parseTypeVariableRefSignature$lambda$0(context2, parameterName), kotlin.collections.CollectionsKt.emptyList());
    }

    private final JavaClassifierType parseParameterizedClassRefSignature(CharacterIterator signature2, ClassifierResolutionContext context2) {
        StringBuilder canonicalName = new StringBuilder();
        SmartList<List> argumentGroups = new SmartList<List>();
        signature2.next();
        while (signature2.current() != ';' && signature2.current() != '\uffff') {
            char c2 = signature2.current();
            if (c2 == '<') {
                List group = new ArrayList();
                signature2.next();
                do {
                    group.add(this.parseClassOrTypeVariableElement(signature2, context2));
                } while (signature2.current() != '>');
                argumentGroups.add(group);
            } else if (c2 != ' ') {
                canonicalName.append(c2);
            }
            signature2.next();
        }
        if (signature2.current() == '\uffff') {
            throw new ClsFormatException(null, null, 3, null);
        }
        signature2.next();
        String string = canonicalName.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String string2 = this.canonicalNameInterner.intern(StringsKt.replace$default(string, '.', '$', false, 4, null));
        Intrinsics.checkNotNullExpressionValue(string2, "intern(...)");
        String internalName = string2;
        return new PlainJavaClassifierType(() -> BinaryClassSignatureParser.parseParameterizedClassRefSignature$lambda$0(context2, internalName), CollectionsKt.compact((ArrayList)AddToStdlibKt.flattenTo(kotlin.collections.CollectionsKt.reversed((Iterable)argumentGroups), (Collection)new ArrayList())));
    }

    private final JavaType parseClassOrTypeVariableElement(CharacterIterator signature2, ClassifierResolutionContext context2) {
        JavaSignatureVariance variance = this.parseVariance(signature2);
        if (variance == JavaSignatureVariance.STAR) {
            return new PlainJavaWildcardType(null, true);
        }
        JavaType type2 = this.parseTypeString(signature2, context2);
        if (variance == JavaSignatureVariance.NO_VARIANCE) {
            return type2;
        }
        return new PlainJavaWildcardType(type2, variance == JavaSignatureVariance.PLUS);
    }

    private final JavaSignatureVariance parseVariance(CharacterIterator signature2) {
        JavaSignatureVariance variance;
        boolean advance = true;
        switch (signature2.current()) {
            case '+': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.PLUS;
                break;
            }
            case '-': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.MINUS;
                break;
            }
            case '*': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.STAR;
                break;
            }
            case '.': 
            case '=': {
                JavaSignatureVariance javaSignatureVariance = JavaSignatureVariance.NO_VARIANCE;
                break;
            }
            default: {
                advance = false;
                JavaSignatureVariance javaSignatureVariance = variance = JavaSignatureVariance.NO_VARIANCE;
            }
        }
        if (advance) {
            signature2.next();
        }
        return variance;
    }

    private final int parseDimensions(CharacterIterator signature2) {
        int dimensions = 0;
        while (signature2.current() == '[') {
            ++dimensions;
            signature2.next();
        }
        return dimensions;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JavaType parseTypeString(@NotNull CharacterIterator signature2, @NotNull ClassifierResolutionContext context2) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(signature2, "signature");
        Intrinsics.checkNotNullParameter(context2, "context");
        int dimensions = this.parseDimensions(signature2);
        JavaType javaType = this.parseTypeWithoutVarianceAndArray(signature2, context2);
        if (javaType == null) {
            throw new ClsFormatException(null, null, 3, null);
        }
        JavaType type2 = javaType;
        Iterable iterable = new IntRange(1, dimensions);
        JavaType initial$iv = type2;
        boolean $i$f$fold = false;
        JavaType accumulator$iv = initial$iv;
        Iterator iterator2 = $this$fold$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv = ((IntIterator)iterator2).nextInt();
            JavaType result2 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new PlainJavaArrayType(result2);
        }
        return accumulator$iv;
    }

    @NotNull
    public final JavaType mapAsmType(@NotNull Type type2, @NotNull ClassifierResolutionContext context2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(context2, "context");
        return this.parseTypeString(new StringCharacterIterator(type2.getDescriptor()), context2);
    }

    private final JavaType parseTypeWithoutVarianceAndArray(CharacterIterator signature2, ClassifierResolutionContext context2) {
        JavaType javaType;
        switch (signature2.current()) {
            case 'L': {
                javaType = this.parseParameterizedClassRefSignature(signature2, context2);
                break;
            }
            case 'T': {
                javaType = this.parseTypeVariableRefSignature(signature2, context2);
                break;
            }
            case 'B': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.BYTE);
                break;
            }
            case 'C': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.CHAR);
                break;
            }
            case 'D': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.DOUBLE);
                break;
            }
            case 'F': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.FLOAT);
                break;
            }
            case 'I': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.INT);
                break;
            }
            case 'J': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.LONG);
                break;
            }
            case 'Z': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.BOOLEAN);
                break;
            }
            case 'S': {
                javaType = this.parsePrimitiveType(signature2, PrimitiveType.SHORT);
                break;
            }
            case 'V': {
                javaType = this.parsePrimitiveType(signature2, null);
                break;
            }
            default: {
                javaType = null;
            }
        }
        return javaType;
    }

    private final JavaType parsePrimitiveType(CharacterIterator signature2, PrimitiveType primitiveType) {
        signature2.next();
        return new PlainJavaPrimitiveType(primitiveType);
    }

    private static final ClassifierResolutionContext.Result parseTypeVariableRefSignature$lambda$0(ClassifierResolutionContext $context, String $parameterName) {
        return $context.resolveTypeParameter$frontend_common_jvm($parameterName);
    }

    private static final ClassifierResolutionContext.Result parseParameterizedClassRefSignature$lambda$0(ClassifierResolutionContext $context, String $internalName) {
        return $context.resolveByInternalName$frontend_common_jvm($internalName);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$ClsFormatException;", "", "message", "", "cause", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "frontend.common.jvm"})
    public static final class ClsFormatException
    extends Throwable {
        public ClsFormatException(@Nullable String message2, @Nullable Throwable cause) {
            super(message2, cause);
        }

        public /* synthetic */ ClsFormatException(String string, Throwable throwable, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                throwable = null;
            }
            this(string, throwable);
        }

        public ClsFormatException() {
            this(null, null, 3, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/load/java/structure/impl/classFiles/BinaryClassSignatureParser$JavaSignatureVariance;", "", "<init>", "(Ljava/lang/String;I)V", "PLUS", "MINUS", "STAR", "NO_VARIANCE", "frontend.common.jvm"})
    private static final class JavaSignatureVariance
    extends Enum<JavaSignatureVariance> {
        public static final /* enum */ JavaSignatureVariance PLUS = new JavaSignatureVariance();
        public static final /* enum */ JavaSignatureVariance MINUS = new JavaSignatureVariance();
        public static final /* enum */ JavaSignatureVariance STAR = new JavaSignatureVariance();
        public static final /* enum */ JavaSignatureVariance NO_VARIANCE = new JavaSignatureVariance();
        private static final /* synthetic */ JavaSignatureVariance[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static JavaSignatureVariance[] values() {
            return (JavaSignatureVariance[])$VALUES.clone();
        }

        public static JavaSignatureVariance valueOf(String value2) {
            return Enum.valueOf(JavaSignatureVariance.class, value2);
        }

        @NotNull
        public static EnumEntries<JavaSignatureVariance> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = javaSignatureVarianceArray = new JavaSignatureVariance[]{JavaSignatureVariance.PLUS, JavaSignatureVariance.MINUS, JavaSignatureVariance.STAR, JavaSignatureVariance.NO_VARIANCE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

