/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtStubBasedElementTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPlaceHolderStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtTokenSets;
import shadow.org.jetbrains.kotlin.psi.KtPsiFactory;
import shadow.org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

public class KtPackageDirective
extends KtModifierListOwnerStub<KotlinPlaceHolderStub<KtPackageDirective>> {
    private String qualifiedNameCache;

    public KtPackageDirective(@NotNull ASTNode node) {
        if (node == null) {
            KtPackageDirective.$$$reportNull$$$0(0);
        }
        super(node);
        this.qualifiedNameCache = null;
    }

    public KtPackageDirective(@NotNull KotlinPlaceHolderStub<KtPackageDirective> stub) {
        if (stub == null) {
            KtPackageDirective.$$$reportNull$$$0(1);
        }
        super(stub, KtStubBasedElementTypes.PACKAGE_DIRECTIVE);
        this.qualifiedNameCache = null;
    }

    @Nullable
    public KtExpression getPackageNameExpression() {
        return KtStubbedPsiUtil.getStubOrPsiChild(this, KtTokenSets.INSIDE_DIRECTIVE_EXPRESSIONS, KtExpression.ARRAY_FACTORY);
    }

    @NotNull
    public List<KtSimpleNameExpression> getPackageNames() {
        KtExpression nameExpression = this.getPackageNameExpression();
        if (nameExpression == null) {
            List<KtSimpleNameExpression> list = Collections.emptyList();
            if (list == null) {
                KtPackageDirective.$$$reportNull$$$0(2);
            }
            return list;
        }
        ArrayList<KtSimpleNameExpression> packageNames = new ArrayList<KtSimpleNameExpression>();
        while (nameExpression instanceof KtQualifiedExpression) {
            KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)nameExpression;
            KtExpression selector = qualifiedExpression.getSelectorExpression();
            if (selector instanceof KtSimpleNameExpression) {
                packageNames.add((KtSimpleNameExpression)selector);
            }
            nameExpression = qualifiedExpression.getReceiverExpression();
        }
        if (nameExpression instanceof KtSimpleNameExpression) {
            packageNames.add((KtSimpleNameExpression)nameExpression);
        }
        Collections.reverse(packageNames);
        ArrayList<KtSimpleNameExpression> arrayList = packageNames;
        if (arrayList == null) {
            KtPackageDirective.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Nullable
    public KtSimpleNameExpression getLastReferenceExpression() {
        KtExpression nameExpression = this.getPackageNameExpression();
        if (nameExpression == null) {
            return null;
        }
        return (KtSimpleNameExpression)KtPsiUtilKt.getQualifiedElementSelector(nameExpression);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        KtSimpleNameExpression lastPart = this.getLastReferenceExpression();
        return lastPart != null ? lastPart.getIdentifier() : null;
    }

    @Override
    @NotNull
    public String getName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        String string = nameIdentifier == null ? "" : nameIdentifier.getText();
        if (string == null) {
            KtPackageDirective.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Name getNameAsName() {
        PsiElement nameIdentifier = this.getNameIdentifier();
        Name name2 = nameIdentifier == null ? SpecialNames.ROOT_PACKAGE : Name.identifier(nameIdentifier.getText());
        if (name2 == null) {
            KtPackageDirective.$$$reportNull$$$0(5);
        }
        return name2;
    }

    public boolean isRoot() {
        return this.getName().length() == 0;
    }

    @NotNull
    public FqName getFqName() {
        String qualifiedName2 = this.getQualifiedName();
        return qualifiedName2.isEmpty() ? FqName.ROOT : new FqName(qualifiedName2);
    }

    @NotNull
    public FqName getFqName(KtSimpleNameExpression nameExpression) {
        return new FqName(this.getQualifiedNameOf(nameExpression));
    }

    public void setFqName(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            KtPackageDirective.$$$reportNull$$$0(6);
        }
        if (fqName2.isRoot()) {
            if (!this.getFqName().isRoot()) {
                this.replace(new KtPsiFactory(this.getProject()).createFile("").getPackageDirective());
            }
            return;
        }
        KtPsiFactory psiFactory = new KtPsiFactory(this.getProject());
        KtExpression newExpression = psiFactory.createExpression(fqName2.asString());
        KtExpression currentExpression = this.getPackageNameExpression();
        if (currentExpression != null) {
            currentExpression.replace(newExpression);
            return;
        }
        PsiElement keyword = this.getPackageKeyword();
        if (keyword != null) {
            this.addAfter(newExpression, keyword);
            this.addAfter(psiFactory.createWhiteSpace(), keyword);
            return;
        }
        this.replace(psiFactory.createPackageDirective(fqName2));
    }

    @NotNull
    public String getQualifiedName() {
        if (this.qualifiedNameCache == null) {
            this.qualifiedNameCache = this.getQualifiedNameOf(null);
        }
        String string = this.qualifiedNameCache;
        if (string == null) {
            KtPackageDirective.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private String getQualifiedNameOf(@Nullable KtSimpleNameExpression nameExpression) {
        StringBuilder builder = new StringBuilder();
        for (KtSimpleNameExpression e2 : this.getPackageNames()) {
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(e2.getReferencedName());
            if (e2 != nameExpression) continue;
            break;
        }
        String string = builder.toString();
        if (string == null) {
            KtPackageDirective.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public PsiElement getPackageKeyword() {
        return this.findChildByType(KtTokens.PACKAGE_KEYWORD);
    }

    @Override
    public void subtreeChanged() {
        this.qualifiedNameCache = null;
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            KtPackageDirective.$$$reportNull$$$0(9);
        }
        return visitor2.visitPackageDirective(this, data2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtPackageDirective";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtPackageDirective";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageNames";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameAsName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNameOf";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFqName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

