/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.SuspendFunctionAsSupertypeChecker$check$;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/SuspendFunctionAsSupertypeChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
@SourceDebugExtension(value={"SMAP\nSuspendFunctionAsSupertypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspendFunctionAsSupertypeChecker.kt\norg/jetbrains/kotlin/resolve/checkers/SuspendFunctionAsSupertypeChecker\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n477#2:42\n2746#3,3:43\n1761#3,3:46\n*S KotlinDebug\n*F\n+ 1 SuspendFunctionAsSupertypeChecker.kt\norg/jetbrains/kotlin/resolve/checkers/SuspendFunctionAsSupertypeChecker\n*L\n22#1:42\n24#1:43,3\n30#1:46,3\n*E\n"})
public final class SuspendFunctionAsSupertypeChecker
implements DeclarationChecker {
    @NotNull
    public static final SuspendFunctionAsSupertypeChecker INSTANCE = new SuspendFunctionAsSupertypeChecker();

    private SuspendFunctionAsSupertypeChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        boolean bl;
        block11: {
            FunctionClassDescriptor it;
            boolean bl2;
            List<ClassifierDescriptor> functionalSupertypes;
            block10: {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                Intrinsics.checkNotNullParameter(context2, "context");
                if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.SuspendFunctionAsSupertype)) {
                    return;
                }
                if (!(descriptor2 instanceof ClassDescriptor)) {
                    return;
                }
                Sequence<ClassifierDescriptor> $this$filterIsInstance$iv = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)descriptor2);
                boolean $i$f$filterIsInstance = false;
                Sequence<ClassifierDescriptor> sequence2 = SequencesKt.filter($this$filterIsInstance$iv, check$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                functionalSupertypes = SequencesKt.toList(sequence2);
                Iterable $this$none$iv = functionalSupertypes;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        it = (FunctionClassDescriptor)element$iv;
                        boolean bl3 = false;
                        if (!(Intrinsics.areEqual(it.getFunctionTypeKind(), FunctionTypeKind.SuspendFunction.INSTANCE) || Intrinsics.areEqual(it.getFunctionTypeKind(), FunctionTypeKind.KSuspendFunction.INSTANCE))) continue;
                        bl2 = false;
                        break block10;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return;
            }
            Iterable $this$any$iv = functionalSupertypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (FunctionClassDescriptor)element$iv;
                    boolean bl4 = false;
                    if (!(Intrinsics.areEqual(it.getFunctionTypeKind(), FunctionTypeKind.Function.INSTANCE) || Intrinsics.areEqual(it.getFunctionTypeKind(), FunctionTypeKind.KFunction.INSTANCE))) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            KtElementImplStub ktElementImplStub = declaration instanceof KtClassOrObject ? (KtClassOrObject)declaration : null;
            KtElement reportOn = ktElementImplStub != null && (ktElementImplStub = ktElementImplStub.getSuperTypeList()) != null ? (KtElement)ktElementImplStub : (KtElement)declaration;
            context2.getTrace().report(Errors.MIXING_SUSPEND_AND_NON_SUSPEND_SUPERTYPES.on(reportOn));
        }
    }
}

