const { ipcRenderer } = require('electron');

const search = decodeURI(window.location.search).substring(1).split('&');
const param = {};
for (let item of search) {
    const arr = item.split('=');
    param[arr[0]] = arr[1];
}
lang = navigator.userAgent.indexOf('EasyEDAPro') > 0 ? 'en' : 'zh';
const translateText = translate[lang];
const templateMsg = `
    <ul>
        <li>${lang === 'en' ? translateText('EasyEDATitle') : translateText('title')}</li>
        <li><span class="left-span">${translateText('version')}：</span><span class="version">V${param.version}</span></li>
        <li><span>${translateText('time')}：</span><span class="decode-time">${param.time.replace(
    /(\d*)[\\|\/](\d*)[\\|\/](\d*)/,
    '$3-$1-$2'
)}</span></li>
    </ul>`;
const template = `
    <div class="content-tips" style="">${translateText('tips')}</div>
        <div id='loadingMessage'>正在加载初始化工具...</div>
        <ul>
            <li>${translateText('activated')}</li>
            ${
                param.username
                    ? `<li><span class="left-span">${translateText('username')}：</span><span class="username">${
                          param.username
                      }</span></li>`
                    : ''
            }
            ${
                param.customer_code
                    ? `<li><span class="left-span">${translateText(
                          'customerCode'
                      )}：</span><span class="number">${param.customer_code.replace(/(\w{2,2})(\w{3,3})(\w*)/, '$1***$3')}</span></li>`
                    : ''
            }
            ${
                param.phone
                    ? `<li><span class="left-span">${translateText('phone')}：</span><span class="tel">${param.phone.replace(
                          /(\w{3,3})(\w{4,4})(\w*)/,
                          '$1****$3'
                      )}</span></li>`
                    : ''
            }
            ${
                param.email
                    ? `<li><span class="left-span">${translateText('email')}：</span><span class="email">${param.email.replace(
                          /(\w*?)(\w{4,4})(@\w*)/,
                          '$1****$3'
                      )}</span></li>`
                    : ''
            }
            ${
                param.company
                    ? `<li><span class="left-span">${translateText('company')}：</span><span class="company">${param.company.replace(
                          /([\u4e00-\u9fa5|\w]{2,2})([\u4e00-\u9fa5|\w]{4,4})([\u4e00-\u9fa5|\w]*)/,
                          '$1****$3'
                      )}</span></li>`
                    : ''
            }
        </ul>`;
const notActivatedTemplate = `<ul><li>${translateText('notActivated')}</li></ul>`;
// LOGO部分
const conentTitle = document.getElementsByClassName('content-title')[0];
lang === 'en' ? conentTitle.classList.add('en') : conentTitle.classList.remove('en');
document.getElementsByClassName('content-top')[0].innerHTML = templateMsg;
document.getElementsByClassName('content-bottom')[0].innerHTML = param.activated === 'not' ? notActivatedTemplate : template;
const loading = document.getElementById('loadingMessage');
const setMessage = (msg) => {
    console.log(msg);
    loading.innerHTML = msg === 'Complete' ? `${translateText(msg)}...` : `${translateText('loading')} ${translateText(msg)}...`;
};
ipcRenderer.on('loadingMessage', function (e, arg) {
    const messages = arg.message.split(',');
    let timer = setTimeout(() => {
        let item = messages.shift();
        if (item) {
            const arr = item.split(/\\|\//);
            setMessage(arr[arr.length - 1]);
            timer = callbackTimeout(timer, messages);
        } else {
            clearTimeout(timer);
        }
    }, 30);
});
function callbackTimeout(timer, messages) {
    return setTimeout(() => {
        let item = messages.shift();
        if (item) {
            const arr = item.split(/\\|\//);
            setMessage(arr[arr.length - 1]);
            timer = callbackTimeout(timer, messages);
        } else {
            clearTimeout(timer);
        }
    }, 30);
}
