#ifndef APPSTATSEVENTS_H
#define APPSTATSEVENTS_H

#include <QMap>
#include <QObject>

class AppStatsEvents
{
    Q_GADGET

public:

    // Event IDs sent to servers for statistics purpose.
    enum class EventType
    {
        NONE,
        FIRST_START,
        FIRST_SYNC,
        FIRST_SYNCED_FILE,
        FIRST_WEBCLIENT_DL,
        UNINSTALL,
        ACC_CREATION_START,
        PRO_REDIRECT,
        MEM_USAGE,
        UPDATE,
        UPDATE_OK,
        OVER_STORAGE_DIAL,
        OVER_STORAGE_NOTIF,
        OVER_STORAGE_MSG,
        ALMOST_OVER_STORAGE_MSG,
        ALMOST_OVER_STORAGE_NOTIF,
        MAIN_DIAL_WHILE_OVER_QUOTA,
        MAIN_DIAL_WHILE_ALMOST_OVER_QUOTA,
        RED_LIGHT_USED_STORAGE_MISMATCH,
        TRSF_OVER_QUOTA_DIAL,
        TRSF_OVER_QUOTA_NOTIF,
        TRSF_OVER_QUOTA_MSG,
        TRSF_ALMOST_OVER_QUOTA_MSG,
        PAYWALL_NOTIF,
        SYNC_ADD_FAIL_API_EACCESS,
        TRSF_ALMOST_OVERQUOTA_NOTIF,
        FIRST_BACKUP,
        FIRST_BACKED_UP_FILE,
        SI_NAMECONFLICT_SOLVED_MANUALLY,
        SI_NAMECONFLICT_SOLVED_AUTOMATICALLY,
        SI_NAMECONFLICT_SOLVED_SEMI_AUTOMATICALLY,
        SI_LOCALREMOTE_SOLVED_MANUALLY,
        SI_LOCALREMOTE_SOLVED_AUTOMATICALLY,
        SI_LOCALREMOTE_SOLVED_SEMI_AUTOMATICALLY,
        SI_IGNORE_SOLVED_MANUALLY,
        SI_STALLED_ISSUE_RECEIVED,
        SI_IGNORE_ALL_SYMLINK,
        SI_SMART_MODE_FIRST_SELECTED,
        SI_ADVANCED_MODE_FIRST_SELECTED,
        SI_CHANGE_TO_SMART_MODE,
        SI_CHANGE_TO_ADVANCED_MODE,
        SI_FINGERPRINT_MISSING_SOLVED_MANUALLY,
        SI_MOVERENAME_CANNOT_OCCUR_SOLVED_MANUALLY,
        SI_UNKNOWN_DOWNLOAD_ISSUE_SOLVED_BY_FEEDBACK,
        DAILY_ACTIVE_USER,
        MONTHLY_ACTIVE_USER,
        LOGIN_CLICKED,
        LOGOUT_CLICKED,
        TRANSFER_TAB_CLICKED,
        NOTIFICATION_TAB_CLICKED,
        NOTIFICATION_SETTINGS_CLICKED,
        UPGRADE_ACCOUNT_CLICKED,
        OPEN_TRANSFER_MANAGER_CLICKED,
        ADD_SYNC_CLICKED,
        ADD_BACKUP_CLICKED,
        UPLOAD_CLICKED,
        AVATAR_CLICKED,
        MENU_CLICKED,
        MENU_ABOUT_CLICKED,
        MENU_CLOUD_DRIVE_CLICKED,
        MENU_ADD_SYNC_CLICKED,
        MENU_ADD_BACKUP_CLICKED,
        MENU_OPEN_LINKS_CLICKED,
        MENU_UPLOAD_CLICKED,
        MENU_DOWNLOAD_CLICKED,
        MENU_STREAM_CLICKED,
        MENU_SETTINGS_CLICKED,
        MENU_EXIT_CLICKED,
        SETTINGS_GENERAL_TAB_CLICKED,
        SETTINGS_ACCOUNT_TAB_CLICKED,
        SETTINGS_SYNC_TAB_CLICKED,
        SETTINGS_BACKUP_TAB_CLICKED,
        SETTINGS_SECURITY_TAB_CLICKED,
        SETTINGS_FOLDERS_TAB_CLICKED,
        SETTINGS_NETWORK_TAB_CLICKED,
        SETTINGS_NOTIFICATIONS_TAB_CLICKED,
        SETTINGS_EXPORT_KEY_CLICKED,
        SETTINGS_CHANGE_PASSWORD_CLICKED,
        SETTINGS_REPORT_ISSUE_CLICKED,
        NOTIFICATION_DISPLAYED,
        NOTIFICATION_CTA_CLICKED,
        ONBOARDING_CLOSED_WITHOUT_SETTING_SYNCS,
        FIRST_SYNC_FROM_ONBOARDING,
        FIRST_BACKUP_FROM_ONBOARDING,
        MENU_DEVICE_CENTRE_CLICKED,
        DEVICE_CENTRE_RENAME_ICON_CLICKED,
        RENAME_DIALOG_RENAME_BUTTON_CLICKED,
        RENAME_DIALOG_CANCEL_BUTTON_CLICKED,
        DEVICE_CENTRE_ADD_BACKUP_BUTTON_CLICKED,
        DEVICE_CENTRE_ADD_SYNC_BUTTON_CLICKED,
        DEVICE_CENTRE_CONTEXT_MENU_TRIGGERED,
        DEVICE_CENTRE_PAUSE_ACTION_TIGGERED,
        DEVICE_CENTRE_RESUME_ACTION_TRIGGERED,
        DEVICE_CENTRE_STOP_BACKUP_ACTION_TRIGGERED,
        TRAY_ICON_TRIGGERED,
        DELETE_REMOVED_BAKCUP_CLICKED,
        MOVE_REMOVED_BACKUP_FOLDER,
        CONFIRM_REMOVE_BACKUP,
        DEVICE_CENTRE_SYNC_ROW_DOUBLE_CLICKED,
        UPSELL_DIALOG_STORAGE_FULL_SHOWN,
        UPSELL_DIALOG_STORAGE_ALMOST_FULL_SHOWN,
        UPSELL_DIALOG_TX_QUOTA_EXCEEDED_SHOWN,
        UPSELL_DIALOG_LEARN_MORE_TX_QUOTA_CLICKED,
        UPSELL_DIALOG_EMPTY_RUBBISH_BIN_CLICKED,
        UPSELL_DIALOG_TRY_PRO_FLEXI_CLICKED,
        UPSELL_DIALOG_BILLED_MONTHLY_CLICKED,
        UPSELL_DIALOG_BILLED_YEARLY_CLICKED,
        UPSELL_DIALOG_PLAN_BUTTON_CLICKED,
        INFO_DIALOG_ADD_SYNC_CLICKED,
        SYNC_ADDED_ADD_SYNC_BUTTON,
        FIRST_SYNC_NOTIFICATION_SHOWN,
        SECOND_SYNC_NOTIFICATION_SHOWN,
        MONTHLY_SYNC_NOTIFICATION_SHOWN,
        BIMONTHLY_SYNC_NOTIFICATION_SHOWN,
        SYNC_CREATED_AFTER_CLICKING_NOTIFICATION,
        SYNC_CREATED_AFTER_NOTIFICATION,
        SYNC_ADDED_CLOUD_DRIVE_BUTTON,
        CLOUD_DRIVE_OPENED,
        UPSELL_DIALOG_AFTER_ANY_PLAN_CLOSE_BUTTON_CLICKED,
        UPSELL_DIALOG_WITHOUT_ANY_PLAN_CLOSE_BUTTON_CLICKED,
        SYNC_ADDED_SETTINGS,
        SYNC_ADDED_WEBCLIENT,
        SYNC_ADDED_CONTEXT_MENU,
        SYNC_ADDED_ONBOARDING,
        SYNC_ADDED_OS_NOTIFICATION,
        SYNC_ADDED_MAIN_APP,
        CLOUD_DRIVE_HOURLY_ACTIVE_USERS,
        USER_ABORTS_ONBOARDING_SYNC_CREATION,
        MULTIPLE_SYNCS_CREATED_ON_ONBOARDING,
    };
    Q_ENUM(EventType)

    static QString getEventMessage(EventType event,
                                   const QStringList& args = QStringList());
    static int getEventType(EventType event);
    static EventType getEventType(int event);

private:
    static QMap<EventType, int> mTypeMap;
    static QMap<EventType, const char*> mMessageMap;

};

#endif // APPSTATSEVENTS_H
