#ifndef TransferScanCancelUi_H
#define TransferScanCancelUi_H

#include "CancelConfirmWidget.h"
#include "ScanningWidget.h"

#include <QStackedWidget>

class TransferScanCancelUi : public QObject
{
    Q_OBJECT

public:
    TransferScanCancelUi(QStackedWidget* _container,
                         QWidget* _finishedWidget);
    ~TransferScanCancelUi() = default;

    void show();
    void hide(bool fromCancellation);
    void disableCancelling();
    void setInCancellingStage();
    bool isActive();
    void onFolderTransferUpdate(const FolderTransferUpdateEvent& event);

signals:
    void cancelTransfers();
    void visibilityChanged(bool);

private slots:
    void onCancelClicked();
    void onCancelDismissed();

private:
    QStackedWidget *mContainer = nullptr;
    ScanningWidget* mBlockingWidget = nullptr;
    CancelConfirmWidget* mConfirmWidget = nullptr;
    QWidget* mLastSelectedWidget = nullptr;
    QWidget* mFinishedWidget;
};

#endif // BLOCKINGUI_H
