//! # DBus interface proxy for: `org.freedesktop.UDisks2.NVMe.Namespace`
//!
//! This code was generated by `zbus-xmlgen` `4.0.0` from DBus introspection data.
//! Source: `org.freedesktop.UDisks2.xml`.
//!
//! You may prefer to adapt it, instead of using it verbatim.
//!
//! More information can be found in the
//! [Writing a client proxy](https://dbus2.github.io/zbus/client.html)
//! section of the zbus documentation.
//!

use zbus::proxy;

use crate::error;

#[proxy(
    interface = "org.freedesktop.UDisks2.NVMe.Namespace",
    default_service = "org.freedesktop.UDisks2",
    default_path = "/org/freedesktop/UDisks2/NVMe"
)]
pub trait Namespace {
    /// FormatNamespace method
    fn format_namespace(
        &self,
        options: std::collections::HashMap<&str, zbus::zvariant::Value<'_>>,
    ) -> error::Result<()>;

    /// EUI64 property
    #[zbus(property, name = "EUI64")]
    fn eui64(&self) -> error::Result<String>;

    /// FormatPercentRemaining property
    #[zbus(property)]
    fn format_percent_remaining(&self) -> error::Result<i32>;

    /// FormattedLBASize property
    #[zbus(property, name = "FormattedLBASize")]
    fn formatted_lbasize(&self) -> error::Result<(u16, u16, u8)>;

    /// LBAFormats property
    #[zbus(property, name = "LBAFormats")]
    fn lbaformats(&self) -> error::Result<Vec<(u16, u16, u8)>>;

    /// NGUID property
    #[zbus(property, name = "NGUID")]
    fn nguid(&self) -> error::Result<String>;

    /// NSID property
    #[zbus(property, name = "NSID")]
    fn nsid(&self) -> error::Result<u32>;

    /// NamespaceCapacity property
    #[zbus(property)]
    fn namespace_capacity(&self) -> error::Result<u64>;

    /// NamespaceSize property
    #[zbus(property)]
    fn namespace_size(&self) -> error::Result<u64>;

    /// NamespaceUtilization property
    #[zbus(property)]
    fn namespace_utilization(&self) -> error::Result<u64>;

    /// UUID property
    #[zbus(property, name = "UUID")]
    fn uuid(&self) -> error::Result<String>;

    /// WWN property
    #[zbus(property, name = "WWN")]
    fn wwn(&self) -> error::Result<String>;
}
