/* Generated by wayland-scanner 1.24.0 */

#ifndef EXT_SCREENCOPY_V1_CLIENT_PROTOCOL_H
#define EXT_SCREENCOPY_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_ext_screencopy_v1 The ext_screencopy_v1 protocol
 * screen content capturing on client buffers
 *
 * @section page_desc_ext_screencopy_v1 Description
 *
 * This protocol allows clients to ask the compositor to copy part of the
 * screen content to a client buffer.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 *
 * @section page_ifaces_ext_screencopy_v1 Interfaces
 * - @subpage page_iface_ext_screencopy_manager_v1 - manager to inform clients and begin capturing
 * - @subpage page_iface_ext_screencopy_session_v1 - capturing session
 * @section page_copyright_ext_screencopy_v1 Copyright
 * <pre>
 *
 * Copyright © 2021-2022 Andri Yngvason
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct ext_screencopy_manager_v1;
struct ext_screencopy_session_v1;
struct wl_buffer;
struct wl_output;
struct wl_seat;

#ifndef EXT_SCREENCOPY_MANAGER_V1_INTERFACE
#define EXT_SCREENCOPY_MANAGER_V1_INTERFACE
/**
 * @page page_iface_ext_screencopy_manager_v1 ext_screencopy_manager_v1
 * @section page_iface_ext_screencopy_manager_v1_desc Description
 *
 * This object is a manager which offers requests to start capturing from a
 * source.
 * @section page_iface_ext_screencopy_manager_v1_api API
 * See @ref iface_ext_screencopy_manager_v1.
 */
/**
 * @defgroup iface_ext_screencopy_manager_v1 The ext_screencopy_manager_v1 interface
 *
 * This object is a manager which offers requests to start capturing from a
 * source.
 */
extern const struct wl_interface ext_screencopy_manager_v1_interface;
#endif
#ifndef EXT_SCREENCOPY_SESSION_V1_INTERFACE
#define EXT_SCREENCOPY_SESSION_V1_INTERFACE
/**
 * @page page_iface_ext_screencopy_session_v1 ext_screencopy_session_v1
 * @section page_iface_ext_screencopy_session_v1_desc Description
 *
 * This is the frame capturing interface. It keeps track of changes between
 * frames.
 *
 * After a screencopy session is created, buffer_info events will be emitted
 * from the compositor to tell the client which buffer types and formats are
 * supported for reading from the session.
 *
 * When the client knows all the buffer attributes, it can create a buffer,
 * attach it to the screencopy session using the "attach_buffer" request,
 * set the buffer damage using the "damage_buffer" request and then call
 * the "commit" request.
 *
 * After "commit" has been called, the next time that a buffer is committed
 * by the compositor, the contents of that buffer will be copied to the one
 * committed to the screencopy session. A series of events will be generated,
 * ending with the "ready" event, which means that the buffer is ready to be
 * used and a buffer may be committed to the session again.
 *
 * The "failed" event may be sent at any time. When this happens, the client
 * must destroy the session. Depending on the failure reason, the client can
 * create a new session to replace it.
 * @section page_iface_ext_screencopy_session_v1_api API
 * See @ref iface_ext_screencopy_session_v1.
 */
/**
 * @defgroup iface_ext_screencopy_session_v1 The ext_screencopy_session_v1 interface
 *
 * This is the frame capturing interface. It keeps track of changes between
 * frames.
 *
 * After a screencopy session is created, buffer_info events will be emitted
 * from the compositor to tell the client which buffer types and formats are
 * supported for reading from the session.
 *
 * When the client knows all the buffer attributes, it can create a buffer,
 * attach it to the screencopy session using the "attach_buffer" request,
 * set the buffer damage using the "damage_buffer" request and then call
 * the "commit" request.
 *
 * After "commit" has been called, the next time that a buffer is committed
 * by the compositor, the contents of that buffer will be copied to the one
 * committed to the screencopy session. A series of events will be generated,
 * ending with the "ready" event, which means that the buffer is ready to be
 * used and a buffer may be committed to the session again.
 *
 * The "failed" event may be sent at any time. When this happens, the client
 * must destroy the session. Depending on the failure reason, the client can
 * create a new session to replace it.
 */
extern const struct wl_interface ext_screencopy_session_v1_interface;
#endif

#ifndef EXT_SCREENCOPY_MANAGER_V1_OPTIONS_ENUM
#define EXT_SCREENCOPY_MANAGER_V1_OPTIONS_ENUM
enum ext_screencopy_manager_v1_options {
	EXT_SCREENCOPY_MANAGER_V1_OPTIONS_RENDER_CURSORS = 1,
};
#endif /* EXT_SCREENCOPY_MANAGER_V1_OPTIONS_ENUM */

#define EXT_SCREENCOPY_MANAGER_V1_CAPTURE_OUTPUT 0


/**
 * @ingroup iface_ext_screencopy_manager_v1
 */
#define EXT_SCREENCOPY_MANAGER_V1_CAPTURE_OUTPUT_SINCE_VERSION 1

/** @ingroup iface_ext_screencopy_manager_v1 */
static inline void
ext_screencopy_manager_v1_set_user_data(struct ext_screencopy_manager_v1 *ext_screencopy_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ext_screencopy_manager_v1, user_data);
}

/** @ingroup iface_ext_screencopy_manager_v1 */
static inline void *
ext_screencopy_manager_v1_get_user_data(struct ext_screencopy_manager_v1 *ext_screencopy_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ext_screencopy_manager_v1);
}

static inline uint32_t
ext_screencopy_manager_v1_get_version(struct ext_screencopy_manager_v1 *ext_screencopy_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ext_screencopy_manager_v1);
}

/** @ingroup iface_ext_screencopy_manager_v1 */
static inline void
ext_screencopy_manager_v1_destroy(struct ext_screencopy_manager_v1 *ext_screencopy_manager_v1)
{
	wl_proxy_destroy((struct wl_proxy *) ext_screencopy_manager_v1);
}

/**
 * @ingroup iface_ext_screencopy_manager_v1
 *
 * Create a capturing session for an output
 *
 * If the "render_cursors" flag is set, cursors shall be composited onto
 * the captured frame. The cursor should not be composited onto the frame
 * if this flag is not set.
 */
static inline struct ext_screencopy_session_v1 *
ext_screencopy_manager_v1_capture_output(struct ext_screencopy_manager_v1 *ext_screencopy_manager_v1, struct wl_output *output, uint32_t options)
{
	struct wl_proxy *session;

	session = wl_proxy_marshal_flags((struct wl_proxy *) ext_screencopy_manager_v1,
			 EXT_SCREENCOPY_MANAGER_V1_CAPTURE_OUTPUT, &ext_screencopy_session_v1_interface, wl_proxy_get_version((struct wl_proxy *) ext_screencopy_manager_v1), 0, NULL, output, options);

	return (struct ext_screencopy_session_v1 *) session;
}

#ifndef EXT_SCREENCOPY_SESSION_V1_FAILURE_REASON_ENUM
#define EXT_SCREENCOPY_SESSION_V1_FAILURE_REASON_ENUM
enum ext_screencopy_session_v1_failure_reason {
	EXT_SCREENCOPY_SESSION_V1_FAILURE_REASON_UNSPEC = 0,
	EXT_SCREENCOPY_SESSION_V1_FAILURE_REASON_INVALID_MAIN_BUFFER = 1,
	EXT_SCREENCOPY_SESSION_V1_FAILURE_REASON_INVALID_CURSOR_BUFFER = 2,
	EXT_SCREENCOPY_SESSION_V1_FAILURE_REASON_OUTPUT_MISSING = 3,
	EXT_SCREENCOPY_SESSION_V1_FAILURE_REASON_OUTPUT_DISABLED = 4,
	EXT_SCREENCOPY_SESSION_V1_FAILURE_REASON_UNKNOWN_INPUT = 5,
};
#endif /* EXT_SCREENCOPY_SESSION_V1_FAILURE_REASON_ENUM */

#ifndef EXT_SCREENCOPY_SESSION_V1_OPTIONS_ENUM
#define EXT_SCREENCOPY_SESSION_V1_OPTIONS_ENUM
enum ext_screencopy_session_v1_options {
	EXT_SCREENCOPY_SESSION_V1_OPTIONS_ON_DAMAGE = 1,
};
#endif /* EXT_SCREENCOPY_SESSION_V1_OPTIONS_ENUM */

#ifndef EXT_SCREENCOPY_SESSION_V1_INPUT_TYPE_ENUM
#define EXT_SCREENCOPY_SESSION_V1_INPUT_TYPE_ENUM
enum ext_screencopy_session_v1_input_type {
	EXT_SCREENCOPY_SESSION_V1_INPUT_TYPE_POINTER = 0,
	EXT_SCREENCOPY_SESSION_V1_INPUT_TYPE_TABLET = 1,
};
#endif /* EXT_SCREENCOPY_SESSION_V1_INPUT_TYPE_ENUM */

#ifndef EXT_SCREENCOPY_SESSION_V1_BUFFER_TYPE_ENUM
#define EXT_SCREENCOPY_SESSION_V1_BUFFER_TYPE_ENUM
enum ext_screencopy_session_v1_buffer_type {
	EXT_SCREENCOPY_SESSION_V1_BUFFER_TYPE_WL_SHM = 0,
	EXT_SCREENCOPY_SESSION_V1_BUFFER_TYPE_DMABUF = 1,
};
#endif /* EXT_SCREENCOPY_SESSION_V1_BUFFER_TYPE_ENUM */

/**
 * @ingroup iface_ext_screencopy_session_v1
 * @struct ext_screencopy_session_v1_listener
 */
struct ext_screencopy_session_v1_listener {
	/**
	 * buffer information
	 *
	 * Provides information about buffer parameters that need to be
	 * used for the main image. This event is sent for every supported
	 * buffer type after the session is created.
	 *
	 * The stride parameter is invalid for dmabuf and may be set to 0.
	 * @param type buffer type
	 * @param format buffer drm format
	 * @param width buffer width
	 * @param height buffer height
	 * @param stride buffer stride
	 */
	void (*buffer_info)(void *data,
			    struct ext_screencopy_session_v1 *ext_screencopy_session_v1,
			    uint32_t type,
			    uint32_t format,
			    uint32_t width,
			    uint32_t height,
			    uint32_t stride);
	/**
	 * cursor buffer information
	 *
	 * Provides information about buffer parameters that need to be
	 * used for the cursor image. This event is sent for every
	 * supported buffer type after the session is created, and it may
	 * be different for each seat/input_type pair.
	 *
	 * The default seat will be referred to as "default" within this
	 * protocol, whether it be named so by the compositor or not.
	 *
	 * The stride parameter is invalid for dmabuf and may be set to 0.
	 * @param seat_name seat name
	 * @param input_type input type
	 * @param buffer_type buffer type
	 * @param format buffer drm format
	 * @param width minimum buffer width
	 * @param height minimum buffer height
	 * @param stride minimum buffer stride
	 */
	void (*cursor_buffer_info)(void *data,
				   struct ext_screencopy_session_v1 *ext_screencopy_session_v1,
				   const char *seat_name,
				   uint32_t input_type,
				   uint32_t buffer_type,
				   uint32_t format,
				   uint32_t width,
				   uint32_t height,
				   uint32_t stride);
	/**
	 * session initialisation done
	 *
	 * This event is sent once when all buffer info events have been
	 * sent.
	 */
	void (*init_done)(void *data,
			  struct ext_screencopy_session_v1 *ext_screencopy_session_v1);
	/**
	 * carries the output transform
	 *
	 * This event is sent before the ready event and holds the output
	 * transform of the source buffer.
	 *
	 * Note: This only applies to the main buffer, not the cursor
	 * buffer. The cursor buffer must always be sent without any
	 * rotation.
	 */
	void (*transform)(void *data,
			  struct ext_screencopy_session_v1 *ext_screencopy_session_v1,
			  int32_t transform);
	/**
	 * carries the coordinates of the damaged region
	 *
	 * This event is sent before the ready event. It may be generated
	 * multiple times for each commit.
	 *
	 * The arguments describe a box around an area that has changed
	 * since the last ready event.
	 *
	 * These coordinates originate in the upper left corner of the
	 * buffer.
	 * @param x damaged x coordinates
	 * @param y damaged y coordinates
	 * @param width current width
	 * @param height current height
	 */
	void (*damage)(void *data,
		       struct ext_screencopy_session_v1 *ext_screencopy_session_v1,
		       uint32_t x,
		       uint32_t y,
		       uint32_t width,
		       uint32_t height);
	/**
	 * cursor entered captured are
	 *
	 * Sent when a cursor enters the captured area. It shall be
	 * generated before the "cursor_info" event when and only when a
	 * cursor enters the area.
	 * @param seat_name seat name
	 * @param input_type input type
	 */
	void (*cursor_enter)(void *data,
			     struct ext_screencopy_session_v1 *ext_screencopy_session_v1,
			     const char *seat_name,
			     uint32_t input_type);
	/**
	 * cursor left area
	 *
	 * Sent when a cursor leaves the captured area. No "cursor_info"
	 * event is generated for for the given cursor.
	 * @param seat_name seat name
	 * @param input_type input type
	 */
	void (*cursor_leave)(void *data,
			     struct ext_screencopy_session_v1 *ext_screencopy_session_v1,
			     const char *seat_name,
			     uint32_t input_type);
	/**
	 * cursor specific information
	 *
	 * This event is generated for each cursor buffer that was
	 * attached to the session and for which the cursor is currently
	 * focused on the session area. It is generated once for each
	 * cursor buffer before the ready event.
	 *
	 * Cursors outside the session area do not get captured and no
	 * event will be generated for them.
	 *
	 * If the cursor image has changed, the cursor buffer will have
	 * been updated and the "has_damage" argument will be set to 1;
	 * otherwise 0.
	 *
	 * The given position is the position of the cursor's hotspot and
	 * it is relative to the main buffer's top left corner in
	 * transformed buffer pixel coordinates.
	 *
	 * The hotspot coordinates are relative to the cursor buffers upper
	 * left corner.
	 * @param seat_name seat name
	 * @param has_damage buffer has changes
	 * @param position_x position x coordinates
	 * @param position_y position y coordinates
	 * @param width width of the cursor image
	 * @param height height of the cursor image
	 * @param hotspot_x hotspot x coordinates
	 * @param hotspot_y hotspot y coordinates
	 */
	void (*cursor_info)(void *data,
			    struct ext_screencopy_session_v1 *ext_screencopy_session_v1,
			    const char *seat_name,
			    uint32_t input_type,
			    int32_t has_damage,
			    int32_t position_x,
			    int32_t position_y,
			    int32_t width,
			    int32_t height,
			    int32_t hotspot_x,
			    int32_t hotspot_y);
	/**
	 * commit failed
	 *
	 * This event indicates that the attempted frame copy has failed.
	 *
	 * After receiving this event, the client must destroy the object.
	 */
	void (*failed)(void *data,
		       struct ext_screencopy_session_v1 *ext_screencopy_session_v1,
		       uint32_t reason);
	/**
	 * indicates the presentation time of the frame
	 *
	 * This event indicates the time at which the frame is presented
	 * to the output in system monotonic time.
	 *
	 * The timestamp is expressed as tv_sec_hi, tv_sec_lo, tv_nsec
	 * triples, each component being an unsigned 32-bit value. Whole
	 * seconds are in tv_sec which is a 64-bit value combined from
	 * tv_sec_hi and tv_sec_lo, and the additional fractional part in
	 * tv_nsec as nanoseconds. Hence, for valid timestamps tv_nsec must
	 * be in [0, 999999999].
	 * @param tv_sec_hi high 32 bits of the seconds part of the timestamp
	 * @param tv_sec_lo low 32 bits of the seconds part of the timestamp
	 * @param tv_nsec nanoseconds part of the timestamp
	 */
	void (*presentation_time)(void *data,
				  struct ext_screencopy_session_v1 *ext_screencopy_session_v1,
				  uint32_t tv_sec_hi,
				  uint32_t tv_sec_lo,
				  uint32_t tv_nsec);
	/**
	 * indicates frame is available for reading
	 *
	 * Called as soon as the frame is copied, indicating it is
	 * available for reading.
	 */
	void (*ready)(void *data,
		      struct ext_screencopy_session_v1 *ext_screencopy_session_v1);
};

/**
 * @ingroup iface_ext_screencopy_session_v1
 */
static inline int
ext_screencopy_session_v1_add_listener(struct ext_screencopy_session_v1 *ext_screencopy_session_v1,
				       const struct ext_screencopy_session_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ext_screencopy_session_v1,
				     (void (**)(void)) listener, data);
}

#define EXT_SCREENCOPY_SESSION_V1_ATTACH_BUFFER 0
#define EXT_SCREENCOPY_SESSION_V1_DAMAGE_BUFFER 1
#define EXT_SCREENCOPY_SESSION_V1_ATTACH_CURSOR_BUFFER 2
#define EXT_SCREENCOPY_SESSION_V1_DAMAGE_CURSOR_BUFFER 3
#define EXT_SCREENCOPY_SESSION_V1_COMMIT 4
#define EXT_SCREENCOPY_SESSION_V1_DESTROY 5

/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_BUFFER_INFO_SINCE_VERSION 1
/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_CURSOR_BUFFER_INFO_SINCE_VERSION 1
/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_INIT_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_TRANSFORM_SINCE_VERSION 1
/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_DAMAGE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_CURSOR_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_CURSOR_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_CURSOR_INFO_SINCE_VERSION 1
/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_FAILED_SINCE_VERSION 1
/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_PRESENTATION_TIME_SINCE_VERSION 1
/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_READY_SINCE_VERSION 1

/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_ATTACH_BUFFER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_DAMAGE_BUFFER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_ATTACH_CURSOR_BUFFER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_DAMAGE_CURSOR_BUFFER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_ext_screencopy_session_v1
 */
#define EXT_SCREENCOPY_SESSION_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_ext_screencopy_session_v1 */
static inline void
ext_screencopy_session_v1_set_user_data(struct ext_screencopy_session_v1 *ext_screencopy_session_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ext_screencopy_session_v1, user_data);
}

/** @ingroup iface_ext_screencopy_session_v1 */
static inline void *
ext_screencopy_session_v1_get_user_data(struct ext_screencopy_session_v1 *ext_screencopy_session_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ext_screencopy_session_v1);
}

static inline uint32_t
ext_screencopy_session_v1_get_version(struct ext_screencopy_session_v1 *ext_screencopy_session_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ext_screencopy_session_v1);
}

/**
 * @ingroup iface_ext_screencopy_session_v1
 *
 * Attach a buffer to the session.
 */
static inline void
ext_screencopy_session_v1_attach_buffer(struct ext_screencopy_session_v1 *ext_screencopy_session_v1, struct wl_buffer *buffer)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_screencopy_session_v1,
			 EXT_SCREENCOPY_SESSION_V1_ATTACH_BUFFER, NULL, wl_proxy_get_version((struct wl_proxy *) ext_screencopy_session_v1), 0, buffer);
}

/**
 * @ingroup iface_ext_screencopy_session_v1
 *
 * Apply damage to the buffer which is to be committed next.
 *
 * This is for optimisation purposes. The compositor may use this
 * information to reduce copying.
 *
 * The client must submit damage if it's using multiple buffers. Otherwise,
 * the server might not copy into damaged regions of the buffer.
 *
 * These coordinates originate in the upper left corner of the buffer.
 */
static inline void
ext_screencopy_session_v1_damage_buffer(struct ext_screencopy_session_v1 *ext_screencopy_session_v1, uint32_t x, uint32_t y, uint32_t width, uint32_t height)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_screencopy_session_v1,
			 EXT_SCREENCOPY_SESSION_V1_DAMAGE_BUFFER, NULL, wl_proxy_get_version((struct wl_proxy *) ext_screencopy_session_v1), 0, x, y, width, height);
}

/**
 * @ingroup iface_ext_screencopy_session_v1
 *
 * Attach a cursor buffer to the session. The cursor for the given seat and
 * input type will be copied to the buffer.
 *
 * The cursor buffer may exceed the dimensions specified in the
 * "cursor_buffer_info" event. The cursor image will be drawn in the top,
 * left corner of the buffer.
 *
 * If seat is NULL, the default seat is used.
 */
static inline void
ext_screencopy_session_v1_attach_cursor_buffer(struct ext_screencopy_session_v1 *ext_screencopy_session_v1, struct wl_buffer *buffer, struct wl_seat *seat, uint32_t input_type)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_screencopy_session_v1,
			 EXT_SCREENCOPY_SESSION_V1_ATTACH_CURSOR_BUFFER, NULL, wl_proxy_get_version((struct wl_proxy *) ext_screencopy_session_v1), 0, buffer, seat, input_type);
}

/**
 * @ingroup iface_ext_screencopy_session_v1
 *
 * Apply damage to a named cursor buffer which is to be committed next.
 *
 * The whole cursor buffer will be considered damaged.
 *
 * If seat is NULL, the default seat is used.
 */
static inline void
ext_screencopy_session_v1_damage_cursor_buffer(struct ext_screencopy_session_v1 *ext_screencopy_session_v1, struct wl_seat *seat, uint32_t input_type)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_screencopy_session_v1,
			 EXT_SCREENCOPY_SESSION_V1_DAMAGE_CURSOR_BUFFER, NULL, wl_proxy_get_version((struct wl_proxy *) ext_screencopy_session_v1), 0, seat, input_type);
}

/**
 * @ingroup iface_ext_screencopy_session_v1
 *
 * Commit the screencopy session.
 *
 * The frame will be copied to the attached buffer on next output commit. A
 * ready event is generated when the buffer is ready.
 *
 * If the "on_damage" flag is set, the compositor should skip sending new
 * frames to the client until there is damage.
 */
static inline void
ext_screencopy_session_v1_commit(struct ext_screencopy_session_v1 *ext_screencopy_session_v1, uint32_t options)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_screencopy_session_v1,
			 EXT_SCREENCOPY_SESSION_V1_COMMIT, NULL, wl_proxy_get_version((struct wl_proxy *) ext_screencopy_session_v1), 0, options);
}

/**
 * @ingroup iface_ext_screencopy_session_v1
 *
 * Destroys the session. This request can be sent at any time by the
 * client.
 */
static inline void
ext_screencopy_session_v1_destroy(struct ext_screencopy_session_v1 *ext_screencopy_session_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_screencopy_session_v1,
			 EXT_SCREENCOPY_SESSION_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ext_screencopy_session_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
