module type S = sig


type !'a t = 'a Atomic.t

(*
type 'a t = 'a Atomic.t
*)


(*
type 'a t
*)
(** @since 4.12.0: type !'a t
 *)

val make_contended : 'a -> 'a t
(** @since 5.2.0: val make_contended : 'a -> 'a t *)

val make : 'a -> 'a t
(** @since 4.12.0: val make : 'a -> 'a t *)

val get : 'a t -> 'a
(** @since 4.12.0: val get : 'a t -> 'a *)

val set : 'a t -> 'a -> unit
(** @since 4.12.0: val set : 'a t -> 'a -> unit *)

val exchange : 'a t -> 'a -> 'a
(** @since 4.12.0: val exchange : 'a t -> 'a -> 'a *)

val compare_and_set : 'a t -> 'a -> 'a -> bool
(** @since 4.12.0: val compare_and_set : 'a t -> 'a -> 'a -> bool *)

val fetch_and_add : int t -> int -> int
(** @since 4.12.0: val fetch_and_add : int t -> int -> int *)

val incr : int t -> unit
(** @since 4.12.0: val incr : int t -> unit *)

val decr : int t -> unit
(** @since 4.12.0: val decr : int t -> unit *)

end
