module type S = sig


type !'a t = 'a Domain.t

(*
type 'a t = 'a Domain.t
*)


(*
type 'a t
*)
(** @since 5.0.0: type !'a t
 *)


type id = Domain.id

(*

type id = private int

(*
type id = int
*)

*)
(** @since 5.0.0: type id = Domain.id
 *)


module DLS = Domain.DLS

(*
module DLS :
sig type 'a key
val new_key : ?split_from_parent:('a -> 'a) -> (unit -> 'a) -> 'a key
val get : 'a key -> 'a val set : 'a key -> 'a -> unit end
*)
(** @since 5.0.0: module DLS = Domain.DLS
 *)

val spawn : (unit -> 'a) -> 'a t
(** @since 5.0.0: val spawn : (unit -> 'a) -> 'a t *)

val join : 'a t -> 'a
(** @since 5.0.0: val join : 'a t -> 'a *)

val get_id : 'a t -> id
(** @since 5.0.0: val get_id : 'a t -> id *)

val self : unit -> id
(** @since 5.0.0: val self : unit -> id *)

val before_first_spawn : (unit -> unit) -> unit
(** @since 5.0.0: val before_first_spawn : (unit -> unit) -> unit *)

val at_exit : (unit -> unit) -> unit
(** @since 5.0.0: val at_exit : (unit -> unit) -> unit *)

val cpu_relax : unit -> unit
(** @since 5.0.0: val cpu_relax : unit -> unit *)

val is_main_domain : unit -> bool
(** @since 5.0.0: val is_main_domain : unit -> bool *)

val recommended_domain_count : unit -> int
(** @since 5.0.0: val recommended_domain_count : unit -> int *)

val self_index : unit -> int
(** @since 5.3: self_index : unit -> int *)

end
