module type S = sig

type 'a t = unit -> 'a node
and 'a node = 'a Stdcompat__init.seq_node =
  | Nil
  | Cons of 'a * 'a t

(*
type 'a t = unit -> 'a node
and 'a node = 'a Stdcompat__init.seq_node =
  | Nil
  | Cons of 'a * 'a t
*)
(** @since 4.07.0:
    type 'a t = unit -> 'a node
    and 'a node =
      | Nil 
      | Cons of 'a * 'a t 
 *)

exception Forced_twice 
(** Alias for {!Seq.Forced_twice} *)

val find_index : ('a -> bool) -> 'a t -> int option
(** @since 5.1.0: val find_index : ('a -> bool) -> 'a t -> int option *)

val find_mapi : (int -> 'a -> 'b option) -> 'a t -> 'b option
(** @since 5.1.0:
    val find_mapi : (int -> 'a -> 'b option) -> 'a t -> 'b option *)


val fold_lefti : ('acc -> int -> 'a -> 'acc) -> 'acc -> 'a t -> 'acc

(*

val fold_lefti : ('b -> int -> 'a -> 'b) -> 'b -> 'a t -> 'b

(*
val fold_lefti : ('acc -> int -> 'a -> 'acc) -> 'acc -> 'a t -> 'acc
*)

*)
(** @since 5.1.0:
    val fold_lefti : ('acc -> int -> 'a -> 'acc) -> 'acc -> 'a t -> 'acc
@since 5.0.0: val fold_lefti : ('b -> int -> 'a -> 'b) -> 'b -> 'a t -> 'b
 *)

val is_empty : 'a t -> bool
(** @since 4.14.0: val is_empty : 'a t -> bool *)

val uncons : 'a t -> ('a * 'a t) option
(** @since 4.14.0: val uncons : 'a t -> ('a * 'a t) option *)

val length : 'a t -> int
(** @since 4.14.0: val length : 'a t -> int *)

val iteri : (int -> 'a -> unit) -> 'a t -> unit
(** @since 4.14.0: val iteri : (int -> 'a -> unit) -> 'a t -> unit *)

val for_all : ('a -> bool) -> 'a t -> bool
(** @since 4.14.0: val for_all : ('a -> bool) -> 'a t -> bool *)

val exists : ('a -> bool) -> 'a t -> bool
(** @since 4.14.0: val exists : ('a -> bool) -> 'a t -> bool *)

val find : ('a -> bool) -> 'a t -> 'a option
(** @since 4.14.0: val find : ('a -> bool) -> 'a t -> 'a option *)

val find_map : ('a -> 'b option) -> 'a t -> 'b option
(** @since 4.14.0: val find_map : ('a -> 'b option) -> 'a t -> 'b option *)

val iter2 : ('a -> 'b -> unit) -> 'a t -> 'b t -> unit
(** @since 4.14.0: val iter2 : ('a -> 'b -> unit) -> 'a t -> 'b t -> unit *)


val fold_left2 : ('acc -> 'a -> 'b -> 'acc) -> 'acc -> 'a t -> 'b t -> 'acc

(*

val fold_left2 : ('a -> 'b -> 'c -> 'a) -> 'a -> 'b t -> 'c t -> 'a

(*
val fold_left2 : ('acc -> 'a -> 'b -> 'acc) -> 'acc -> 'a t -> 'b t -> 'acc
*)

*)
(** @since 5.1.0:
    val fold_left2 :
      ('acc -> 'a -> 'b -> 'acc) -> 'acc -> 'a t -> 'b t -> 'acc
@since 4.14.0:
val fold_left2 : ('a -> 'b -> 'c -> 'a) -> 'a -> 'b t -> 'c t -> 'a
 *)

val for_all2 : ('a -> 'b -> bool) -> 'a t -> 'b t -> bool
(** @since 4.14.0: val for_all2 : ('a -> 'b -> bool) -> 'a t -> 'b t -> bool *)

val exists2 : ('a -> 'b -> bool) -> 'a t -> 'b t -> bool
(** @since 4.14.0: val exists2 : ('a -> 'b -> bool) -> 'a t -> 'b t -> bool *)

val equal : ('a -> 'b -> bool) -> 'a t -> 'b t -> bool
(** @since 4.14.0: val equal : ('a -> 'b -> bool) -> 'a t -> 'b t -> bool *)

val compare : ('a -> 'b -> int) -> 'a t -> 'b t -> int
(** @since 4.14.0: val compare : ('a -> 'b -> int) -> 'a t -> 'b t -> int *)

val init : int -> (int -> 'a) -> 'a t
(** @since 4.14.0: val init : int -> (int -> 'a) -> 'a t *)

val repeat : 'a -> 'a t
(** @since 4.14.0: val repeat : 'a -> 'a t *)

val forever : (unit -> 'a) -> 'a t
(** @since 4.14.0: val forever : (unit -> 'a) -> 'a t *)

val cycle : 'a t -> 'a t
(** @since 4.14.0: val cycle : 'a t -> 'a t *)

val iterate : ('a -> 'a) -> 'a -> 'a t
(** @since 4.14.0: val iterate : ('a -> 'a) -> 'a -> 'a t *)

val mapi : (int -> 'a -> 'b) -> 'a t -> 'b t
(** @since 4.14.0: val mapi : (int -> 'a -> 'b) -> 'a t -> 'b t *)

val scan : ('b -> 'a -> 'b) -> 'b -> 'a t -> 'b t
(** @since 4.14.0: val scan : ('b -> 'a -> 'b) -> 'b -> 'a t -> 'b t *)

val take : int -> 'a t -> 'a t
(** @since 4.14.0: val take : int -> 'a t -> 'a t *)

val drop : int -> 'a t -> 'a t
(** @since 4.14.0: val drop : int -> 'a t -> 'a t *)

val take_while : ('a -> bool) -> 'a t -> 'a t
(** @since 4.14.0: val take_while : ('a -> bool) -> 'a t -> 'a t *)

val drop_while : ('a -> bool) -> 'a t -> 'a t
(** @since 4.14.0: val drop_while : ('a -> bool) -> 'a t -> 'a t *)

val group : ('a -> 'a -> bool) -> 'a t -> 'a t t
(** @since 4.14.0: val group : ('a -> 'a -> bool) -> 'a t -> 'a t t *)

val memoize : 'a t -> 'a t
(** @since 4.14.0: val memoize : 'a t -> 'a t *)

val once : 'a t -> 'a t
(** @since 4.14.0: val once : 'a t -> 'a t *)

val transpose : 'a t t -> 'a t t
(** @since 4.14.0: val transpose : 'a t t -> 'a t t *)

val zip : 'a t -> 'b t -> ('a * 'b) t
(** @since 4.14.0: val zip : 'a t -> 'b t -> ('a * 'b) t *)

val map2 : ('a -> 'b -> 'c) -> 'a t -> 'b t -> 'c t
(** @since 4.14.0: val map2 : ('a -> 'b -> 'c) -> 'a t -> 'b t -> 'c t *)

val interleave : 'a t -> 'a t -> 'a t
(** @since 4.14.0: val interleave : 'a t -> 'a t -> 'a t *)

val sorted_merge : ('a -> 'a -> int) -> 'a t -> 'a t -> 'a t
(** @since 4.14.0:
    val sorted_merge : ('a -> 'a -> int) -> 'a t -> 'a t -> 'a t *)

val product : 'a t -> 'b t -> ('a * 'b) t
(** @since 4.14.0: val product : 'a t -> 'b t -> ('a * 'b) t *)

val map_product : ('a -> 'b -> 'c) -> 'a t -> 'b t -> 'c t
(** @since 4.14.0: val map_product : ('a -> 'b -> 'c) -> 'a t -> 'b t -> 'c t *)

val unzip : ('a * 'b) t -> ('a t * 'b t)
(** @since 4.14.0: val unzip : ('a * 'b) t -> ('a t * 'b t) *)

val split : ('a * 'b) t -> ('a t * 'b t)
(** @since 4.14.0: val split : ('a * 'b) t -> ('a t * 'b t) *)


val partition_map : ('a -> ('b, 'c) Either.t) -> 'a t -> ('b t * 'c t)

(*
val partition_map :
  ('a -> ('b, 'c) Stdcompat__either.t) -> 'a t -> ('b t * 'c t)
*)
(** @since 4.14.0:
    val partition_map : ('a -> ('b, 'c) Either.t) -> 'a t -> ('b t * 'c t)
 *)

val partition : ('a -> bool) -> 'a t -> ('a t * 'a t)
(** @since 4.14.0: val partition : ('a -> bool) -> 'a t -> ('a t * 'a t) *)

val of_dispenser : (unit -> 'a option) -> 'a t
(** @since 4.14.0: val of_dispenser : (unit -> 'a option) -> 'a t *)

val to_dispenser : 'a t -> unit -> 'a option
(** @since 4.14.0: val to_dispenser : 'a t -> unit -> 'a option *)

val ints : int -> int t
(** @since 4.14.0: val ints : int -> int t *)

val concat : 'a t t -> 'a t
(** @since 4.13.0: val concat : 'a t t -> 'a t *)

val concat_map : ('a -> 'b t) -> 'a t -> 'b t
(** @since 4.13.0: val concat_map : ('a -> 'b t) -> 'a t -> 'b t *)

val cons : 'a -> 'a t -> 'a t
(** @since 4.11.0: val cons : 'a -> 'a t -> 'a t *)

val unfold : ('b -> ('a * 'b) option) -> 'b -> 'a t
(** @since 4.11.0: val unfold : ('b -> ('a * 'b) option) -> 'b -> 'a t *)

val append : 'a t -> 'a t -> 'a t
(** @since 4.11.0: val append : 'a t -> 'a t -> 'a t *)

val iter : ('a -> unit) -> 'a t -> unit
(** @since 4.07.0: val iter : ('a -> unit) -> 'a t -> unit *)


val fold_left : ('acc -> 'a -> 'acc) -> 'acc -> 'a t -> 'acc

(*

val fold_left : ('a -> 'b -> 'a) -> 'a -> 'b t -> 'a

(*
val fold_left : ('acc -> 'a -> 'acc) -> 'acc -> 'a t -> 'acc
*)

*)
(** @since 5.1.0:
    val fold_left : ('acc -> 'a -> 'acc) -> 'acc -> 'a t -> 'acc
@since 4.07.0: val fold_left : ('a -> 'b -> 'a) -> 'a -> 'b t -> 'a
 *)

val empty : 'a t
(** @since 4.07.0: val empty : 'a t *)

val return : 'a -> 'a t
(** @since 4.07.0: val return : 'a -> 'a t *)

val map : ('a -> 'b) -> 'a t -> 'b t
(** @since 4.07.0: val map : ('a -> 'b) -> 'a t -> 'b t *)

val filter : ('a -> bool) -> 'a t -> 'a t
(** @since 4.07.0: val filter : ('a -> bool) -> 'a t -> 'a t *)

val filter_map : ('a -> 'b option) -> 'a t -> 'b t
(** @since 4.07.0: val filter_map : ('a -> 'b option) -> 'a t -> 'b t *)

val flat_map : ('a -> 'b t) -> 'a t -> 'b t
(** @since 4.07.0: val flat_map : ('a -> 'b t) -> 'a t -> 'b t *)

end
