module type S = sig
type t = string
(** Alias for {!String.t} *)

val hash : t -> int
(** @since 5.0.0: val hash : t -> int *)

val seeded_hash : int -> t -> int
(** @since 5.0.0: val seeded_hash : int -> t -> int *)


val get_utf_8_uchar : t -> int -> Uchar.utf_decode

(*
val get_utf_8_uchar : t -> int -> Stdcompat__uchar.utf_decode
*)
(** @since 4.14.0: val get_utf_8_uchar : t -> int -> Uchar.utf_decode
 *)

val is_valid_utf_8 : t -> bool
(** @since 4.14.0: val is_valid_utf_8 : t -> bool *)


val get_utf_16be_uchar : t -> int -> Uchar.utf_decode

(*
val get_utf_16be_uchar : t -> int -> Stdcompat__uchar.utf_decode
*)
(** @since 4.14.0: val get_utf_16be_uchar : t -> int -> Uchar.utf_decode
 *)

val is_valid_utf_16be : t -> bool
(** @since 4.14.0: val is_valid_utf_16be : t -> bool *)


val get_utf_16le_uchar : t -> int -> Uchar.utf_decode

(*
val get_utf_16le_uchar : t -> int -> Stdcompat__uchar.utf_decode
*)
(** @since 4.14.0: val get_utf_16le_uchar : t -> int -> Uchar.utf_decode
 *)

val is_valid_utf_16le : t -> bool
(** @since 4.14.0: val is_valid_utf_16le : t -> bool *)

val empty : string
(** @since 4.13.0: val empty : string *)


val of_bytes : bytes -> string

(*
val of_bytes : Stdcompat__init.bytes -> string
*)
(** @since 4.13.0: val of_bytes : bytes -> string
 *)


val to_bytes : string -> bytes

(*
val to_bytes : string -> Stdcompat__init.bytes
*)
(** @since 4.13.0: val to_bytes : string -> bytes
 *)

val cat : string -> string -> string
(** @since 4.13.0: val cat : string -> string -> string *)

val starts_with : prefix:string -> string -> bool
(** @since 4.13.0: val starts_with : prefix:string -> string -> bool *)

val ends_with : suffix:string -> string -> bool
(** @since 4.13.0: val ends_with : suffix:string -> string -> bool *)


val fold_left : ('acc -> char -> 'acc) -> 'acc -> string -> 'acc

(*

val fold_left : ('a -> char -> 'a) -> 'a -> string -> 'a

(*
val fold_left : ('acc -> char -> 'acc) -> 'acc -> string -> 'acc
*)

*)
(** @since 5.1.0:
    val fold_left : ('acc -> char -> 'acc) -> 'acc -> string -> 'acc
@since 4.13.0: val fold_left : ('a -> char -> 'a) -> 'a -> string -> 'a
 *)


val fold_right : (char -> 'acc -> 'acc) -> string -> 'acc -> 'acc

(*

val fold_right : (char -> 'a -> 'a) -> string -> 'a -> 'a

(*
val fold_right : (char -> 'acc -> 'acc) -> string -> 'acc -> 'acc
*)

*)
(** @since 5.1.0:
    val fold_right : (char -> 'acc -> 'acc) -> string -> 'acc -> 'acc
@since 4.13.0: val fold_right : (char -> 'a -> 'a) -> string -> 'a -> 'a
 *)

val for_all : (char -> bool) -> string -> bool
(** @since 4.13.0: val for_all : (char -> bool) -> string -> bool *)

val exists : (char -> bool) -> string -> bool
(** @since 4.13.0: val exists : (char -> bool) -> string -> bool *)

val get_uint8 : string -> int -> int
(** @since 4.13.0: val get_uint8 : string -> int -> int *)

val get_int8 : string -> int -> int
(** @since 4.13.0: val get_int8 : string -> int -> int *)

val get_uint16_ne : string -> int -> int
(** @since 4.13.0: val get_uint16_ne : string -> int -> int *)

val get_uint16_be : string -> int -> int
(** @since 4.13.0: val get_uint16_be : string -> int -> int *)

val get_uint16_le : string -> int -> int
(** @since 4.13.0: val get_uint16_le : string -> int -> int *)

val get_int16_ne : string -> int -> int
(** @since 4.13.0: val get_int16_ne : string -> int -> int *)

val get_int16_be : string -> int -> int
(** @since 4.13.0: val get_int16_be : string -> int -> int *)

val get_int16_le : string -> int -> int
(** @since 4.13.0: val get_int16_le : string -> int -> int *)

val get_int32_ne : string -> int -> int32
(** @since 4.13.0: val get_int32_ne : string -> int -> int32 *)

val get_int32_be : string -> int -> int32
(** @since 4.13.0: val get_int32_be : string -> int -> int32 *)

val get_int32_le : string -> int -> int32
(** @since 4.13.0: val get_int32_le : string -> int -> int32 *)

val get_int64_ne : string -> int -> int64
(** @since 4.13.0: val get_int64_ne : string -> int -> int64 *)

val get_int64_be : string -> int -> int64
(** @since 4.13.0: val get_int64_be : string -> int -> int64 *)

val get_int64_le : string -> int -> int64
(** @since 4.13.0: val get_int64_le : string -> int -> int64 *)


val to_seq : t -> char Seq.t

(*
val to_seq : t -> char Stdcompat__seq.t
*)
(** @since 4.07.0: val to_seq : t -> char Seq.t
 *)


val to_seqi : t -> (int * char) Seq.t

(*
val to_seqi : t -> (int * char) Stdcompat__seq.t
*)
(** @since 4.07.0: val to_seqi : t -> (int * char) Seq.t
 *)


val of_seq : char Seq.t -> t

(*
val of_seq : char Stdcompat__seq.t -> t
*)
(** @since 4.07.0: val of_seq : char Seq.t -> t
 *)

val index_from_opt : string -> int -> char -> int option
(** @since 4.05.0: val index_from_opt : string -> int -> char -> int option *)

val rindex_from_opt : string -> int -> char -> int option
(** @since 4.05.0: val rindex_from_opt : string -> int -> char -> int option *)

val index_opt : string -> char -> int option
(** @since 4.05.0: val index_opt : string -> char -> int option *)

val rindex_opt : string -> char -> int option
(** @since 4.05.0: val rindex_opt : string -> char -> int option *)

val split_on_char : char -> string -> string list
(** @since 4.04.0: val split_on_char : char -> string -> string list *)

val equal : t -> t -> bool
(** @since 4.03.0: val equal : t -> t -> bool *)

val uppercase_ascii : string -> string
(** @since 4.03.0: val uppercase_ascii : string -> string *)

val lowercase_ascii : string -> string
(** @since 4.03.0: val lowercase_ascii : string -> string *)

val capitalize_ascii : string -> string
(** @since 4.03.0: val capitalize_ascii : string -> string *)

val uncapitalize_ascii : string -> string
(** @since 4.03.0: val uncapitalize_ascii : string -> string *)

val init : int -> (int -> char) -> string
(** @since 4.02.0: val init : int -> (int -> char) -> string *)


val blit : string -> int -> bytes -> int -> int -> unit

(*
val blit : string -> int -> Stdcompat__init.bytes -> int -> int -> unit
*)
(** @since 4.02.0: val blit : string -> int -> bytes -> int -> int -> unit
 *)

val mapi : (int -> char -> char) -> string -> string
(** @since 4.02.0: val mapi : (int -> char -> char) -> string -> string *)


external unsafe_blit :
  string -> int -> bytes -> int -> int -> unit = "caml_blit_string"[@@noalloc
                                                                    ]

(*

external unsafe_blit :
  string -> int -> bytes -> int -> int -> unit = "caml_blit_string" "noalloc"

(*

external unsafe_blit :
  string -> int -> Stdcompat__init.bytes -> int -> int -> unit =
    "caml_blit_string" "noalloc"

(*
external unsafe_blit :
  string -> int -> Stdcompat__init.bytes -> int -> int -> unit =
    "blit_string" "noalloc"
*)

*)

*)
(** @since 4.03.0:
    external unsafe_blit :
      string -> int -> bytes -> int -> int -> unit = "caml_blit_string"
    [@@noalloc ]
@since 4.02.0:
external unsafe_blit :
  string -> int -> bytes -> int -> int -> unit = "caml_blit_string" "noalloc"
 *)

val map : (char -> char) -> string -> string
(** @since 4.00.0: val map : (char -> char) -> string -> string *)

val trim : string -> string
(** @since 4.00.0: val trim : string -> string *)

val iteri : (int -> char -> unit) -> string -> unit
(** @since 4.00.0: val iteri : (int -> char -> unit) -> string -> unit *)

val make : int -> char -> string
(** Alias for {!String.make} *)

external length : string -> int = "%string_length"
(** Alias for {!String.length} *)

external get : string -> int -> char = "%string_safe_get"
(** Alias for {!String.get} *)

val concat : string -> string list -> string
(** Alias for {!String.concat} *)

val compare : t -> t -> int
(** Alias for {!String.compare} *)

val contains_from : string -> int -> char -> bool
(** Alias for {!String.contains_from} *)

val rcontains_from : string -> int -> char -> bool
(** Alias for {!String.rcontains_from} *)

val contains : string -> char -> bool
(** Alias for {!String.contains} *)

val sub : string -> int -> int -> string
(** Alias for {!String.sub} *)

val escaped : string -> string
(** Alias for {!String.escaped} *)

val iter : (char -> unit) -> string -> unit
(** Alias for {!String.iter} *)

val index_from : string -> int -> char -> int
(** Alias for {!String.index_from} *)

val rindex_from : string -> int -> char -> int
(** Alias for {!String.rindex_from} *)

val index : string -> char -> int
(** Alias for {!String.index} *)

val rindex : string -> char -> int
(** Alias for {!String.rindex} *)

external unsafe_get : string -> int -> char = "%string_unsafe_get"
(** Alias for {!String.unsafe_get} *)

end
