module type S = sig

type backend_type = Sys.backend_type =
  | Native 
  | Bytecode 
  | Other of string 

(*
type backend_type =
  | Native 
  | Bytecode 
  | Other of string 
*)
(** @since 4.04.0: type backend_type =
                     | Native 
                     | Bytecode 
                     | Other of string 
 *)

type signal_behavior = Sys.signal_behavior =
  | Signal_default 
  | Signal_ignore 
  | Signal_handle of (int -> unit) 
(** Alias for {!Sys.signal_behavior} *)

exception Break 
(** Alias for {!Sys.Break} *)


type extra_prefix = Sys.extra_prefix =
  | Plus 
  | Tilde 

(*
type extra_prefix =
  | Plus 
  | Tilde 
*)
(** @since 4.14.0: type extra_prefix =
                     | Plus 
                     | Tilde 
 *)


type extra_info = (extra_prefix * string)

(*
type extra_info = (extra_prefix * string)
*)
(** @since 4.14.0: type extra_info = (extra_prefix * string)
 *)


type ocaml_release_info = Sys.ocaml_release_info =
  {
  major: int ;
  minor: int ;
  patchlevel: int ;
  extra: extra_info option }

(*
type ocaml_release_info =
  {
  major: int ;
  minor: int ;
  patchlevel: int ;
  extra: extra_info option }
*)
(** @since 4.14.0:
    type ocaml_release_info =
      {
      major: int ;
      minor: int ;
      patchlevel: int ;
      extra: extra_info option }
 *)


module Immediate64 = Sys.Immediate64

(*
module Immediate64 :
sig module type Non_immediate = sig type t end
module type Immediate = sig 
type t[@@immediate ]

(*
type t
*)
 end
module Make :
functor (Immediate : Immediate) ->
functor (Non_immediate : Non_immediate) -> sig 
type t[@@immediate64 ]

(*
type t
*)


type 'a repr =
  | Immediate: Immediate.t repr 
  | Non_immediate: Non_immediate.t repr 

(*
type 'a repr =
  | Immediate 
  | Non_immediate 
*)
 val repr : t repr end
end
*)
(** @since 4.10.0: module Immediate64 = Sys.Immediate64
 *)


external is_regular_file : string -> bool = "caml_sys_is_regular_file"

(*
val is_regular_file : string -> bool
*)
(** @since 5.1.0:
    external is_regular_file : string -> bool = "caml_sys_is_regular_file"
 *)

val development_version : bool
(** @since 4.14.0: val development_version : bool *)

val ocaml_release : ocaml_release_info
(** @since 4.14.0: val ocaml_release : ocaml_release_info *)


external mkdir : string -> int -> unit = "caml_sys_mkdir"

(*
val mkdir : string -> int -> unit
*)
(** @since 4.12.0: external mkdir : string -> int -> unit = "caml_sys_mkdir"
 *)


external rmdir : string -> unit = "caml_sys_rmdir"

(*
val rmdir : string -> unit
*)
(** @since 4.12.0: external rmdir : string -> unit = "caml_sys_rmdir"
 *)

val max_floatarray_length : int
(** @since 4.08.0: val max_floatarray_length : int *)

val getenv_opt : string -> string option
(** @since 4.05.0: val getenv_opt : string -> string option *)

val backend_type : backend_type
(** @since 4.04.0: val backend_type : backend_type *)

val int_size : int
(** @since 4.03.0: val int_size : int *)


external runtime_variant : unit -> string = "caml_runtime_variant"

(*
val runtime_variant : unit -> string
*)
(** @since 4.03.0:
    external runtime_variant : unit -> string = "caml_runtime_variant"
 *)


external runtime_parameters : unit -> string = "caml_runtime_parameters"

(*
val runtime_parameters : unit -> string
*)
(** @since 4.03.0:
    external runtime_parameters : unit -> string = "caml_runtime_parameters"
 *)

val sigbus : int
(** @since 4.03.0: val sigbus : int *)

val sigpoll : int
(** @since 4.03.0: val sigpoll : int *)

val sigsys : int
(** @since 4.03.0: val sigsys : int *)

val sigtrap : int
(** @since 4.03.0: val sigtrap : int *)

val sigurg : int
(** @since 4.03.0: val sigurg : int *)

val sigxcpu : int
(** @since 4.03.0: val sigxcpu : int *)

val sigxfsz : int
(** @since 4.03.0: val sigxfsz : int *)

val enable_runtime_warnings : bool -> unit
(** @since 4.03.0: val enable_runtime_warnings : bool -> unit *)

val runtime_warnings_enabled : unit -> bool
(** @since 4.03.0: val runtime_warnings_enabled : unit -> bool *)


external opaque_identity : 'a -> 'a = "%opaque"

(*
val opaque_identity : 'a -> 'a
*)
(** @since 4.03.0: external opaque_identity : 'a -> 'a = "%opaque"
 *)

val unix : bool
(** @since 4.01.0: val unix : bool *)

val win32 : bool
(** @since 4.01.0: val win32 : bool *)

val cygwin : bool
(** @since 4.01.0: val cygwin : bool *)

val big_endian : bool
(** @since 4.00.0: val big_endian : bool *)


external is_directory : string -> bool = "caml_sys_is_directory"

(*
val is_directory : string -> bool
*)
(** @since 3.10.0:
    external is_directory : string -> bool = "caml_sys_is_directory"
 *)


external argv : string array = "%sys_argv"

(*
val argv : string array
*)
(** @since 4.09.0: external argv : string array = "%sys_argv"
@since 3.07.0: val argv : string array
 *)

val executable_name : string
(** Alias for {!Sys.executable_name} *)


external file_exists : string -> bool = "caml_sys_file_exists"

(*
external file_exists : string -> bool = "sys_file_exists"
*)
(** @since 3.08.0:
    external file_exists : string -> bool = "caml_sys_file_exists"
@since 3.07.0: external file_exists : string -> bool = "sys_file_exists"
 *)


external remove : string -> unit = "caml_sys_remove"

(*
external remove : string -> unit = "sys_remove"
*)
(** @since 3.08.0: external remove : string -> unit = "caml_sys_remove"
@since 3.07.0: external remove : string -> unit = "sys_remove"
 *)


external rename : string -> string -> unit = "caml_sys_rename"

(*
external rename : string -> string -> unit = "sys_rename"
*)
(** @since 3.08.0:
    external rename : string -> string -> unit = "caml_sys_rename"
@since 3.07.0: external rename : string -> string -> unit = "sys_rename"
 *)


external getenv : string -> string = "caml_sys_getenv"

(*
external getenv : string -> string = "sys_getenv"
*)
(** @since 3.08.0: external getenv : string -> string = "caml_sys_getenv"
@since 3.07.0: external getenv : string -> string = "sys_getenv"
 *)


external command : string -> int = "caml_sys_system_command"

(*
external command : string -> int = "sys_system_command"
*)
(** @since 3.08.0:
    external command : string -> int = "caml_sys_system_command"
@since 3.07.0: external command : string -> int = "sys_system_command"
 *)


external time :
  unit -> ((float)[@unboxed ]) = "caml_sys_time" "caml_sys_time_unboxed"
[@@noalloc ]

(*

external time : unit -> float = "caml_sys_time"

(*
external time : unit -> float = "sys_time"
*)

*)
(** @since 4.03.0:
    external time :
      unit -> ((float)[@unboxed ]) = "caml_sys_time" "caml_sys_time_unboxed"
    [@@noalloc ]
@since 3.08.0: external time : unit -> float = "caml_sys_time"
@since 3.07.0: external time : unit -> float = "sys_time"
 *)


external chdir : string -> unit = "caml_sys_chdir"

(*
external chdir : string -> unit = "sys_chdir"
*)
(** @since 3.08.0: external chdir : string -> unit = "caml_sys_chdir"
@since 3.07.0: external chdir : string -> unit = "sys_chdir"
 *)


external getcwd : unit -> string = "caml_sys_getcwd"

(*
external getcwd : unit -> string = "sys_getcwd"
*)
(** @since 3.08.0: external getcwd : unit -> string = "caml_sys_getcwd"
@since 3.07.0: external getcwd : unit -> string = "sys_getcwd"
 *)


external readdir : string -> string array = "caml_sys_read_directory"

(*
external readdir : string -> string array = "sys_read_directory"
*)
(** @since 3.08.0:
    external readdir : string -> string array = "caml_sys_read_directory"
@since 3.07.0:
external readdir : string -> string array = "sys_read_directory"
 *)

val interactive : bool ref
(** Alias for {!Sys.interactive} *)

val os_type : string
(** Alias for {!Sys.os_type} *)

val word_size : int
(** Alias for {!Sys.word_size} *)

val max_string_length : int
(** Alias for {!Sys.max_string_length} *)

val max_array_length : int
(** Alias for {!Sys.max_array_length} *)


external signal :
  int -> signal_behavior -> signal_behavior = "caml_install_signal_handler"

(*
external signal :
  int -> signal_behavior -> signal_behavior = "install_signal_handler"
*)
(** @since 3.08.0:
    external signal :
      int -> signal_behavior -> signal_behavior =
        "caml_install_signal_handler"
@since 3.07.0:
external signal :
  int -> signal_behavior -> signal_behavior = "install_signal_handler"
 *)

val set_signal : int -> signal_behavior -> unit
(** Alias for {!Sys.set_signal} *)

val sigabrt : int
(** Alias for {!Sys.sigabrt} *)

val sigalrm : int
(** Alias for {!Sys.sigalrm} *)

val sigfpe : int
(** Alias for {!Sys.sigfpe} *)

val sighup : int
(** Alias for {!Sys.sighup} *)

val sigill : int
(** Alias for {!Sys.sigill} *)

val sigint : int
(** Alias for {!Sys.sigint} *)

val sigkill : int
(** Alias for {!Sys.sigkill} *)

val sigpipe : int
(** Alias for {!Sys.sigpipe} *)

val sigquit : int
(** Alias for {!Sys.sigquit} *)

val sigsegv : int
(** Alias for {!Sys.sigsegv} *)

val sigterm : int
(** Alias for {!Sys.sigterm} *)

val sigusr1 : int
(** Alias for {!Sys.sigusr1} *)

val sigusr2 : int
(** Alias for {!Sys.sigusr2} *)

val sigchld : int
(** Alias for {!Sys.sigchld} *)

val sigcont : int
(** Alias for {!Sys.sigcont} *)

val sigstop : int
(** Alias for {!Sys.sigstop} *)

val sigtstp : int
(** Alias for {!Sys.sigtstp} *)

val sigttin : int
(** Alias for {!Sys.sigttin} *)

val sigttou : int
(** Alias for {!Sys.sigttou} *)

val sigvtalrm : int
(** Alias for {!Sys.sigvtalrm} *)

val sigprof : int
(** Alias for {!Sys.sigprof} *)

val catch_break : bool -> unit
(** Alias for {!Sys.catch_break} *)

val ocaml_version : string
(** Alias for {!Sys.ocaml_version} *)


external poll_actions : unit -> unit = "%poll"


(*
val poll_actions : unit -> unit
*)

end
