/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.alert.AlertLevel;
import com.ghostchu.peerbanhelper.alert.AlertManager;
import com.ghostchu.peerbanhelper.text.Lang;
import com.ghostchu.peerbanhelper.text.TranslationComponent;
import com.ghostchu.peerbanhelper.util.MsgUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class CrashManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CrashManager.class);
    private final File file = new File(Main.getDataDirectory(), "running.marker");
    private final AlertManager alertManager;

    public CrashManager(AlertManager alertManager) {
        this.alertManager = alertManager;
    }

    public void putRunningFlag() {
        try {
            this.file.createNewFile();
            this.file.deleteOnExit();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                if (this.file.exists()) {
                    this.file.delete();
                }
            }));
        }
        catch (IOException e) {
            log.error("Unable to create running flag file", (Throwable)e);
        }
    }

    public boolean isRunningFlagExists() {
        return this.file.exists();
    }

    public void checkCrashRecovery() {
        for (String startupArg : Main.getStartupArgs()) {
            if (!startupArg.startsWith("crashRecovery")) continue;
            String[] args = startupArg.split(":");
            if (args.length != 2) {
                log.error("Invalid crash recovery argument: {}", (Object)startupArg);
                continue;
            }
            String pid = args[1];
            this.processCrashRecovery(pid);
            break;
        }
    }

    private void processCrashRecovery(String pid) {
        File crashInDataDirectory = new File(Main.getDataDirectory(), "hs_err_pid" + pid + ".log");
        log.info(crashInDataDirectory.getAbsolutePath());
        if (!crashInDataDirectory.exists()) {
            crashInDataDirectory = new File(new File(Optional.ofNullable(System.getenv("LOCALAPPDATA")).orElse("."), "PeerBanHelper"), "hs_err_pid" + pid + ".log");
            log.info(crashInDataDirectory.getAbsolutePath());
        }
        if (!crashInDataDirectory.exists()) {
            crashInDataDirectory = new File(new File(System.getProperty("java.io.tmpdir", "")), "hs_err_pid" + pid + ".log");
            log.info(crashInDataDirectory.getAbsolutePath());
        }
        if (!crashInDataDirectory.exists()) {
            crashInDataDirectory = new File(new File(System.getProperty("user.home", "")), "hs_err_pid" + pid + ".log");
            log.info(crashInDataDirectory.getAbsolutePath());
        }
        if (!crashInDataDirectory.exists()) {
            crashInDataDirectory = new File("hs_err_pid" + pid + ".log");
            log.info(crashInDataDirectory.getAbsolutePath());
        }
        if (!crashInDataDirectory.exists()) {
            log.warn("No crash file found for pid: {}", (Object)pid);
        }
        this.alertManager.publishAlert(true, AlertLevel.FATAL, "peerbanhelper-crash-recovery-" + String.valueOf(UUID.randomUUID()), new TranslationComponent(Lang.CRASH_MANAGER_CRASH_RECOVERY_ALERT_TITLE), new TranslationComponent(Lang.CRASH_MANAGER_CRASH_RECOVERY_ALERT_DESCRIPTION, pid, MsgUtil.getDateFormatter().format(new Date()), !crashInDataDirectory.exists() ? "N/A" : crashInDataDirectory.getAbsolutePath()));
    }
}

