/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.impl;

import com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.QBittorrentBasicAuth;
import com.ghostchu.peerbanhelper.downloader.impl.qbittorrent.QBittorrentConfig;
import java.util.Objects;
import lombok.Generated;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;

public final class QBittorrentConfigImpl
implements QBittorrentConfig {
    private String type;
    private String name;
    private String endpoint;
    private String username;
    private String password;
    private QBittorrentBasicAuth basicAuth;
    private boolean incrementBan;
    private boolean useShadowBan;
    private boolean verifySsl;
    private boolean ignorePrivate;
    private boolean paused;

    public static QBittorrentConfigImpl readFromYaml(ConfigurationSection section, String alternativeName) {
        QBittorrentConfigImpl config = new QBittorrentConfigImpl();
        config.setType("qbittorrent");
        config.setName(section.getString("name", alternativeName));
        config.setEndpoint(section.getString("endpoint"));
        if (config.getEndpoint().endsWith("/")) {
            config.setEndpoint(config.getEndpoint().substring(0, config.getEndpoint().length() - 1));
        }
        config.setUsername(section.getString("username", ""));
        config.setPassword(section.getString("password", ""));
        QBittorrentBasicAuth basicauthDTO = new QBittorrentBasicAuth();
        basicauthDTO.setUser(section.getString("basic-auth.user"));
        basicauthDTO.setPass(section.getString("basic-auth.pass"));
        config.setBasicAuth(basicauthDTO);
        config.setIncrementBan(section.getBoolean("increment-ban", false));
        config.setUseShadowBan(section.getBoolean("use-shadow-ban", false));
        config.setVerifySsl(section.getBoolean("verify-ssl", true));
        config.setIgnorePrivate(section.getBoolean("ignore-private", false));
        config.setPaused(section.getBoolean("paused", false));
        return config;
    }

    @Override
    public YamlConfiguration saveToYaml() {
        YamlConfiguration section = new YamlConfiguration();
        section.set("type", (Object)"qbittorrent");
        section.set("name", (Object)this.name);
        section.set("endpoint", (Object)this.endpoint);
        section.set("username", (Object)this.username);
        section.set("password", (Object)this.password);
        section.set("basic-auth.user", (Object)Objects.requireNonNullElse(this.basicAuth.getUser(), ""));
        section.set("basic-auth.pass", (Object)Objects.requireNonNullElse(this.basicAuth.getPass(), ""));
        section.set("increment-ban", (Object)this.incrementBan);
        section.set("use-shadow-ban", (Object)this.useShadowBan);
        section.set("verify-ssl", (Object)this.verifySsl);
        section.set("ignore-private", (Object)this.ignorePrivate);
        section.set("paused", (Object)this.paused);
        return section;
    }

    @Generated
    public QBittorrentConfigImpl() {
    }

    @Override
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Override
    @Generated
    public String getUsername() {
        return this.username;
    }

    @Override
    @Generated
    public String getPassword() {
        return this.password;
    }

    @Override
    @Generated
    public QBittorrentBasicAuth getBasicAuth() {
        return this.basicAuth;
    }

    @Override
    @Generated
    public boolean isIncrementBan() {
        return this.incrementBan;
    }

    @Override
    @Generated
    public boolean isUseShadowBan() {
        return this.useShadowBan;
    }

    @Override
    @Generated
    public boolean isVerifySsl() {
        return this.verifySsl;
    }

    @Override
    @Generated
    public boolean isIgnorePrivate() {
        return this.ignorePrivate;
    }

    @Override
    @Generated
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    @Generated
    public void setBasicAuth(QBittorrentBasicAuth basicAuth) {
        this.basicAuth = basicAuth;
    }

    @Override
    @Generated
    public void setIncrementBan(boolean incrementBan) {
        this.incrementBan = incrementBan;
    }

    @Override
    @Generated
    public void setUseShadowBan(boolean useShadowBan) {
        this.useShadowBan = useShadowBan;
    }

    @Override
    @Generated
    public void setVerifySsl(boolean verifySsl) {
        this.verifySsl = verifySsl;
    }

    @Override
    @Generated
    public void setIgnorePrivate(boolean ignorePrivate) {
        this.ignorePrivate = ignorePrivate;
    }

    @Override
    @Generated
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QBittorrentConfigImpl)) {
            return false;
        }
        QBittorrentConfigImpl other = (QBittorrentConfigImpl)o;
        if (this.isIncrementBan() != other.isIncrementBan()) {
            return false;
        }
        if (this.isUseShadowBan() != other.isUseShadowBan()) {
            return false;
        }
        if (this.isVerifySsl() != other.isVerifySsl()) {
            return false;
        }
        if (this.isIgnorePrivate() != other.isIgnorePrivate()) {
            return false;
        }
        if (this.isPaused() != other.isPaused()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        QBittorrentBasicAuth this$basicAuth = this.getBasicAuth();
        QBittorrentBasicAuth other$basicAuth = other.getBasicAuth();
        return !(this$basicAuth == null ? other$basicAuth != null : !((Object)this$basicAuth).equals(other$basicAuth));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncrementBan() ? 79 : 97);
        result = result * 59 + (this.isUseShadowBan() ? 79 : 97);
        result = result * 59 + (this.isVerifySsl() ? 79 : 97);
        result = result * 59 + (this.isIgnorePrivate() ? 79 : 97);
        result = result * 59 + (this.isPaused() ? 79 : 97);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        QBittorrentBasicAuth $basicAuth = this.getBasicAuth();
        result = result * 59 + ($basicAuth == null ? 43 : ((Object)$basicAuth).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "QBittorrentConfigImpl(type=" + this.getType() + ", name=" + this.getName() + ", endpoint=" + this.getEndpoint() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", basicAuth=" + String.valueOf(this.getBasicAuth()) + ", incrementBan=" + this.isIncrementBan() + ", useShadowBan=" + this.isUseShadowBan() + ", verifySsl=" + this.isVerifySsl() + ", ignorePrivate=" + this.isIgnorePrivate() + ", paused=" + this.isPaused() + ")";
    }
}

