/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.module.impl.monitor;

import com.ghostchu.peerbanhelper.Main;
import com.ghostchu.peerbanhelper.bittorrent.peer.Peer;
import com.ghostchu.peerbanhelper.bittorrent.torrent.Torrent;
import com.ghostchu.peerbanhelper.database.dao.impl.PeerConnectionMetricDao;
import com.ghostchu.peerbanhelper.database.dao.impl.PeerConnectionMetricsTrackDao;
import com.ghostchu.peerbanhelper.database.dao.impl.TorrentDao;
import com.ghostchu.peerbanhelper.database.table.PeerConnectionMetricsEntity;
import com.ghostchu.peerbanhelper.downloader.Downloader;
import com.ghostchu.peerbanhelper.module.AbstractFeatureModule;
import com.ghostchu.peerbanhelper.module.MonitorFeatureModule;
import com.ghostchu.peerbanhelper.util.MiscUtil;
import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.Reloadable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SessionAnalyseServiceModule
extends AbstractFeatureModule
implements Reloadable,
MonitorFeatureModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionAnalyseServiceModule.class);
    @Autowired
    private PeerConnectionMetricsTrackDao connectionMetricsTrackDao;
    @Autowired
    private PeerConnectionMetricDao connectionMetricDao;
    private long cleanupInterval;
    private long dataRetentionTime;
    private long dataFlushInterval;
    @Autowired
    private TorrentDao torrentDao;

    @Override
    public boolean isConfigurable() {
        return true;
    }

    @Override
    public void onTorrentPeersRetrieved(@NotNull Downloader downloader, @NotNull Torrent torrent, @NotNull List<Peer> peers) {
        try {
            this.connectionMetricsTrackDao.syncPeers(downloader, torrent, peers, this.torrentDao);
        }
        catch (SQLException | ExecutionException e) {
            log.warn("Failed to record torrent peers for session analyse", (Throwable)e);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "Session Analyse Service";
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "peer-analyse-service.session-analyse";
    }

    @Override
    public void onEnable() {
        this.reloadConfig();
        this.cleanupInterval = this.getConfig().getLong("cleanup-interval");
        this.dataFlushInterval = this.getConfig().getLong("data-flush-interval");
        this.registerScheduledTask(this::cleanup, 0L, this.cleanupInterval, TimeUnit.MILLISECONDS);
        this.registerScheduledTask(this::flushData, 0L, this.dataFlushInterval, TimeUnit.MILLISECONDS);
        Main.getReloadManager().register((Reloadable)this);
    }

    private void flushData() {
        try {
            this.connectionMetricsTrackDao.flushAll();
            long startOfToday = MiscUtil.getStartOfToday(System.currentTimeMillis());
            List listNotInTheDay = this.connectionMetricsTrackDao.queryBuilder().where().ne("timeframeAt", (Object)new Timestamp(startOfToday)).query();
            List<PeerConnectionMetricsEntity> aggNotInTheDayList = this.connectionMetricDao.aggregating(listNotInTheDay);
            this.connectionMetricDao.saveAggregating(aggNotInTheDayList, true);
            this.connectionMetricsTrackDao.delete(listNotInTheDay);
            List listInTheDay = this.connectionMetricsTrackDao.queryBuilder().where().eq("timeframeAt", (Object)new Timestamp(startOfToday)).query();
            List<PeerConnectionMetricsEntity> aggInTheDayList = this.connectionMetricDao.aggregating(listInTheDay);
            this.connectionMetricDao.saveAggregating(aggInTheDayList, true);
        }
        catch (SQLException e) {
            log.warn("Failed to flush session analyse data", (Throwable)e);
        }
    }

    private void cleanup() {
        this.connectionMetricDao.removeOutdatedData(new Timestamp(System.currentTimeMillis() - this.dataRetentionTime));
    }

    public ReloadResult reloadModule() throws Exception {
        this.reloadConfig();
        return super.reloadModule();
    }

    private void reloadConfig() {
        this.dataRetentionTime = this.getConfig().getLong("data-retention-time");
    }

    @Override
    public void onDisable() {
        this.flushData();
    }
}

