/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.platform.win32.ecoqos;

import com.ghostchu.peerbanhelper.platform.win32.ecoqos.EcoModeNative;
import com.ghostchu.peerbanhelper.platform.win32.ecoqos.PROCESS_POWER_THROTTLING_STATE;
import com.sun.jna.platform.win32.WinNT;

public class EcoMode {
    public String setEcoMode(boolean enable) {
        Object message;
        int priorityClass;
        PROCESS_POWER_THROTTLING_STATE powerThrottling = new PROCESS_POWER_THROTTLING_STATE();
        powerThrottling.Version = 1;
        if (enable) {
            powerThrottling.ControlMask = 1;
            powerThrottling.StateMask = 1;
        } else {
            powerThrottling.ControlMask = 0;
            powerThrottling.StateMask = 0;
        }
        WinNT.HANDLE currentProcess = EcoModeNative.INSTANCE.GetCurrentProcess();
        if (!EcoModeNative.INSTANCE.SetProcessInformation(currentProcess, 4, powerThrottling, powerThrottling.size())) {
            int error = EcoModeNative.INSTANCE.GetLastError();
            String message2 = "SetProcessInformation failed with error: " + error;
            return message2;
        }
        int n = priorityClass = enable ? 64 : 32;
        if (!EcoModeNative.INSTANCE.SetPriorityClass(currentProcess, priorityClass)) {
            int error = EcoModeNative.INSTANCE.GetLastError();
            message = "SetPriorityClass failed with error: " + error;
        } else {
            message = "SUCCESS";
        }
        return message;
    }

    public int setPriority(int priority) {
        int dwPriorityClass;
        WinNT.HANDLE hProcess = EcoModeNative.INSTANCE.GetCurrentProcess();
        switch (priority) {
            case -1: {
                dwPriorityClass = 64;
                break;
            }
            case 0: {
                dwPriorityClass = 32;
                break;
            }
            case 1: {
                dwPriorityClass = 128;
                break;
            }
            case 2: {
                dwPriorityClass = 256;
                break;
            }
            default: {
                return -1;
            }
        }
        if (EcoModeNative.INSTANCE.SetPriorityClass(hProcess, dwPriorityClass)) {
            return 0;
        }
        return -1;
    }
}

