/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.peerbanhelper.util.push.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ghostchu.peerbanhelper.util.HTTPUtil;
import com.ghostchu.peerbanhelper.util.json.JsonUtil;
import com.ghostchu.peerbanhelper.util.push.AbstractPushProvider;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.bspfsystems.yamlconfiguration.configuration.ConfigurationSection;
import org.bspfsystems.yamlconfiguration.file.YamlConfiguration;

public final class ServerChanPushProvider
extends AbstractPushProvider {
    private final Config config;
    private final String name;
    private final HTTPUtil httpUtil;

    public ServerChanPushProvider(String name, Config config, HTTPUtil httpUtil) {
        this.name = name;
        this.config = config;
        this.httpUtil = httpUtil;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getConfigType() {
        return "serverchan";
    }

    @Override
    public JsonObject saveJson() {
        return JsonUtil.readObject(JsonUtil.standard().toJson((Object)this.config));
    }

    @Override
    public ConfigurationSection saveYaml() {
        YamlConfiguration section = new YamlConfiguration();
        section.set("type", (Object)"serverchan");
        section.set("sendkey", (Object)this.config.getSendKey());
        section.set("channel", (Object)this.config.getChannel());
        section.set("openid", (Object)this.config.getOpenId());
        return section;
    }

    public static ServerChanPushProvider loadFromJson(String name, JsonObject json, HTTPUtil httpUtil) {
        return new ServerChanPushProvider(name, (Config)JsonUtil.getGson().fromJson((JsonElement)json, Config.class), httpUtil);
    }

    public static ServerChanPushProvider loadFromYaml(String name, ConfigurationSection section, HTTPUtil httpUtil) {
        String sendKey = section.getString("sendkey", "");
        String channel = section.getString("channel", "");
        String openid = section.getString("openid", "");
        if (channel.isBlank()) {
            channel = null;
        }
        if (openid.isBlank()) {
            openid = null;
        }
        Config config = new Config(sendKey, channel, openid);
        return new ServerChanPushProvider(name, config, httpUtil);
    }

    @Override
    public boolean push(String title, String content) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("title", title);
        map.put("desp", content);
        map.put("text", title);
        if (this.config.getChannel() != null) {
            map.put("channel", this.config.getChannel());
        }
        if (this.config.getOpenId() != null) {
            map.put("openid", this.config.getOpenId());
        }
        RequestBody requestBody = RequestBody.create((String)JsonUtil.getGson().toJson(map), (MediaType)MediaType.parse((String)"application/json"));
        Request request = new Request.Builder().url("https://sctapi.ftqq.com/" + this.config.getSendKey() + ".send").post(requestBody).header("Content-Type", "application/json").build();
        try (Response response = this.httpUtil.newBuilder().build().newCall(request).execute();){
            if (!response.isSuccessful()) {
                String responseBody = response.body().string();
                ServerChanResponse scr = (ServerChanResponse)JsonUtil.getGson().fromJson(responseBody, ServerChanResponse.class);
                throw new IllegalStateException("HTTP Failed while sending push messages to ServerChan: " + scr.getMessage());
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to send push message to ServerChan", e);
        }
        return true;
    }

    public static class Config {
        private String sendKey;
        private String channel;
        private String openId;

        @Generated
        public Config(String sendKey, String channel, String openId) {
            this.sendKey = sendKey;
            this.channel = channel;
            this.openId = openId;
        }

        @Generated
        public String getSendKey() {
            return this.sendKey;
        }

        @Generated
        public String getChannel() {
            return this.channel;
        }

        @Generated
        public String getOpenId() {
            return this.openId;
        }

        @Generated
        public void setSendKey(String sendKey) {
            this.sendKey = sendKey;
        }

        @Generated
        public void setChannel(String channel) {
            this.channel = channel;
        }

        @Generated
        public void setOpenId(String openId) {
            this.openId = openId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sendKey = this.getSendKey();
            String other$sendKey = other.getSendKey();
            if (this$sendKey == null ? other$sendKey != null : !this$sendKey.equals(other$sendKey)) {
                return false;
            }
            String this$channel = this.getChannel();
            String other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
                return false;
            }
            String this$openId = this.getOpenId();
            String other$openId = other.getOpenId();
            return !(this$openId == null ? other$openId != null : !this$openId.equals(other$openId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sendKey = this.getSendKey();
            result = result * 59 + ($sendKey == null ? 43 : $sendKey.hashCode());
            String $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
            String $openId = this.getOpenId();
            result = result * 59 + ($openId == null ? 43 : $openId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServerChanPushProvider.Config(sendKey=" + this.getSendKey() + ", channel=" + this.getChannel() + ", openId=" + this.getOpenId() + ")";
        }
    }

    public static class ServerChanResponse {
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="code")
        private Integer code;
        @JsonProperty(value="info")
        private String info;
        @JsonProperty(value="scode")
        private Integer scode;

        @Generated
        public ServerChanResponse() {
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public Integer getCode() {
            return this.code;
        }

        @Generated
        public String getInfo() {
            return this.info;
        }

        @Generated
        public Integer getScode() {
            return this.scode;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public void setCode(Integer code) {
            this.code = code;
        }

        @Generated
        public void setInfo(String info) {
            this.info = info;
        }

        @Generated
        public void setScode(Integer scode) {
            this.scode = scode;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerChanResponse)) {
                return false;
            }
            ServerChanResponse other = (ServerChanResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$code = this.getCode();
            Integer other$code = other.getCode();
            if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
                return false;
            }
            Integer this$scode = this.getScode();
            Integer other$scode = other.getScode();
            if (this$scode == null ? other$scode != null : !((Object)this$scode).equals(other$scode)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$info = this.getInfo();
            String other$info = other.getInfo();
            return !(this$info == null ? other$info != null : !this$info.equals(other$info));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ServerChanResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
            Integer $scode = this.getScode();
            result = result * 59 + ($scode == null ? 43 : ((Object)$scode).hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $info = this.getInfo();
            result = result * 59 + ($info == null ? 43 : $info.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServerChanPushProvider.ServerChanResponse(message=" + this.getMessage() + ", code=" + this.getCode() + ", info=" + this.getInfo() + ", scode=" + this.getScode() + ")";
        }
    }
}

