/*
 * Decompiled with CFR 0.152.
 */
package com.ghostchu.simplereloadlib;

import com.ghostchu.simplereloadlib.ReloadResult;
import com.ghostchu.simplereloadlib.ReloadStatus;
import com.ghostchu.simplereloadlib.Reloadable;
import com.ghostchu.simplereloadlib.ReloadableContainer;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReloadManager {
    private final List<ReloadableContainer> registry = Collections.synchronizedList(new LinkedList());

    public synchronized void register(@NotNull Reloadable reloadable) {
        this.unregister(reloadable);
        this.registry.add(new ReloadableContainer(new WeakReference<Reloadable>(reloadable), null));
    }

    public synchronized void register(@NotNull Method reloadMethod) {
        this.unregister(reloadMethod);
        this.registry.add(new ReloadableContainer(null, reloadMethod));
    }

    public synchronized void unregister(@NotNull Method reloadMethod) {
        this.registry.removeIf(reloadableContainer -> {
            if (reloadableContainer.getReloadableMethod() != null) {
                Method method = reloadableContainer.getReloadableMethod();
                return reloadMethod.equals(method);
            }
            return false;
        });
    }

    public synchronized void unregister(@NotNull Reloadable reloadable) {
        this.registry.removeIf(reloadableContainer -> {
            if (reloadableContainer != null && reloadableContainer.getReloadable() != null) {
                return Objects.equals(reloadableContainer.getReloadable().get(), reloadable);
            }
            return false;
        });
    }

    public synchronized void unregister(@NotNull Class<Reloadable> clazz) {
        this.registry.removeIf(reloadable -> {
            Method method;
            if (reloadable.getReloadable() != null) {
                Reloadable rable = (Reloadable)reloadable.getReloadable().get();
                if (rable != null) {
                    return clazz.equals(rable.getClass());
                }
                return false;
            }
            if (reloadable.getReloadableMethod() != null && (method = reloadable.getReloadableMethod()) != null) {
                return clazz.equals(method.getDeclaringClass());
            }
            return false;
        });
    }

    @NotNull
    public synchronized Map<ReloadableContainer, ReloadResult> reload() {
        return this.reload(null);
    }

    @NotNull
    public synchronized Map<ReloadableContainer, ReloadResult> reload(@Nullable Class<Reloadable> clazz) {
        LinkedHashMap<ReloadableContainer, ReloadResult> reloadResultMap = new LinkedHashMap<ReloadableContainer, ReloadResult>();
        for (ReloadableContainer reloadContainer : new ArrayList<ReloadableContainer>(this.registry)) {
            Reloadable reloadable = null;
            Method reloadMethod = null;
            if (reloadContainer.getReloadable() != null) {
                reloadable = (Reloadable)reloadContainer.getReloadable().get();
            }
            if (reloadContainer.getReloadableMethod() != null) {
                reloadMethod = reloadContainer.getReloadableMethod();
            }
            if (reloadable == null && reloadMethod == null) {
                reloadResultMap.put(reloadContainer, new ReloadResult(ReloadStatus.OUTDATED, "Container object has been outdated", null));
                this.registry.remove(reloadContainer);
                continue;
            }
            ReloadResult reloadResult = new ReloadResult(ReloadStatus.EXCEPTION, "Incorrect reload object", null);
            try {
                if (reloadable != null) {
                    if (clazz != null && !clazz.equals(reloadable.getClass())) continue;
                    reloadResult = reloadable.reloadModule();
                }
                if (reloadMethod != null) {
                    if (clazz != null && !clazz.equals(reloadMethod.getDeclaringClass())) continue;
                    reloadResult = (ReloadResult)reloadMethod.invoke(null, new Object[0]);
                }
                reloadResultMap.put(reloadContainer, reloadResult);
            }
            catch (Exception e) {
                reloadResultMap.put(reloadContainer, new ReloadResult(ReloadStatus.EXCEPTION, "Reloading failed", e));
            }
        }
        return reloadResultMap;
    }
}

