/*
 * Decompiled with CFR 0.152.
 */
package com.maxmind.db;

import java.net.InetAddress;
import java.net.UnknownHostException;

public record Network(InetAddress ipAddress, int prefixLength) {
    public InetAddress networkAddress() {
        byte[] ipBytes = this.ipAddress.getAddress();
        byte[] networkBytes = new byte[ipBytes.length];
        int curPrefix = this.prefixLength;
        for (int i = 0; i < ipBytes.length && curPrefix > 0; curPrefix -= 8, ++i) {
            byte b = ipBytes[i];
            if (curPrefix < 8) {
                int shiftN = 8 - curPrefix;
                b = (byte)(b >> shiftN << shiftN);
            }
            networkBytes[i] = b;
        }
        try {
            return InetAddress.getByAddress(networkBytes);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Illegal network address byte length of " + networkBytes.length);
        }
    }

    @Override
    public String toString() {
        return this.networkAddress().getHostAddress() + "/" + this.prefixLength;
    }
}

