# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SynthesizeSpeechDetails(object):
    """
    Input JSON to get audio inference from TTS Service.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SynthesizeSpeechDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param text:
            The value to assign to the text property of this SynthesizeSpeechDetails.
        :type text: str

        :param is_stream_enabled:
            The value to assign to the is_stream_enabled property of this SynthesizeSpeechDetails.
        :type is_stream_enabled: bool

        :param compartment_id:
            The value to assign to the compartment_id property of this SynthesizeSpeechDetails.
        :type compartment_id: str

        :param configuration:
            The value to assign to the configuration property of this SynthesizeSpeechDetails.
        :type configuration: oci.ai_speech.models.TtsConfiguration

        :param audio_config:
            The value to assign to the audio_config property of this SynthesizeSpeechDetails.
        :type audio_config: oci.ai_speech.models.TtsAudioConfig

        """
        self.swagger_types = {
            'text': 'str',
            'is_stream_enabled': 'bool',
            'compartment_id': 'str',
            'configuration': 'TtsConfiguration',
            'audio_config': 'TtsAudioConfig'
        }
        self.attribute_map = {
            'text': 'text',
            'is_stream_enabled': 'isStreamEnabled',
            'compartment_id': 'compartmentId',
            'configuration': 'configuration',
            'audio_config': 'audioConfig'
        }
        self._text = None
        self._is_stream_enabled = None
        self._compartment_id = None
        self._configuration = None
        self._audio_config = None

    @property
    def text(self):
        """
        **[Required]** Gets the text of this SynthesizeSpeechDetails.
        The text input to get the inference audio from TTS Service.


        :return: The text of this SynthesizeSpeechDetails.
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Sets the text of this SynthesizeSpeechDetails.
        The text input to get the inference audio from TTS Service.


        :param text: The text of this SynthesizeSpeechDetails.
        :type: str
        """
        self._text = text

    @property
    def is_stream_enabled(self):
        """
        Gets the is_stream_enabled of this SynthesizeSpeechDetails.
        If set to true, response will be sent in the chunked transfer-encoding and audio chunks
        are sent back as and when they are ready. If set to false, response will be sent only once
        the entire audio is generated.


        :return: The is_stream_enabled of this SynthesizeSpeechDetails.
        :rtype: bool
        """
        return self._is_stream_enabled

    @is_stream_enabled.setter
    def is_stream_enabled(self, is_stream_enabled):
        """
        Sets the is_stream_enabled of this SynthesizeSpeechDetails.
        If set to true, response will be sent in the chunked transfer-encoding and audio chunks
        are sent back as and when they are ready. If set to false, response will be sent only once
        the entire audio is generated.


        :param is_stream_enabled: The is_stream_enabled of this SynthesizeSpeechDetails.
        :type: bool
        """
        self._is_stream_enabled = is_stream_enabled

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this SynthesizeSpeechDetails.
        The `OCID`__ of the compartment where the user has access to call `SpeechSynthesize` api. But default user access will be checked at tenancy level.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this SynthesizeSpeechDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this SynthesizeSpeechDetails.
        The `OCID`__ of the compartment where the user has access to call `SpeechSynthesize` api. But default user access will be checked at tenancy level.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this SynthesizeSpeechDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def configuration(self):
        """
        Gets the configuration of this SynthesizeSpeechDetails.

        :return: The configuration of this SynthesizeSpeechDetails.
        :rtype: oci.ai_speech.models.TtsConfiguration
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration):
        """
        Sets the configuration of this SynthesizeSpeechDetails.

        :param configuration: The configuration of this SynthesizeSpeechDetails.
        :type: oci.ai_speech.models.TtsConfiguration
        """
        self._configuration = configuration

    @property
    def audio_config(self):
        """
        Gets the audio_config of this SynthesizeSpeechDetails.

        :return: The audio_config of this SynthesizeSpeechDetails.
        :rtype: oci.ai_speech.models.TtsAudioConfig
        """
        return self._audio_config

    @audio_config.setter
    def audio_config(self, audio_config):
        """
        Sets the audio_config of this SynthesizeSpeechDetails.

        :param audio_config: The audio_config of this SynthesizeSpeechDetails.
        :type: oci.ai_speech.models.TtsAudioConfig
        """
        self._audio_config = audio_config

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
