# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LookupContainerImageByUriDetails(object):
    """
    Details for fetching a container image by its URI.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LookupContainerImageByUriDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param image_uri:
            The value to assign to the image_uri property of this LookupContainerImageByUriDetails.
        :type image_uri: str

        """
        self.swagger_types = {
            'image_uri': 'str'
        }
        self.attribute_map = {
            'image_uri': 'imageUri'
        }
        self._image_uri = None

    @property
    def image_uri(self):
        """
        **[Required]** Gets the image_uri of this LookupContainerImageByUriDetails.
        The container image URI starting with the namespace.
        Example: namespace/reponame:version
        Example: namespace/reponame@sha256:50d858e0985ecc7f60418aaf0cc5ab587f42c2570a884095a9e8ccacd0f6545c


        :return: The image_uri of this LookupContainerImageByUriDetails.
        :rtype: str
        """
        return self._image_uri

    @image_uri.setter
    def image_uri(self, image_uri):
        """
        Sets the image_uri of this LookupContainerImageByUriDetails.
        The container image URI starting with the namespace.
        Example: namespace/reponame:version
        Example: namespace/reponame@sha256:50d858e0985ecc7f60418aaf0cc5ab587f42c2570a884095a9e8ccacd0f6545c


        :param image_uri: The image_uri of this LookupContainerImageByUriDetails.
        :type: str
        """
        self._image_uri = image_uri

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
