# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220509


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Placement(object):
    """
    Describes the placement of an instance.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Placement object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param affinity:
            The value to assign to the affinity property of this Placement.
        :type affinity: str

        :param availability_zone:
            The value to assign to the availability_zone property of this Placement.
        :type availability_zone: str

        :param group_name:
            The value to assign to the group_name property of this Placement.
        :type group_name: str

        :param host_key:
            The value to assign to the host_key property of this Placement.
        :type host_key: str

        :param host_resource_group_arn:
            The value to assign to the host_resource_group_arn property of this Placement.
        :type host_resource_group_arn: str

        :param partition_number:
            The value to assign to the partition_number property of this Placement.
        :type partition_number: int

        :param spread_domain:
            The value to assign to the spread_domain property of this Placement.
        :type spread_domain: str

        :param tenancy:
            The value to assign to the tenancy property of this Placement.
        :type tenancy: str

        """
        self.swagger_types = {
            'affinity': 'str',
            'availability_zone': 'str',
            'group_name': 'str',
            'host_key': 'str',
            'host_resource_group_arn': 'str',
            'partition_number': 'int',
            'spread_domain': 'str',
            'tenancy': 'str'
        }
        self.attribute_map = {
            'affinity': 'affinity',
            'availability_zone': 'availabilityZone',
            'group_name': 'groupName',
            'host_key': 'hostKey',
            'host_resource_group_arn': 'hostResourceGroupArn',
            'partition_number': 'partitionNumber',
            'spread_domain': 'spreadDomain',
            'tenancy': 'tenancy'
        }
        self._affinity = None
        self._availability_zone = None
        self._group_name = None
        self._host_key = None
        self._host_resource_group_arn = None
        self._partition_number = None
        self._spread_domain = None
        self._tenancy = None

    @property
    def affinity(self):
        """
        Gets the affinity of this Placement.
        The affinity setting for the instance on the Dedicated Host.


        :return: The affinity of this Placement.
        :rtype: str
        """
        return self._affinity

    @affinity.setter
    def affinity(self, affinity):
        """
        Sets the affinity of this Placement.
        The affinity setting for the instance on the Dedicated Host.


        :param affinity: The affinity of this Placement.
        :type: str
        """
        self._affinity = affinity

    @property
    def availability_zone(self):
        """
        Gets the availability_zone of this Placement.
        The Availability Zone of the instance.


        :return: The availability_zone of this Placement.
        :rtype: str
        """
        return self._availability_zone

    @availability_zone.setter
    def availability_zone(self, availability_zone):
        """
        Sets the availability_zone of this Placement.
        The Availability Zone of the instance.


        :param availability_zone: The availability_zone of this Placement.
        :type: str
        """
        self._availability_zone = availability_zone

    @property
    def group_name(self):
        """
        Gets the group_name of this Placement.
        The name of the placement group the instance is in.


        :return: The group_name of this Placement.
        :rtype: str
        """
        return self._group_name

    @group_name.setter
    def group_name(self, group_name):
        """
        Sets the group_name of this Placement.
        The name of the placement group the instance is in.


        :param group_name: The group_name of this Placement.
        :type: str
        """
        self._group_name = group_name

    @property
    def host_key(self):
        """
        Gets the host_key of this Placement.
        The ID of the Dedicated Host on which the instance resides.


        :return: The host_key of this Placement.
        :rtype: str
        """
        return self._host_key

    @host_key.setter
    def host_key(self, host_key):
        """
        Sets the host_key of this Placement.
        The ID of the Dedicated Host on which the instance resides.


        :param host_key: The host_key of this Placement.
        :type: str
        """
        self._host_key = host_key

    @property
    def host_resource_group_arn(self):
        """
        Gets the host_resource_group_arn of this Placement.
        The ARN of the host resource group in which to launch the instances.


        :return: The host_resource_group_arn of this Placement.
        :rtype: str
        """
        return self._host_resource_group_arn

    @host_resource_group_arn.setter
    def host_resource_group_arn(self, host_resource_group_arn):
        """
        Sets the host_resource_group_arn of this Placement.
        The ARN of the host resource group in which to launch the instances.


        :param host_resource_group_arn: The host_resource_group_arn of this Placement.
        :type: str
        """
        self._host_resource_group_arn = host_resource_group_arn

    @property
    def partition_number(self):
        """
        Gets the partition_number of this Placement.
        The number of the partition that the instance is in.


        :return: The partition_number of this Placement.
        :rtype: int
        """
        return self._partition_number

    @partition_number.setter
    def partition_number(self, partition_number):
        """
        Sets the partition_number of this Placement.
        The number of the partition that the instance is in.


        :param partition_number: The partition_number of this Placement.
        :type: int
        """
        self._partition_number = partition_number

    @property
    def spread_domain(self):
        """
        Gets the spread_domain of this Placement.
        Reserved for future use.


        :return: The spread_domain of this Placement.
        :rtype: str
        """
        return self._spread_domain

    @spread_domain.setter
    def spread_domain(self, spread_domain):
        """
        Sets the spread_domain of this Placement.
        Reserved for future use.


        :param spread_domain: The spread_domain of this Placement.
        :type: str
        """
        self._spread_domain = spread_domain

    @property
    def tenancy(self):
        """
        Gets the tenancy of this Placement.
        The tenancy of the instance (if the instance is running in a VPC).


        :return: The tenancy of this Placement.
        :rtype: str
        """
        return self._tenancy

    @tenancy.setter
    def tenancy(self, tenancy):
        """
        Sets the tenancy of this Placement.
        The tenancy of the instance (if the instance is running in a VPC).


        :param tenancy: The tenancy of this Placement.
        :type: str
        """
        self._tenancy = tenancy

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
