# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221208


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CccInfrastructureNetworkConfiguration(object):
    """
    Configuration information for the Compute Cloud@Customer infrastructure. This
    network configuration information cannot be updated and is retrieved from the data center.
    The information will only be available
    after the connectionState is transitioned to CONNECTED.
    """

    #: A constant which can be used with the uplink_port_forward_error_correction property of a CccInfrastructureNetworkConfiguration.
    #: This constant has a value of "AUTO"
    UPLINK_PORT_FORWARD_ERROR_CORRECTION_AUTO = "AUTO"

    #: A constant which can be used with the uplink_port_forward_error_correction property of a CccInfrastructureNetworkConfiguration.
    #: This constant has a value of "FIRE_CODE_FEC"
    UPLINK_PORT_FORWARD_ERROR_CORRECTION_FIRE_CODE_FEC = "FIRE_CODE_FEC"

    #: A constant which can be used with the uplink_port_forward_error_correction property of a CccInfrastructureNetworkConfiguration.
    #: This constant has a value of "REED_SOLOMON_CONSORTIUM_16"
    UPLINK_PORT_FORWARD_ERROR_CORRECTION_REED_SOLOMON_CONSORTIUM_16 = "REED_SOLOMON_CONSORTIUM_16"

    #: A constant which can be used with the uplink_port_forward_error_correction property of a CccInfrastructureNetworkConfiguration.
    #: This constant has a value of "REED_SOLOMON_FEC"
    UPLINK_PORT_FORWARD_ERROR_CORRECTION_REED_SOLOMON_FEC = "REED_SOLOMON_FEC"

    #: A constant which can be used with the uplink_port_forward_error_correction property of a CccInfrastructureNetworkConfiguration.
    #: This constant has a value of "REED_SOLOMON_IEEE"
    UPLINK_PORT_FORWARD_ERROR_CORRECTION_REED_SOLOMON_IEEE = "REED_SOLOMON_IEEE"

    def __init__(self, **kwargs):
        """
        Initializes a new CccInfrastructureNetworkConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param management_nodes:
            The value to assign to the management_nodes property of this CccInfrastructureNetworkConfiguration.
        :type management_nodes: list[oci.compute_cloud_at_customer.models.CccInfrastructureManagementNode]

        :param uplink_port_speed_in_gbps:
            The value to assign to the uplink_port_speed_in_gbps property of this CccInfrastructureNetworkConfiguration.
        :type uplink_port_speed_in_gbps: int

        :param uplink_port_count:
            The value to assign to the uplink_port_count property of this CccInfrastructureNetworkConfiguration.
        :type uplink_port_count: int

        :param uplink_vlan_mtu:
            The value to assign to the uplink_vlan_mtu property of this CccInfrastructureNetworkConfiguration.
        :type uplink_vlan_mtu: int

        :param uplink_netmask:
            The value to assign to the uplink_netmask property of this CccInfrastructureNetworkConfiguration.
        :type uplink_netmask: str

        :param uplink_port_forward_error_correction:
            The value to assign to the uplink_port_forward_error_correction property of this CccInfrastructureNetworkConfiguration.
            Allowed values for this property are: "AUTO", "FIRE_CODE_FEC", "REED_SOLOMON_CONSORTIUM_16", "REED_SOLOMON_FEC", "REED_SOLOMON_IEEE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type uplink_port_forward_error_correction: str

        :param uplink_domain:
            The value to assign to the uplink_domain property of this CccInfrastructureNetworkConfiguration.
        :type uplink_domain: str

        :param uplink_gateway_ip:
            The value to assign to the uplink_gateway_ip property of this CccInfrastructureNetworkConfiguration.
        :type uplink_gateway_ip: str

        :param spine_ips:
            The value to assign to the spine_ips property of this CccInfrastructureNetworkConfiguration.
        :type spine_ips: list[str]

        :param spine_vip:
            The value to assign to the spine_vip property of this CccInfrastructureNetworkConfiguration.
        :type spine_vip: str

        :param mgmt_vip_hostname:
            The value to assign to the mgmt_vip_hostname property of this CccInfrastructureNetworkConfiguration.
        :type mgmt_vip_hostname: str

        :param mgmt_vip_ip:
            The value to assign to the mgmt_vip_ip property of this CccInfrastructureNetworkConfiguration.
        :type mgmt_vip_ip: str

        :param dns_ips:
            The value to assign to the dns_ips property of this CccInfrastructureNetworkConfiguration.
        :type dns_ips: list[str]

        :param infrastructure_routing_static:
            The value to assign to the infrastructure_routing_static property of this CccInfrastructureNetworkConfiguration.
        :type infrastructure_routing_static: oci.compute_cloud_at_customer.models.CccInfrastructureRoutingStaticDetails

        :param infrastructure_routing_dynamic:
            The value to assign to the infrastructure_routing_dynamic property of this CccInfrastructureNetworkConfiguration.
        :type infrastructure_routing_dynamic: oci.compute_cloud_at_customer.models.CccInfrastructureRoutingDynamicDetails

        """
        self.swagger_types = {
            'management_nodes': 'list[CccInfrastructureManagementNode]',
            'uplink_port_speed_in_gbps': 'int',
            'uplink_port_count': 'int',
            'uplink_vlan_mtu': 'int',
            'uplink_netmask': 'str',
            'uplink_port_forward_error_correction': 'str',
            'uplink_domain': 'str',
            'uplink_gateway_ip': 'str',
            'spine_ips': 'list[str]',
            'spine_vip': 'str',
            'mgmt_vip_hostname': 'str',
            'mgmt_vip_ip': 'str',
            'dns_ips': 'list[str]',
            'infrastructure_routing_static': 'CccInfrastructureRoutingStaticDetails',
            'infrastructure_routing_dynamic': 'CccInfrastructureRoutingDynamicDetails'
        }
        self.attribute_map = {
            'management_nodes': 'managementNodes',
            'uplink_port_speed_in_gbps': 'uplinkPortSpeedInGbps',
            'uplink_port_count': 'uplinkPortCount',
            'uplink_vlan_mtu': 'uplinkVlanMtu',
            'uplink_netmask': 'uplinkNetmask',
            'uplink_port_forward_error_correction': 'uplinkPortForwardErrorCorrection',
            'uplink_domain': 'uplinkDomain',
            'uplink_gateway_ip': 'uplinkGatewayIp',
            'spine_ips': 'spineIps',
            'spine_vip': 'spineVip',
            'mgmt_vip_hostname': 'mgmtVipHostname',
            'mgmt_vip_ip': 'mgmtVipIp',
            'dns_ips': 'dnsIps',
            'infrastructure_routing_static': 'infrastructureRoutingStatic',
            'infrastructure_routing_dynamic': 'infrastructureRoutingDynamic'
        }
        self._management_nodes = None
        self._uplink_port_speed_in_gbps = None
        self._uplink_port_count = None
        self._uplink_vlan_mtu = None
        self._uplink_netmask = None
        self._uplink_port_forward_error_correction = None
        self._uplink_domain = None
        self._uplink_gateway_ip = None
        self._spine_ips = None
        self._spine_vip = None
        self._mgmt_vip_hostname = None
        self._mgmt_vip_ip = None
        self._dns_ips = None
        self._infrastructure_routing_static = None
        self._infrastructure_routing_dynamic = None

    @property
    def management_nodes(self):
        """
        Gets the management_nodes of this CccInfrastructureNetworkConfiguration.
        Information about the management nodes that are provisioned in the Compute Cloud@Customer
        infrastructure.


        :return: The management_nodes of this CccInfrastructureNetworkConfiguration.
        :rtype: list[oci.compute_cloud_at_customer.models.CccInfrastructureManagementNode]
        """
        return self._management_nodes

    @management_nodes.setter
    def management_nodes(self, management_nodes):
        """
        Sets the management_nodes of this CccInfrastructureNetworkConfiguration.
        Information about the management nodes that are provisioned in the Compute Cloud@Customer
        infrastructure.


        :param management_nodes: The management_nodes of this CccInfrastructureNetworkConfiguration.
        :type: list[oci.compute_cloud_at_customer.models.CccInfrastructureManagementNode]
        """
        self._management_nodes = management_nodes

    @property
    def uplink_port_speed_in_gbps(self):
        """
        Gets the uplink_port_speed_in_gbps of this CccInfrastructureNetworkConfiguration.
        Uplink port speed defined in gigabytes per second.
        All uplink ports must have identical speed.


        :return: The uplink_port_speed_in_gbps of this CccInfrastructureNetworkConfiguration.
        :rtype: int
        """
        return self._uplink_port_speed_in_gbps

    @uplink_port_speed_in_gbps.setter
    def uplink_port_speed_in_gbps(self, uplink_port_speed_in_gbps):
        """
        Sets the uplink_port_speed_in_gbps of this CccInfrastructureNetworkConfiguration.
        Uplink port speed defined in gigabytes per second.
        All uplink ports must have identical speed.


        :param uplink_port_speed_in_gbps: The uplink_port_speed_in_gbps of this CccInfrastructureNetworkConfiguration.
        :type: int
        """
        self._uplink_port_speed_in_gbps = uplink_port_speed_in_gbps

    @property
    def uplink_port_count(self):
        """
        Gets the uplink_port_count of this CccInfrastructureNetworkConfiguration.
        Number of uplink ports per spine switch. Connectivity is identical on both spine switches.
        For example, if input is two 100 gigabyte ports; then port-1 and port-2 on both spines will be configured.


        :return: The uplink_port_count of this CccInfrastructureNetworkConfiguration.
        :rtype: int
        """
        return self._uplink_port_count

    @uplink_port_count.setter
    def uplink_port_count(self, uplink_port_count):
        """
        Sets the uplink_port_count of this CccInfrastructureNetworkConfiguration.
        Number of uplink ports per spine switch. Connectivity is identical on both spine switches.
        For example, if input is two 100 gigabyte ports; then port-1 and port-2 on both spines will be configured.


        :param uplink_port_count: The uplink_port_count of this CccInfrastructureNetworkConfiguration.
        :type: int
        """
        self._uplink_port_count = uplink_port_count

    @property
    def uplink_vlan_mtu(self):
        """
        Gets the uplink_vlan_mtu of this CccInfrastructureNetworkConfiguration.
        The virtual local area network (VLAN) maximum transmission unit (MTU) size
        for the uplink ports.


        :return: The uplink_vlan_mtu of this CccInfrastructureNetworkConfiguration.
        :rtype: int
        """
        return self._uplink_vlan_mtu

    @uplink_vlan_mtu.setter
    def uplink_vlan_mtu(self, uplink_vlan_mtu):
        """
        Sets the uplink_vlan_mtu of this CccInfrastructureNetworkConfiguration.
        The virtual local area network (VLAN) maximum transmission unit (MTU) size
        for the uplink ports.


        :param uplink_vlan_mtu: The uplink_vlan_mtu of this CccInfrastructureNetworkConfiguration.
        :type: int
        """
        self._uplink_vlan_mtu = uplink_vlan_mtu

    @property
    def uplink_netmask(self):
        """
        Gets the uplink_netmask of this CccInfrastructureNetworkConfiguration.
        Netmask of the subnet that the Compute Cloud@Customer infrastructure is
        connected to.


        :return: The uplink_netmask of this CccInfrastructureNetworkConfiguration.
        :rtype: str
        """
        return self._uplink_netmask

    @uplink_netmask.setter
    def uplink_netmask(self, uplink_netmask):
        """
        Sets the uplink_netmask of this CccInfrastructureNetworkConfiguration.
        Netmask of the subnet that the Compute Cloud@Customer infrastructure is
        connected to.


        :param uplink_netmask: The uplink_netmask of this CccInfrastructureNetworkConfiguration.
        :type: str
        """
        self._uplink_netmask = uplink_netmask

    @property
    def uplink_port_forward_error_correction(self):
        """
        Gets the uplink_port_forward_error_correction of this CccInfrastructureNetworkConfiguration.
        The port forward error correction (FEC) setting for the uplink port on the
        Compute Cloud@Customer infrastructure.

        Allowed values for this property are: "AUTO", "FIRE_CODE_FEC", "REED_SOLOMON_CONSORTIUM_16", "REED_SOLOMON_FEC", "REED_SOLOMON_IEEE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The uplink_port_forward_error_correction of this CccInfrastructureNetworkConfiguration.
        :rtype: str
        """
        return self._uplink_port_forward_error_correction

    @uplink_port_forward_error_correction.setter
    def uplink_port_forward_error_correction(self, uplink_port_forward_error_correction):
        """
        Sets the uplink_port_forward_error_correction of this CccInfrastructureNetworkConfiguration.
        The port forward error correction (FEC) setting for the uplink port on the
        Compute Cloud@Customer infrastructure.


        :param uplink_port_forward_error_correction: The uplink_port_forward_error_correction of this CccInfrastructureNetworkConfiguration.
        :type: str
        """
        allowed_values = ["AUTO", "FIRE_CODE_FEC", "REED_SOLOMON_CONSORTIUM_16", "REED_SOLOMON_FEC", "REED_SOLOMON_IEEE"]
        if not value_allowed_none_or_none_sentinel(uplink_port_forward_error_correction, allowed_values):
            uplink_port_forward_error_correction = 'UNKNOWN_ENUM_VALUE'
        self._uplink_port_forward_error_correction = uplink_port_forward_error_correction

    @property
    def uplink_domain(self):
        """
        Gets the uplink_domain of this CccInfrastructureNetworkConfiguration.
        Domain name to be used as the base domain for the internal network and by
        public facing services.


        :return: The uplink_domain of this CccInfrastructureNetworkConfiguration.
        :rtype: str
        """
        return self._uplink_domain

    @uplink_domain.setter
    def uplink_domain(self, uplink_domain):
        """
        Sets the uplink_domain of this CccInfrastructureNetworkConfiguration.
        Domain name to be used as the base domain for the internal network and by
        public facing services.


        :param uplink_domain: The uplink_domain of this CccInfrastructureNetworkConfiguration.
        :type: str
        """
        self._uplink_domain = uplink_domain

    @property
    def uplink_gateway_ip(self):
        """
        Gets the uplink_gateway_ip of this CccInfrastructureNetworkConfiguration.
        Uplink gateway in the datacenter network that the Compute Cloud@Customer
        connects to.


        :return: The uplink_gateway_ip of this CccInfrastructureNetworkConfiguration.
        :rtype: str
        """
        return self._uplink_gateway_ip

    @uplink_gateway_ip.setter
    def uplink_gateway_ip(self, uplink_gateway_ip):
        """
        Sets the uplink_gateway_ip of this CccInfrastructureNetworkConfiguration.
        Uplink gateway in the datacenter network that the Compute Cloud@Customer
        connects to.


        :param uplink_gateway_ip: The uplink_gateway_ip of this CccInfrastructureNetworkConfiguration.
        :type: str
        """
        self._uplink_gateway_ip = uplink_gateway_ip

    @property
    def spine_ips(self):
        """
        Gets the spine_ips of this CccInfrastructureNetworkConfiguration.
        Addresses of the network spine switches.


        :return: The spine_ips of this CccInfrastructureNetworkConfiguration.
        :rtype: list[str]
        """
        return self._spine_ips

    @spine_ips.setter
    def spine_ips(self, spine_ips):
        """
        Sets the spine_ips of this CccInfrastructureNetworkConfiguration.
        Addresses of the network spine switches.


        :param spine_ips: The spine_ips of this CccInfrastructureNetworkConfiguration.
        :type: list[str]
        """
        self._spine_ips = spine_ips

    @property
    def spine_vip(self):
        """
        Gets the spine_vip of this CccInfrastructureNetworkConfiguration.
        The spine switch public virtual IP (VIP). Traffic routed to the
        Compute Cloud@Customer infrastructure and
        and virtual cloud networks (VCNs) should have this address as next hop.


        :return: The spine_vip of this CccInfrastructureNetworkConfiguration.
        :rtype: str
        """
        return self._spine_vip

    @spine_vip.setter
    def spine_vip(self, spine_vip):
        """
        Sets the spine_vip of this CccInfrastructureNetworkConfiguration.
        The spine switch public virtual IP (VIP). Traffic routed to the
        Compute Cloud@Customer infrastructure and
        and virtual cloud networks (VCNs) should have this address as next hop.


        :param spine_vip: The spine_vip of this CccInfrastructureNetworkConfiguration.
        :type: str
        """
        self._spine_vip = spine_vip

    @property
    def mgmt_vip_hostname(self):
        """
        Gets the mgmt_vip_hostname of this CccInfrastructureNetworkConfiguration.
        The hostname corresponding to the virtual IP (VIP) address of the management nodes.


        :return: The mgmt_vip_hostname of this CccInfrastructureNetworkConfiguration.
        :rtype: str
        """
        return self._mgmt_vip_hostname

    @mgmt_vip_hostname.setter
    def mgmt_vip_hostname(self, mgmt_vip_hostname):
        """
        Sets the mgmt_vip_hostname of this CccInfrastructureNetworkConfiguration.
        The hostname corresponding to the virtual IP (VIP) address of the management nodes.


        :param mgmt_vip_hostname: The mgmt_vip_hostname of this CccInfrastructureNetworkConfiguration.
        :type: str
        """
        self._mgmt_vip_hostname = mgmt_vip_hostname

    @property
    def mgmt_vip_ip(self):
        """
        Gets the mgmt_vip_ip of this CccInfrastructureNetworkConfiguration.
        The IP address used as the virtual IP (VIP) address of the management nodes.


        :return: The mgmt_vip_ip of this CccInfrastructureNetworkConfiguration.
        :rtype: str
        """
        return self._mgmt_vip_ip

    @mgmt_vip_ip.setter
    def mgmt_vip_ip(self, mgmt_vip_ip):
        """
        Sets the mgmt_vip_ip of this CccInfrastructureNetworkConfiguration.
        The IP address used as the virtual IP (VIP) address of the management nodes.


        :param mgmt_vip_ip: The mgmt_vip_ip of this CccInfrastructureNetworkConfiguration.
        :type: str
        """
        self._mgmt_vip_ip = mgmt_vip_ip

    @property
    def dns_ips(self):
        """
        Gets the dns_ips of this CccInfrastructureNetworkConfiguration.
        The domain name system (DNS) addresses that the Compute Cloud@Customer infrastructure
        uses for the data center network.


        :return: The dns_ips of this CccInfrastructureNetworkConfiguration.
        :rtype: list[str]
        """
        return self._dns_ips

    @dns_ips.setter
    def dns_ips(self, dns_ips):
        """
        Sets the dns_ips of this CccInfrastructureNetworkConfiguration.
        The domain name system (DNS) addresses that the Compute Cloud@Customer infrastructure
        uses for the data center network.


        :param dns_ips: The dns_ips of this CccInfrastructureNetworkConfiguration.
        :type: list[str]
        """
        self._dns_ips = dns_ips

    @property
    def infrastructure_routing_static(self):
        """
        Gets the infrastructure_routing_static of this CccInfrastructureNetworkConfiguration.

        :return: The infrastructure_routing_static of this CccInfrastructureNetworkConfiguration.
        :rtype: oci.compute_cloud_at_customer.models.CccInfrastructureRoutingStaticDetails
        """
        return self._infrastructure_routing_static

    @infrastructure_routing_static.setter
    def infrastructure_routing_static(self, infrastructure_routing_static):
        """
        Sets the infrastructure_routing_static of this CccInfrastructureNetworkConfiguration.

        :param infrastructure_routing_static: The infrastructure_routing_static of this CccInfrastructureNetworkConfiguration.
        :type: oci.compute_cloud_at_customer.models.CccInfrastructureRoutingStaticDetails
        """
        self._infrastructure_routing_static = infrastructure_routing_static

    @property
    def infrastructure_routing_dynamic(self):
        """
        Gets the infrastructure_routing_dynamic of this CccInfrastructureNetworkConfiguration.

        :return: The infrastructure_routing_dynamic of this CccInfrastructureNetworkConfiguration.
        :rtype: oci.compute_cloud_at_customer.models.CccInfrastructureRoutingDynamicDetails
        """
        return self._infrastructure_routing_dynamic

    @infrastructure_routing_dynamic.setter
    def infrastructure_routing_dynamic(self, infrastructure_routing_dynamic):
        """
        Sets the infrastructure_routing_dynamic of this CccInfrastructureNetworkConfiguration.

        :param infrastructure_routing_dynamic: The infrastructure_routing_dynamic of this CccInfrastructureNetworkConfiguration.
        :type: oci.compute_cloud_at_customer.models.CccInfrastructureRoutingDynamicDetails
        """
        self._infrastructure_routing_dynamic = infrastructure_routing_dynamic

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
