# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApplicationComponent(object):
    """
    Reference to an application component
    """

    #: A constant which can be used with the type property of a ApplicationComponent.
    #: This constant has a value of "DATA_SCIENCE_PIPELINE"
    TYPE_DATA_SCIENCE_PIPELINE = "DATA_SCIENCE_PIPELINE"

    #: A constant which can be used with the type property of a ApplicationComponent.
    #: This constant has a value of "DATA_SCIENCE_JOB"
    TYPE_DATA_SCIENCE_JOB = "DATA_SCIENCE_JOB"

    #: A constant which can be used with the type property of a ApplicationComponent.
    #: This constant has a value of "DATA_SCIENCE_MODEL"
    TYPE_DATA_SCIENCE_MODEL = "DATA_SCIENCE_MODEL"

    #: A constant which can be used with the type property of a ApplicationComponent.
    #: This constant has a value of "DATA_FLOW_APPLICATION"
    TYPE_DATA_FLOW_APPLICATION = "DATA_FLOW_APPLICATION"

    #: A constant which can be used with the type property of a ApplicationComponent.
    #: This constant has a value of "GENERIC_OCI_RESOURCE"
    TYPE_GENERIC_OCI_RESOURCE = "GENERIC_OCI_RESOURCE"

    def __init__(self, **kwargs):
        """
        Initializes a new ApplicationComponent object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.data_science.models.DataScienceJobApplicationComponent`
        * :class:`~oci.data_science.models.DataFlowApplicationApplicationComponent`
        * :class:`~oci.data_science.models.GenericOciResourceApplicationComponent`
        * :class:`~oci.data_science.models.DataSciencePipelineApplicationComponent`
        * :class:`~oci.data_science.models.DataScienceModelApplicationComponent`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ApplicationComponent.
            Allowed values for this property are: "DATA_SCIENCE_PIPELINE", "DATA_SCIENCE_JOB", "DATA_SCIENCE_MODEL", "DATA_FLOW_APPLICATION", "GENERIC_OCI_RESOURCE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param name:
            The value to assign to the name property of this ApplicationComponent.
        :type name: str

        :param component_name:
            The value to assign to the component_name property of this ApplicationComponent.
        :type component_name: str

        """
        self.swagger_types = {
            'type': 'str',
            'name': 'str',
            'component_name': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'name': 'name',
            'component_name': 'componentName'
        }
        self._type = None
        self._name = None
        self._component_name = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'DATA_SCIENCE_JOB':
            return 'DataScienceJobApplicationComponent'

        if type == 'DATA_FLOW_APPLICATION':
            return 'DataFlowApplicationApplicationComponent'

        if type == 'GENERIC_OCI_RESOURCE':
            return 'GenericOciResourceApplicationComponent'

        if type == 'DATA_SCIENCE_PIPELINE':
            return 'DataSciencePipelineApplicationComponent'

        if type == 'DATA_SCIENCE_MODEL':
            return 'DataScienceModelApplicationComponent'
        else:
            return 'ApplicationComponent'

    @property
    def type(self):
        """
        **[Required]** Gets the type of this ApplicationComponent.
        Type of application component

        Allowed values for this property are: "DATA_SCIENCE_PIPELINE", "DATA_SCIENCE_JOB", "DATA_SCIENCE_MODEL", "DATA_FLOW_APPLICATION", "GENERIC_OCI_RESOURCE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this ApplicationComponent.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ApplicationComponent.
        Type of application component


        :param type: The type of this ApplicationComponent.
        :type: str
        """
        allowed_values = ["DATA_SCIENCE_PIPELINE", "DATA_SCIENCE_JOB", "DATA_SCIENCE_MODEL", "DATA_FLOW_APPLICATION", "GENERIC_OCI_RESOURCE"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def name(self):
        """
        Gets the name of this ApplicationComponent.
        Name of referenced resource (generally resources do not have to have any name but most resources have name exposed as 'name' or 'displayName' field).


        :return: The name of this ApplicationComponent.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ApplicationComponent.
        Name of referenced resource (generally resources do not have to have any name but most resources have name exposed as 'name' or 'displayName' field).


        :param name: The name of this ApplicationComponent.
        :type: str
        """
        self._name = name

    @property
    def component_name(self):
        """
        **[Required]** Gets the component_name of this ApplicationComponent.
        Name of application component


        :return: The component_name of this ApplicationComponent.
        :rtype: str
        """
        return self._component_name

    @component_name.setter
    def component_name(self, component_name):
        """
        Sets the component_name of this ApplicationComponent.
        Name of application component


        :param component_name: The component_name of this ApplicationComponent.
        :type: str
        """
        self._component_name = component_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
