# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModelGroupCloneSourceDetails(object):
    """
    Model Group clone source details.
    """

    #: A constant which can be used with the model_group_clone_source_type property of a ModelGroupCloneSourceDetails.
    #: This constant has a value of "MODEL_GROUP"
    MODEL_GROUP_CLONE_SOURCE_TYPE_MODEL_GROUP = "MODEL_GROUP"

    #: A constant which can be used with the model_group_clone_source_type property of a ModelGroupCloneSourceDetails.
    #: This constant has a value of "MODEL_GROUP_VERSION_HISTORY"
    MODEL_GROUP_CLONE_SOURCE_TYPE_MODEL_GROUP_VERSION_HISTORY = "MODEL_GROUP_VERSION_HISTORY"

    def __init__(self, **kwargs):
        """
        Initializes a new ModelGroupCloneSourceDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.data_science.models.CloneCreateFromModelGroupVersionHistoryDetails`
        * :class:`~oci.data_science.models.CloneCreateFromModelGroupDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_group_clone_source_type:
            The value to assign to the model_group_clone_source_type property of this ModelGroupCloneSourceDetails.
            Allowed values for this property are: "MODEL_GROUP", "MODEL_GROUP_VERSION_HISTORY"
        :type model_group_clone_source_type: str

        """
        self.swagger_types = {
            'model_group_clone_source_type': 'str'
        }
        self.attribute_map = {
            'model_group_clone_source_type': 'modelGroupCloneSourceType'
        }
        self._model_group_clone_source_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['modelGroupCloneSourceType']

        if type == 'MODEL_GROUP_VERSION_HISTORY':
            return 'CloneCreateFromModelGroupVersionHistoryDetails'

        if type == 'MODEL_GROUP':
            return 'CloneCreateFromModelGroupDetails'
        else:
            return 'ModelGroupCloneSourceDetails'

    @property
    def model_group_clone_source_type(self):
        """
        **[Required]** Gets the model_group_clone_source_type of this ModelGroupCloneSourceDetails.
        Source resource for model group clone operation.

        Allowed values for this property are: "MODEL_GROUP", "MODEL_GROUP_VERSION_HISTORY"


        :return: The model_group_clone_source_type of this ModelGroupCloneSourceDetails.
        :rtype: str
        """
        return self._model_group_clone_source_type

    @model_group_clone_source_type.setter
    def model_group_clone_source_type(self, model_group_clone_source_type):
        """
        Sets the model_group_clone_source_type of this ModelGroupCloneSourceDetails.
        Source resource for model group clone operation.


        :param model_group_clone_source_type: The model_group_clone_source_type of this ModelGroupCloneSourceDetails.
        :type: str
        """
        allowed_values = ["MODEL_GROUP", "MODEL_GROUP_VERSION_HISTORY"]
        if not value_allowed_none_or_none_sentinel(model_group_clone_source_type, allowed_values):
            raise ValueError(
                f"Invalid value for `model_group_clone_source_type`, must be None or one of {allowed_values}"
            )
        self._model_group_clone_source_type = model_group_clone_source_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
