# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ModelGroupConfigurationDetails(object):
    """
    The model group configuration details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ModelGroupConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_group_id:
            The value to assign to the model_group_id property of this ModelGroupConfigurationDetails.
        :type model_group_id: str

        """
        self.swagger_types = {
            'model_group_id': 'str'
        }
        self.attribute_map = {
            'model_group_id': 'modelGroupId'
        }
        self._model_group_id = None

    @property
    def model_group_id(self):
        """
        **[Required]** Gets the model_group_id of this ModelGroupConfigurationDetails.
        The `OCID`__ of the model group you want to deploy.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The model_group_id of this ModelGroupConfigurationDetails.
        :rtype: str
        """
        return self._model_group_id

    @model_group_id.setter
    def model_group_id(self, model_group_id):
        """
        Sets the model_group_id of this ModelGroupConfigurationDetails.
        The `OCID`__ of the model group you want to deploy.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param model_group_id: The model_group_id of this ModelGroupConfigurationDetails.
        :type: str
        """
        self._model_group_id = model_group_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
