# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .create_database_base import CreateDatabaseBase
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateStandByDatabaseDetails(CreateDatabaseBase):
    """
    Details for creating a new standby database.

    **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateStandByDatabaseDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database.models.CreateStandByDatabaseDetails.source` attribute
        of this class is ``DATAGUARD`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param db_home_id:
            The value to assign to the db_home_id property of this CreateStandByDatabaseDetails.
        :type db_home_id: str

        :param db_version:
            The value to assign to the db_version property of this CreateStandByDatabaseDetails.
        :type db_version: str

        :param source:
            The value to assign to the source property of this CreateStandByDatabaseDetails.
            Allowed values for this property are: "NONE", "DB_BACKUP", "DATAGUARD"
        :type source: str

        :param kms_key_id:
            The value to assign to the kms_key_id property of this CreateStandByDatabaseDetails.
        :type kms_key_id: str

        :param kms_key_version_id:
            The value to assign to the kms_key_version_id property of this CreateStandByDatabaseDetails.
        :type kms_key_version_id: str

        :param database:
            The value to assign to the database property of this CreateStandByDatabaseDetails.
        :type database: oci.database.models.CreateStandbyDetails

        """
        self.swagger_types = {
            'db_home_id': 'str',
            'db_version': 'str',
            'source': 'str',
            'kms_key_id': 'str',
            'kms_key_version_id': 'str',
            'database': 'CreateStandbyDetails'
        }
        self.attribute_map = {
            'db_home_id': 'dbHomeId',
            'db_version': 'dbVersion',
            'source': 'source',
            'kms_key_id': 'kmsKeyId',
            'kms_key_version_id': 'kmsKeyVersionId',
            'database': 'database'
        }
        self._db_home_id = None
        self._db_version = None
        self._source = None
        self._kms_key_id = None
        self._kms_key_version_id = None
        self._database = None
        self._source = 'DATAGUARD'

    @property
    def database(self):
        """
        **[Required]** Gets the database of this CreateStandByDatabaseDetails.

        :return: The database of this CreateStandByDatabaseDetails.
        :rtype: oci.database.models.CreateStandbyDetails
        """
        return self._database

    @database.setter
    def database(self, database):
        """
        Sets the database of this CreateStandByDatabaseDetails.

        :param database: The database of this CreateStandByDatabaseDetails.
        :type: oci.database.models.CreateStandbyDetails
        """
        self._database = database

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
