# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbnodeSnapshots(object):
    """
    Details of the Database Node Snapshot.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DbnodeSnapshots object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this DbnodeSnapshots.
        :type name: str

        :param snapshots:
            The value to assign to the snapshots property of this DbnodeSnapshots.
        :type snapshots: list[oci.database.models.DbnodeSnapshot]

        """
        self.swagger_types = {
            'name': 'str',
            'snapshots': 'list[DbnodeSnapshot]'
        }
        self.attribute_map = {
            'name': 'name',
            'snapshots': 'snapshots'
        }
        self._name = None
        self._snapshots = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this DbnodeSnapshots.
        The user-friendly name for the Database Node Snapshot. The name should be unique.


        :return: The name of this DbnodeSnapshots.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DbnodeSnapshots.
        The user-friendly name for the Database Node Snapshot. The name should be unique.


        :param name: The name of this DbnodeSnapshots.
        :type: str
        """
        self._name = name

    @property
    def snapshots(self):
        """
        Gets the snapshots of this DbnodeSnapshots.
        The `OCID`__ of the Exadata Database Node.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The snapshots of this DbnodeSnapshots.
        :rtype: list[oci.database.models.DbnodeSnapshot]
        """
        return self._snapshots

    @snapshots.setter
    def snapshots(self, snapshots):
        """
        Sets the snapshots of this DbnodeSnapshots.
        The `OCID`__ of the Exadata Database Node.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param snapshots: The snapshots of this DbnodeSnapshots.
        :type: list[oci.database.models.DbnodeSnapshot]
        """
        self._snapshots = snapshots

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
