# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RemoveVirtualMachineFromExadbVmClusterDetails(object):
    """
    Details of removing Virtual Machines from the Exadata VM cluster on Exascale Infrastructure. Applies to Exadata Database Service on Exascale Infrastructure only.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RemoveVirtualMachineFromExadbVmClusterDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param db_nodes:
            The value to assign to the db_nodes property of this RemoveVirtualMachineFromExadbVmClusterDetails.
        :type db_nodes: list[oci.database.models.DbNodeDetails]

        """
        self.swagger_types = {
            'db_nodes': 'list[DbNodeDetails]'
        }
        self.attribute_map = {
            'db_nodes': 'dbNodes'
        }
        self._db_nodes = None

    @property
    def db_nodes(self):
        """
        **[Required]** Gets the db_nodes of this RemoveVirtualMachineFromExadbVmClusterDetails.
        The list of ExaCS DB nodes for the Exadata VM cluster on Exascale Infrastructure to be removed.


        :return: The db_nodes of this RemoveVirtualMachineFromExadbVmClusterDetails.
        :rtype: list[oci.database.models.DbNodeDetails]
        """
        return self._db_nodes

    @db_nodes.setter
    def db_nodes(self, db_nodes):
        """
        Sets the db_nodes of this RemoveVirtualMachineFromExadbVmClusterDetails.
        The list of ExaCS DB nodes for the Exadata VM cluster on Exascale Infrastructure to be removed.


        :param db_nodes: The db_nodes of this RemoveVirtualMachineFromExadbVmClusterDetails.
        :type: list[oci.database.models.DbNodeDetails]
        """
        self._db_nodes = db_nodes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
