# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DataguardPerformanceMetrics(object):
    """
    A summary of Data Guard performance metrics for Managed Databases.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DataguardPerformanceMetrics object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metrics_data:
            The value to assign to the metrics_data property of this DataguardPerformanceMetrics.
        :type metrics_data: list[oci.database_management.models.PerformanceMetricsData]

        """
        self.swagger_types = {
            'metrics_data': 'list[PerformanceMetricsData]'
        }
        self.attribute_map = {
            'metrics_data': 'metricsData'
        }
        self._metrics_data = None

    @property
    def metrics_data(self):
        """
        **[Required]** Gets the metrics_data of this DataguardPerformanceMetrics.
        A summary of Data Guard performance metrics such as ApplyLag, TransportLag and RedoApplyRate, for Managed Databases.


        :return: The metrics_data of this DataguardPerformanceMetrics.
        :rtype: list[oci.database_management.models.PerformanceMetricsData]
        """
        return self._metrics_data

    @metrics_data.setter
    def metrics_data(self, metrics_data):
        """
        Sets the metrics_data of this DataguardPerformanceMetrics.
        A summary of Data Guard performance metrics such as ApplyLag, TransportLag and RedoApplyRate, for Managed Databases.


        :param metrics_data: The metrics_data of this DataguardPerformanceMetrics.
        :type: list[oci.database_management.models.PerformanceMetricsData]
        """
        self._metrics_data = metrics_data

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
