# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HeatWaveFleetSummary(object):
    """
    The inventory count of HeatWave clusters in the fleet and a summary of the metrics that provide the aggregated usage of CPU, storage, and so on of all the clusters.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HeatWaveFleetSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param aggregated_metrics:
            The value to assign to the aggregated_metrics property of this HeatWaveFleetSummary.
        :type aggregated_metrics: list[oci.database_management.models.HeatWaveFleetMetricSummaryDefinition]

        :param inventory:
            The value to assign to the inventory property of this HeatWaveFleetSummary.
        :type inventory: list[oci.database_management.models.HeatWaveFleetByCategory]

        """
        self.swagger_types = {
            'aggregated_metrics': 'list[HeatWaveFleetMetricSummaryDefinition]',
            'inventory': 'list[HeatWaveFleetByCategory]'
        }
        self.attribute_map = {
            'aggregated_metrics': 'aggregatedMetrics',
            'inventory': 'inventory'
        }
        self._aggregated_metrics = None
        self._inventory = None

    @property
    def aggregated_metrics(self):
        """
        **[Required]** Gets the aggregated_metrics of this HeatWaveFleetSummary.
        The usage metrics for the HeatWave clusters in the fleet.


        :return: The aggregated_metrics of this HeatWaveFleetSummary.
        :rtype: list[oci.database_management.models.HeatWaveFleetMetricSummaryDefinition]
        """
        return self._aggregated_metrics

    @aggregated_metrics.setter
    def aggregated_metrics(self, aggregated_metrics):
        """
        Sets the aggregated_metrics of this HeatWaveFleetSummary.
        The usage metrics for the HeatWave clusters in the fleet.


        :param aggregated_metrics: The aggregated_metrics of this HeatWaveFleetSummary.
        :type: list[oci.database_management.models.HeatWaveFleetMetricSummaryDefinition]
        """
        self._aggregated_metrics = aggregated_metrics

    @property
    def inventory(self):
        """
        **[Required]** Gets the inventory of this HeatWaveFleetSummary.
        The number of HeatWave clusters in the fleet, grouped by cluster type or other properties.


        :return: The inventory of this HeatWaveFleetSummary.
        :rtype: list[oci.database_management.models.HeatWaveFleetByCategory]
        """
        return self._inventory

    @inventory.setter
    def inventory(self, inventory):
        """
        Sets the inventory of this HeatWaveFleetSummary.
        The number of HeatWave clusters in the fleet, grouped by cluster type or other properties.


        :param inventory: The inventory of this HeatWaveFleetSummary.
        :type: list[oci.database_management.models.HeatWaveFleetByCategory]
        """
        self._inventory = inventory

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
