# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManagedMySqlDatabaseBinaryLogInformation(object):
    """
    Information pertaining to the binary logs of a MySQL server.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ManagedMySqlDatabaseBinaryLogInformation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param binary_logging:
            The value to assign to the binary_logging property of this ManagedMySqlDatabaseBinaryLogInformation.
        :type binary_logging: str

        :param binary_log_format:
            The value to assign to the binary_log_format property of this ManagedMySqlDatabaseBinaryLogInformation.
        :type binary_log_format: str

        :param binary_log_compression:
            The value to assign to the binary_log_compression property of this ManagedMySqlDatabaseBinaryLogInformation.
        :type binary_log_compression: str

        :param binary_log_compression_percent:
            The value to assign to the binary_log_compression_percent property of this ManagedMySqlDatabaseBinaryLogInformation.
        :type binary_log_compression_percent: int

        :param binary_log_name:
            The value to assign to the binary_log_name property of this ManagedMySqlDatabaseBinaryLogInformation.
        :type binary_log_name: str

        :param binary_log_position:
            The value to assign to the binary_log_position property of this ManagedMySqlDatabaseBinaryLogInformation.
        :type binary_log_position: int

        """
        self.swagger_types = {
            'binary_logging': 'str',
            'binary_log_format': 'str',
            'binary_log_compression': 'str',
            'binary_log_compression_percent': 'int',
            'binary_log_name': 'str',
            'binary_log_position': 'int'
        }
        self.attribute_map = {
            'binary_logging': 'binaryLogging',
            'binary_log_format': 'binaryLogFormat',
            'binary_log_compression': 'binaryLogCompression',
            'binary_log_compression_percent': 'binaryLogCompressionPercent',
            'binary_log_name': 'binaryLogName',
            'binary_log_position': 'binaryLogPosition'
        }
        self._binary_logging = None
        self._binary_log_format = None
        self._binary_log_compression = None
        self._binary_log_compression_percent = None
        self._binary_log_name = None
        self._binary_log_position = None

    @property
    def binary_logging(self):
        """
        **[Required]** Gets the binary_logging of this ManagedMySqlDatabaseBinaryLogInformation.
        The status of binary logging on the MySQL server.


        :return: The binary_logging of this ManagedMySqlDatabaseBinaryLogInformation.
        :rtype: str
        """
        return self._binary_logging

    @binary_logging.setter
    def binary_logging(self, binary_logging):
        """
        Sets the binary_logging of this ManagedMySqlDatabaseBinaryLogInformation.
        The status of binary logging on the MySQL server.


        :param binary_logging: The binary_logging of this ManagedMySqlDatabaseBinaryLogInformation.
        :type: str
        """
        self._binary_logging = binary_logging

    @property
    def binary_log_format(self):
        """
        Gets the binary_log_format of this ManagedMySqlDatabaseBinaryLogInformation.
        The binary logging format used by the MySQL server.


        :return: The binary_log_format of this ManagedMySqlDatabaseBinaryLogInformation.
        :rtype: str
        """
        return self._binary_log_format

    @binary_log_format.setter
    def binary_log_format(self, binary_log_format):
        """
        Sets the binary_log_format of this ManagedMySqlDatabaseBinaryLogInformation.
        The binary logging format used by the MySQL server.


        :param binary_log_format: The binary_log_format of this ManagedMySqlDatabaseBinaryLogInformation.
        :type: str
        """
        self._binary_log_format = binary_log_format

    @property
    def binary_log_compression(self):
        """
        Gets the binary_log_compression of this ManagedMySqlDatabaseBinaryLogInformation.
        Indicates whether compression is enabled for transactions written to binary log files on the MySQL server.


        :return: The binary_log_compression of this ManagedMySqlDatabaseBinaryLogInformation.
        :rtype: str
        """
        return self._binary_log_compression

    @binary_log_compression.setter
    def binary_log_compression(self, binary_log_compression):
        """
        Sets the binary_log_compression of this ManagedMySqlDatabaseBinaryLogInformation.
        Indicates whether compression is enabled for transactions written to binary log files on the MySQL server.


        :param binary_log_compression: The binary_log_compression of this ManagedMySqlDatabaseBinaryLogInformation.
        :type: str
        """
        self._binary_log_compression = binary_log_compression

    @property
    def binary_log_compression_percent(self):
        """
        Gets the binary_log_compression_percent of this ManagedMySqlDatabaseBinaryLogInformation.
        The compression ratio for the binary log, expressed as a percentage.


        :return: The binary_log_compression_percent of this ManagedMySqlDatabaseBinaryLogInformation.
        :rtype: int
        """
        return self._binary_log_compression_percent

    @binary_log_compression_percent.setter
    def binary_log_compression_percent(self, binary_log_compression_percent):
        """
        Sets the binary_log_compression_percent of this ManagedMySqlDatabaseBinaryLogInformation.
        The compression ratio for the binary log, expressed as a percentage.


        :param binary_log_compression_percent: The binary_log_compression_percent of this ManagedMySqlDatabaseBinaryLogInformation.
        :type: int
        """
        self._binary_log_compression_percent = binary_log_compression_percent

    @property
    def binary_log_name(self):
        """
        Gets the binary_log_name of this ManagedMySqlDatabaseBinaryLogInformation.
        The name of the binary log file.


        :return: The binary_log_name of this ManagedMySqlDatabaseBinaryLogInformation.
        :rtype: str
        """
        return self._binary_log_name

    @binary_log_name.setter
    def binary_log_name(self, binary_log_name):
        """
        Sets the binary_log_name of this ManagedMySqlDatabaseBinaryLogInformation.
        The name of the binary log file.


        :param binary_log_name: The binary_log_name of this ManagedMySqlDatabaseBinaryLogInformation.
        :type: str
        """
        self._binary_log_name = binary_log_name

    @property
    def binary_log_position(self):
        """
        Gets the binary_log_position of this ManagedMySqlDatabaseBinaryLogInformation.
        The position within the binary log file.


        :return: The binary_log_position of this ManagedMySqlDatabaseBinaryLogInformation.
        :rtype: int
        """
        return self._binary_log_position

    @binary_log_position.setter
    def binary_log_position(self, binary_log_position):
        """
        Sets the binary_log_position of this ManagedMySqlDatabaseBinaryLogInformation.
        The position within the binary log file.


        :param binary_log_position: The binary_log_position of this ManagedMySqlDatabaseBinaryLogInformation.
        :type: int
        """
        self._binary_log_position = binary_log_position

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
