# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GgcsUpdateDetail(object):
    """
    Details required to update the existing GGCS instance.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GgcsUpdateDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this GgcsUpdateDetail.
        :type instance_id: str

        :param ocpu:
            The value to assign to the ocpu property of this GgcsUpdateDetail.
        :type ocpu: int

        :param public_subnet_id:
            The value to assign to the public_subnet_id property of this GgcsUpdateDetail.
        :type public_subnet_id: str

        :param connections:
            The value to assign to the connections property of this GgcsUpdateDetail.
        :type connections: list[oci.dif.models.GgcsConnectionDetails]

        """
        self.swagger_types = {
            'instance_id': 'str',
            'ocpu': 'int',
            'public_subnet_id': 'str',
            'connections': 'list[GgcsConnectionDetails]'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'ocpu': 'ocpu',
            'public_subnet_id': 'publicSubnetId',
            'connections': 'connections'
        }
        self._instance_id = None
        self._ocpu = None
        self._public_subnet_id = None
        self._connections = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this GgcsUpdateDetail.
        Instance id of the existing GGCS instance to be updated.


        :return: The instance_id of this GgcsUpdateDetail.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this GgcsUpdateDetail.
        Instance id of the existing GGCS instance to be updated.


        :param instance_id: The instance_id of this GgcsUpdateDetail.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def ocpu(self):
        """
        Gets the ocpu of this GgcsUpdateDetail.
        The Minimum number of OCPUs to be made available for this Deployment.


        :return: The ocpu of this GgcsUpdateDetail.
        :rtype: int
        """
        return self._ocpu

    @ocpu.setter
    def ocpu(self, ocpu):
        """
        Sets the ocpu of this GgcsUpdateDetail.
        The Minimum number of OCPUs to be made available for this Deployment.


        :param ocpu: The ocpu of this GgcsUpdateDetail.
        :type: int
        """
        self._ocpu = ocpu

    @property
    def public_subnet_id(self):
        """
        Gets the public_subnet_id of this GgcsUpdateDetail.
        The OCID of a public subnet in the customer tenancy. Can be provided only for public GGCS deployments.


        :return: The public_subnet_id of this GgcsUpdateDetail.
        :rtype: str
        """
        return self._public_subnet_id

    @public_subnet_id.setter
    def public_subnet_id(self, public_subnet_id):
        """
        Sets the public_subnet_id of this GgcsUpdateDetail.
        The OCID of a public subnet in the customer tenancy. Can be provided only for public GGCS deployments.


        :param public_subnet_id: The public_subnet_id of this GgcsUpdateDetail.
        :type: str
        """
        self._public_subnet_id = public_subnet_id

    @property
    def connections(self):
        """
        Gets the connections of this GgcsUpdateDetail.
        Connection details to be associated with the Goldengate deployment.


        :return: The connections of this GgcsUpdateDetail.
        :rtype: list[oci.dif.models.GgcsConnectionDetails]
        """
        return self._connections

    @connections.setter
    def connections(self, connections):
        """
        Sets the connections of this GgcsUpdateDetail.
        Connection details to be associated with the Goldengate deployment.


        :param connections: The connections of this GgcsUpdateDetail.
        :type: list[oci.dif.models.GgcsConnectionDetails]
        """
        self._connections = connections

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
