# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ActionGroup(object):
    """
    Action Group.
    """

    #: A constant which can be used with the kind property of a ActionGroup.
    #: This constant has a value of "FLEET_USING_RUNBOOK"
    KIND_FLEET_USING_RUNBOOK = "FLEET_USING_RUNBOOK"

    def __init__(self, **kwargs):
        """
        Initializes a new ActionGroup object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.FleetBasedActionGroup`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this ActionGroup.
        :type display_name: str

        :param kind:
            The value to assign to the kind property of this ActionGroup.
            Allowed values for this property are: "FLEET_USING_RUNBOOK", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type kind: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'kind': 'str'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'kind': 'kind'
        }
        self._display_name = None
        self._kind = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['kind']

        if type == 'FLEET_USING_RUNBOOK':
            return 'FleetBasedActionGroup'
        else:
            return 'ActionGroup'

    @property
    def display_name(self):
        """
        Gets the display_name of this ActionGroup.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this ActionGroup.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ActionGroup.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this ActionGroup.
        :type: str
        """
        self._display_name = display_name

    @property
    def kind(self):
        """
        **[Required]** Gets the kind of this ActionGroup.
        Action Group kind

        Allowed values for this property are: "FLEET_USING_RUNBOOK", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The kind of this ActionGroup.
        :rtype: str
        """
        return self._kind

    @kind.setter
    def kind(self, kind):
        """
        Sets the kind of this ActionGroup.
        Action Group kind


        :param kind: The kind of this ActionGroup.
        :type: str
        """
        allowed_values = ["FLEET_USING_RUNBOOK"]
        if not value_allowed_none_or_none_sentinel(kind, allowed_values):
            kind = 'UNKNOWN_ENUM_VALUE'
        self._kind = kind

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
