# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreatePropertyDetails(object):
    """
    The information about new Property.
    """

    #: A constant which can be used with the selection property of a CreatePropertyDetails.
    #: This constant has a value of "SINGLE_CHOICE"
    SELECTION_SINGLE_CHOICE = "SINGLE_CHOICE"

    #: A constant which can be used with the selection property of a CreatePropertyDetails.
    #: This constant has a value of "MULTI_CHOICE"
    SELECTION_MULTI_CHOICE = "MULTI_CHOICE"

    #: A constant which can be used with the selection property of a CreatePropertyDetails.
    #: This constant has a value of "DEFAULT_TEXT"
    SELECTION_DEFAULT_TEXT = "DEFAULT_TEXT"

    #: A constant which can be used with the value_type property of a CreatePropertyDetails.
    #: This constant has a value of "STRING"
    VALUE_TYPE_STRING = "STRING"

    #: A constant which can be used with the value_type property of a CreatePropertyDetails.
    #: This constant has a value of "NUMERIC"
    VALUE_TYPE_NUMERIC = "NUMERIC"

    def __init__(self, **kwargs):
        """
        Initializes a new CreatePropertyDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreatePropertyDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreatePropertyDetails.
        :type display_name: str

        :param selection:
            The value to assign to the selection property of this CreatePropertyDetails.
            Allowed values for this property are: "SINGLE_CHOICE", "MULTI_CHOICE", "DEFAULT_TEXT"
        :type selection: str

        :param value_type:
            The value to assign to the value_type property of this CreatePropertyDetails.
            Allowed values for this property are: "STRING", "NUMERIC"
        :type value_type: str

        :param values:
            The value to assign to the values property of this CreatePropertyDetails.
        :type values: list[str]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreatePropertyDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreatePropertyDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'selection': 'str',
            'value_type': 'str',
            'values': 'list[str]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'selection': 'selection',
            'value_type': 'valueType',
            'values': 'values',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._display_name = None
        self._selection = None
        self._value_type = None
        self._values = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreatePropertyDetails.
        Compartment OCID


        :return: The compartment_id of this CreatePropertyDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreatePropertyDetails.
        Compartment OCID


        :param compartment_id: The compartment_id of this CreatePropertyDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreatePropertyDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this CreatePropertyDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreatePropertyDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this CreatePropertyDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def selection(self):
        """
        **[Required]** Gets the selection of this CreatePropertyDetails.
        Text selection of the property.

        Allowed values for this property are: "SINGLE_CHOICE", "MULTI_CHOICE", "DEFAULT_TEXT"


        :return: The selection of this CreatePropertyDetails.
        :rtype: str
        """
        return self._selection

    @selection.setter
    def selection(self, selection):
        """
        Sets the selection of this CreatePropertyDetails.
        Text selection of the property.


        :param selection: The selection of this CreatePropertyDetails.
        :type: str
        """
        allowed_values = ["SINGLE_CHOICE", "MULTI_CHOICE", "DEFAULT_TEXT"]
        if not value_allowed_none_or_none_sentinel(selection, allowed_values):
            raise ValueError(
                f"Invalid value for `selection`, must be None or one of {allowed_values}"
            )
        self._selection = selection

    @property
    def value_type(self):
        """
        **[Required]** Gets the value_type of this CreatePropertyDetails.
        Format of the value.

        Allowed values for this property are: "STRING", "NUMERIC"


        :return: The value_type of this CreatePropertyDetails.
        :rtype: str
        """
        return self._value_type

    @value_type.setter
    def value_type(self, value_type):
        """
        Sets the value_type of this CreatePropertyDetails.
        Format of the value.


        :param value_type: The value_type of this CreatePropertyDetails.
        :type: str
        """
        allowed_values = ["STRING", "NUMERIC"]
        if not value_allowed_none_or_none_sentinel(value_type, allowed_values):
            raise ValueError(
                f"Invalid value for `value_type`, must be None or one of {allowed_values}"
            )
        self._value_type = value_type

    @property
    def values(self):
        """
        Gets the values of this CreatePropertyDetails.
        Values of the property (must be a single value if selection = 'SINGLE_CHOICE').


        :return: The values of this CreatePropertyDetails.
        :rtype: list[str]
        """
        return self._values

    @values.setter
    def values(self, values):
        """
        Sets the values of this CreatePropertyDetails.
        Values of the property (must be a single value if selection = 'SINGLE_CHOICE').


        :param values: The values of this CreatePropertyDetails.
        :type: list[str]
        """
        self._values = values

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreatePropertyDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreatePropertyDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreatePropertyDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreatePropertyDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreatePropertyDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreatePropertyDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreatePropertyDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreatePropertyDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
