# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InputArgument(object):
    """
    The details of the Input argument.
    """

    #: A constant which can be used with the type property of a InputArgument.
    #: This constant has a value of "STRING"
    TYPE_STRING = "STRING"

    #: A constant which can be used with the type property of a InputArgument.
    #: This constant has a value of "OUTPUT_VARIABLE"
    TYPE_OUTPUT_VARIABLE = "OUTPUT_VARIABLE"

    #: A constant which can be used with the type property of a InputArgument.
    #: This constant has a value of "FILE"
    TYPE_FILE = "FILE"

    def __init__(self, **kwargs):
        """
        Initializes a new InputArgument object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.fleet_apps_management.models.OutputVariableInputArgument`
        * :class:`~oci.fleet_apps_management.models.StringInputArgument`
        * :class:`~oci.fleet_apps_management.models.FileInputArgument`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this InputArgument.
            Allowed values for this property are: "STRING", "OUTPUT_VARIABLE", "FILE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param name:
            The value to assign to the name property of this InputArgument.
        :type name: str

        :param description:
            The value to assign to the description property of this InputArgument.
        :type description: str

        """
        self.swagger_types = {
            'type': 'str',
            'name': 'str',
            'description': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'name': 'name',
            'description': 'description'
        }
        self._type = None
        self._name = None
        self._description = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'OUTPUT_VARIABLE':
            return 'OutputVariableInputArgument'

        if type == 'STRING':
            return 'StringInputArgument'

        if type == 'FILE':
            return 'FileInputArgument'
        else:
            return 'InputArgument'

    @property
    def type(self):
        """
        **[Required]** Gets the type of this InputArgument.
        Input argument Type.

        Allowed values for this property are: "STRING", "OUTPUT_VARIABLE", "FILE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this InputArgument.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this InputArgument.
        Input argument Type.


        :param type: The type of this InputArgument.
        :type: str
        """
        allowed_values = ["STRING", "OUTPUT_VARIABLE", "FILE"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def name(self):
        """
        **[Required]** Gets the name of this InputArgument.
        The name of the argument.


        :return: The name of this InputArgument.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this InputArgument.
        The name of the argument.


        :param name: The name of this InputArgument.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this InputArgument.
        The description of the argument.


        :return: The description of this InputArgument.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this InputArgument.
        The description of the argument.


        :param description: The description of this InputArgument.
        :type: str
        """
        self._description = description

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
