# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .base_variable import BaseVariable
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LogAnalyticsScheduledTasks(BaseVariable):
    """
    Log analytics scheduled task.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new LogAnalyticsScheduledTasks object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.LogAnalyticsScheduledTasks.type` attribute
        of this class is ``OCI_LOGAN_SCHEDULEDTASK_ID`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this LogAnalyticsScheduledTasks.
            Allowed values for this property are: "ARRAY", "BOOLEAN", "ENUM", "INTEGER", "NUMBER", "STRING", "TEXT", "FILE", "PASSWORD", "DATETIME", "DUMMY", "OCI_IDENTITY_DOMAINS_ID", "OCI_CORE_IMAGE_ID", "OCI_CORE_INSTANCESHAPEWITHFLEX_NAME", "OCI_CORE_INSTANCESHAPE_NAME", "OCI_CORE_NATGATEWAY_ID", "OCI_CORE_INSTANCE_ID", "OCI_CORE_SUBNET_ID", "OCI_CORE_SERVICEGATEWAY_ID", "OCI_LOGAN_LOGGROUP_ID", "OCI_LOGAN_SCHEDULEDTASK_ID", "OCI_LOGAN_LOGENTITY_ID", "OCI_LOGAN_ENTITYTYPE_ID", "OCI_MGMT_AGENT_ID", "OCI_LOGAN_SOURCE_ID", "OCI_CORE_NSG_ID", "OCI_CORE_VCN_ID", "OCI_IDENTITY_AVAILABILITYDOMAIN_NAME", "OCI_IDENTITY_COMPARTMENT_ID", "OCI_IDENTITY_FAULTDOMAIN_NAME", "OCI_IDENTITY_REGION_NAME", "OCI_DATABASE_DBSYSTEM_ID", "OCI_DATABASE_DBHOME_ID", "OCI_DATABASE_DBHOME_DBVERSION", "OCI_DATABASE_DATABASE_ID", "OCI_DATABASE_AUTONOMOUSDATABASE_ID", "OCI_DATABASE_AUTONOMOUSDATABASEVERSION_ID", "OCI_DATABASE_AUTONOMOUSCONTAINERDATABASE_ID", "OCI_KMS_KEY_ID", "OCI_KMS_SECRET_ID", "OCI_CONTAINER_CLUSTER_ID", "OCI_KUBERNETES_VERSIONS_ID", "OCI_BLOCKSTORAGE_POLICIES_ID", "OCI_IDENTITY_GROUPS_ID", "OCI_IDENTITY_DYNAMICGROUPS_ID", "OCI_LOADBALANCER_LOADBALANCER_ID", "OCI_MOUNT_TARGET_ID", "OCI_IDENTITY_TAG_VALUE", "OCI_ODS_PROJECT_ID", "OCI_RESOURCEMANAGER_PRIVATEENDPOINT_ID", "OCI_APM_DOMAIN_ID", "OCI_CORE_SSH_PUBLICKEY", "OCI_KMS_VAULT_ID", "OCI_LOADBALANCER_NETWORKLOADBALANCER_ID", "OCI_LOADBALANCER_LOADBALANCER_RESERVEDIPS_ID", "OCI_DATABASE_MYSQL_SHAPE_ID", "OCI_DATABASE_MYSQL_CONFIGURATION_ID", "OCI_STORAGE_FILESTORAGE_EXPORTSET_ID", "OCI_STORAGE_FILESTORAGE_FILESYSTEM_ID", "OCI_STORAGE_OBJECTSTORAGE_BUCKET_NAME", "OCI_CORE_VCN_SECLIST_ID", "OCI_CORE_VOLUME_ID", "OCI_DATABASE_DATAGUARD_ID", "OCI_DATABASE_EXADATA_ID", "OCI_DATABASE_CLOUDVMCLUSTER_ID", "OCI_DATABASE_CDB_ID", "OCI_DATABASE_DATAGUARDASSOCIATION_ID", "OCI_DATABASE_DBNODE_ID", "OCI_CORE_VCN_NETWORKSECURITYGROUP_ID", "OCI_STORAGE_FILESTORAGE_MOUNTTARGET_ID"
        :type type: str

        :param title:
            The value to assign to the title property of this LogAnalyticsScheduledTasks.
        :type title: str

        :param description:
            The value to assign to the description property of this LogAnalyticsScheduledTasks.
        :type description: str

        :param is_required:
            The value to assign to the is_required property of this LogAnalyticsScheduledTasks.
        :type is_required: bool

        :param visible:
            The value to assign to the visible property of this LogAnalyticsScheduledTasks.
        :type visible: str

        :param depends_on:
            The value to assign to the depends_on property of this LogAnalyticsScheduledTasks.
        :type depends_on: oci.fleet_apps_management.models.LogAnalyticsScheduledTasksDependsOn

        """
        self.swagger_types = {
            'type': 'str',
            'title': 'str',
            'description': 'str',
            'is_required': 'bool',
            'visible': 'str',
            'depends_on': 'LogAnalyticsScheduledTasksDependsOn'
        }
        self.attribute_map = {
            'type': 'type',
            'title': 'title',
            'description': 'description',
            'is_required': 'isRequired',
            'visible': 'visible',
            'depends_on': 'dependsOn'
        }
        self._type = None
        self._title = None
        self._description = None
        self._is_required = None
        self._visible = None
        self._depends_on = None
        self._type = 'OCI_LOGAN_SCHEDULEDTASK_ID'

    @property
    def depends_on(self):
        """
        Gets the depends_on of this LogAnalyticsScheduledTasks.

        :return: The depends_on of this LogAnalyticsScheduledTasks.
        :rtype: oci.fleet_apps_management.models.LogAnalyticsScheduledTasksDependsOn
        """
        return self._depends_on

    @depends_on.setter
    def depends_on(self, depends_on):
        """
        Sets the depends_on of this LogAnalyticsScheduledTasks.

        :param depends_on: The depends_on of this LogAnalyticsScheduledTasks.
        :type: oci.fleet_apps_management.models.LogAnalyticsScheduledTasksDependsOn
        """
        self._depends_on = depends_on

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
